<?php
/**
 * Title: Section Two
 * Slug: wens-track/section-two
 * Categories: wens-track
 *
 * @package wens-track
 * @since 1.0.0
 */

?>

<!-- wp:group {"metadata":{"name":"about"},"align":"full","style":{"spacing":{"padding":{"top":"120px","bottom":"120px"}}},"backgroundColor":"custom-color-4","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-custom-color-4-background-color has-background" style="padding-top:120px;padding-bottom:120px"><!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"left":"44px"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center","width":"45%"} -->
<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:45%"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:image {"aspectRatio":"1","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"10px"}}} -->
<figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/two.jpg" alt="" class="" style="border-radius:10px;aspect-ratio:1;object-fit:cover"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:heading {"level":6,"className":"heading","style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-2"}}}},"textColor":"custom-color-2"} -->
<h6 class="wp-block-heading heading has-custom-color-2-color has-text-color has-link-color"><?php echo esc_html__( 'About', 'wens-track' ); ?>&nbsp; <?php echo esc_html__( 'Us', 'wens-track' ); ?></h6>
<!-- /wp:heading --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading -->
<h2 class="wp-block-heading"><strong><?php echo esc_html__( 'World Best Travel Agency', 'wens-track' ); ?></strong></h2>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'we believe tracking should be', 'wens-track' ); ?> <strong><?php echo esc_html__( 'simple, reliable, and transparent', 'wens-track' ); ?></strong><?php echo esc_html__( '. Our theme is designed to help logistics companies, e-commerce businesses, and customers monitor shipments with ease.', 'wens-track' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p><?php echo esc_html__( 'With a focus on', 'wens-track' ); ?> <strong><?php echo esc_html__( 'real-time updates, smart dashboards, and global accessibility', 'wens-track' ); ?></strong><?php echo esc_html__( ', we provide the perfect foundation for creating tracking websites that inspire trust.', 'wens-track' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"24px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"16px"}},"layout":{"type":"constrained"}} -->
<div id="no-wrap" class="wp-block-group"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'Discuss your commitment to excellent customer service.', 'wens-track' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"10px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group"><!-- wp:paragraph -->
<p><?php echo esc_html__( 'Share the core values that guide your business.', 'wens-track' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#"><?php echo esc_html__( 'Explore More', 'wens-track' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->