<?php
/**
 * Title: Section Three
 * Slug: wens-track/section-three
 * Categories: wens-track
 *
 * @package wens-track
 * @since 1.0.0
 */

?>

<!-- wp:group {"metadata":{"name":"trips"},"align":"full","style":{"spacing":{"blockGap":"60px"}},"backgroundColor":"custom-light-bg","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-custom-light-bg-background-color has-background"><!-- wp:cover {"url":"<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/three.jpg","hasParallax":true,"dimRatio":50,"overlayColor":"custom-color-5","isUserOverlayColor":true,"sizeSlug":"full","align":"full","style":{"spacing":{"padding":{"top":"120px","bottom":"120px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-cover alignfull has-parallax" style="padding-top:120px;padding-bottom:120px"><div class="wp-block-cover__image-background size-full has-parallax" style="background-position:50% 50%;background-image:url(<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/three.jpg)"></div><span aria-hidden="true" class="wp-block-cover__background has-custom-color-5-background-color has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:group {"style":{"spacing":{"blockGap":"12px","margin":{"bottom":"var:preset|spacing|60"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="margin-bottom:var(--wp--preset--spacing--60)"><!-- wp:heading {"textAlign":"center","level":6,"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-2"}}}},"textColor":"custom-color-2"} -->
<h6 class="wp-block-heading has-text-align-center has-custom-color-2-color has-text-color has-link-color"><?php echo esc_html__( 'Featured Trips', 'wens-track' ); ?></h6>
<!-- /wp:heading -->

<!-- wp:heading {"textAlign":"center"} -->
<h2 class="wp-block-heading has-text-align-center"><strong><?php echo esc_html__( 'Most Loved Tour Spots', 'wens-track' ); ?></strong></h2>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide"><!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide">

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"0"},"border":{"radius":"10px","width":"1px","style":"dashed"}},"backgroundColor":"base","borderColor":"custom-color-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-custom-color-2-border-color has-base-background-color has-background" style="border-style:dashed;border-width:1px;border-radius:10px"><!-- wp:image {"aspectRatio":"16/9","scale":"cover","sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":{"topLeft":"10px","topRight":"10px"}}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/four.jpg" alt="" class="" style="border-top-left-radius:10px;border-top-right-radius:10px;aspect-ratio:16/9;object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"16px","bottom":"16px","left":"24px","right":"24px"},"blockGap":"24px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:16px;padding-right:24px;padding-bottom:16px;padding-left:24px"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}},"typography":{"fontSize":"20px"}},"textColor":"custom-color-5"} -->
<p class="has-custom-color-5-color has-text-color has-link-color" style="font-size:20px"><strong><?php echo esc_html__( 'From 200.00 $', 'wens-track' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}}},"textColor":"custom-color-5","fontSize":"medium"} -->
<h2 class="wp-block-heading has-custom-color-5-color has-text-color has-link-color has-medium-font-size"><?php echo esc_html__( 'Milford Track Great Walk', 'wens-track' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}}},"textColor":"custom-color-5"} -->
<p class="has-custom-color-5-color has-text-color has-link-color"><?php echo esc_html__( 'Explore the breathtaking landscapes of the Canadian Rockies on this 10-day…', 'wens-track' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:buttons {"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}}} -->
<div class="wp-block-buttons" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:button {"style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><?php echo esc_html__( 'View Details', 'wens-track' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"0"},"border":{"radius":"10px","width":"1px","style":"dashed"}},"backgroundColor":"base","borderColor":"custom-color-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-custom-color-2-border-color has-base-background-color has-background" style="border-style:dashed;border-width:1px;border-radius:10px"><!-- wp:image {"aspectRatio":"16/9","scale":"cover","sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":{"topLeft":"10px","topRight":"10px"}}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/three.jpg" alt="" class="" style="border-top-left-radius:10px;border-top-right-radius:10px;aspect-ratio:16/9;object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"16px","bottom":"16px","left":"24px","right":"24px"},"blockGap":"24px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:16px;padding-right:24px;padding-bottom:16px;padding-left:24px"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}},"typography":{"fontSize":"20px"}},"textColor":"custom-color-5"} -->
<p class="has-custom-color-5-color has-text-color has-link-color" style="font-size:20px"><strong><?php echo esc_html__( 'From 200.00 $', 'wens-track' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}}},"textColor":"custom-color-5","fontSize":"medium"} -->
<h2 class="wp-block-heading has-custom-color-5-color has-text-color has-link-color has-medium-font-size"><?php echo esc_html__( 'Inca Trail to Machu Picchu', 'wens-track' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}}},"textColor":"custom-color-5"} -->
<p class="has-custom-color-5-color has-text-color has-link-color"><?php echo esc_html__( 'Explore the breathtaking landscapes of the Canadian Rockies on this 10-day…', 'wens-track' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:buttons {"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}}} -->
<div class="wp-block-buttons" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:button {"style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><?php echo esc_html__( 'View Details', 'wens-track' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"blockGap":"0"},"border":{"radius":"10px","width":"1px","style":"dashed"}},"backgroundColor":"base","borderColor":"custom-color-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-custom-color-2-border-color has-base-background-color has-background" style="border-style:dashed;border-width:1px;border-radius:10px"><!-- wp:image {"aspectRatio":"16/9","scale":"cover","sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":{"topLeft":"10px","topRight":"10px"}}}} -->
<figure class="wp-block-image size-large has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri() ); ?>/assets/images/five.jpg" alt="" class="" style="border-top-left-radius:10px;border-top-right-radius:10px;aspect-ratio:16/9;object-fit:cover"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"16px","bottom":"16px","left":"24px","right":"24px"},"blockGap":"24px"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-top:16px;padding-right:24px;padding-bottom:16px;padding-left:24px"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}},"typography":{"fontSize":"20px"}},"textColor":"custom-color-5"} -->
<p class="has-custom-color-5-color has-text-color has-link-color" style="font-size:20px"><strong><?php echo esc_html__( 'From 200.00 $', 'wens-track' ); ?></strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}}},"textColor":"custom-color-5","fontSize":"medium"} -->
<h2 class="wp-block-heading has-custom-color-5-color has-text-color has-link-color has-medium-font-size"><?php echo esc_html__( 'Canadian Rockies Alpine Trail', 'wens-track' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|custom-color-5"}}}},"textColor":"custom-color-5"} -->
<p class="has-custom-color-5-color has-text-color has-link-color"><?php echo esc_html__( 'Explore the breathtaking landscapes of the Canadian Rockies on this 10-day…', 'wens-track' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|20"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:buttons {"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}}} -->
<div class="wp-block-buttons" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:button {"style":{"spacing":{"padding":{"left":"0","right":"0","top":"0","bottom":"0"}}}} -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><?php echo esc_html__( 'View Details', 'wens-track' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:buttons {"align":"wide","layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons alignwide"><!-- wp:button -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#"><?php echo esc_html__( 'View All Trips', 'wens-track' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->