<?php
/**
 * Template Name: Front Page
 *
 * @package Wellness
 */
get_header(); ?>

	<div id="primary" class="content-area front-page">
		<main id="main" class="site-main" role="main">
            <?php
            $sections = wellness_get_frontpage_sections();
            foreach ( $sections as $section ) {
                $section = wp_parse_args( $section, array(
                    'section_id' => ''
                ) );
                if ( $section['section_id'] ) {
                    $function = 'wellness_'.$section['section_id'].'_section' ;
                    $hook = 'wellness_font_page_section_'.$section['section_id'];
                    if ( function_exists( $function ) ) {
                       add_action( $hook, $function );
                    }
                    do_action( $hook );
                }
            }

			while ( have_posts() ) : the_post();

				if ( get_the_content() != '' ) {
					echo '<div class="front-page-content front-page-section">';
					get_template_part( 'template-parts/content', 'page' );
					echo '</div><!-- .front-page-content -->';
				}

			endwhile; // End of the loop.
			?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_footer();
