<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Wellness
 */

function wellness_get_premium_url(){
    return esc_url('https://www.famethemes.com/themes/wellness-pro/#download_pricing');
}

if ( ! function_exists( 'wellness_is_selective_refresh' ) ) {
    function wellness_is_selective_refresh()
    {
        $check = isset($GLOBALS['wellness_is_selective_refresh']) && $GLOBALS['wellness_is_selective_refresh'] ? true : false;
        if ( ! $check ) {
            if ( is_customize_preview() && isset( $_POST['partials'] ) ) {
                $check = true;
            }
        }
        return $check;
    }
}

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function wellness_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	if ( 'left' == get_theme_mod( 'wellness_sidebar_position' ) ) {
		$classes[] = 'left-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'wellness_body_classes' );


if ( ! function_exists( 'wellness_header_style' ) ) :
 /**
  * Styles the header text displayed on the site.
  *
  * @see gatsby_custom_header_and_background().
  */
 function wellness_header_style() {
    // If the header text option is untouched, let's bail.
    if ( display_header_text() ) {
        return;
    }
    // If the header text has been hidden.
    ?>
    <style type="text/css" id="gatsby-header-css">
        .site-branding {
            margin: 0 auto 0 0;
        }
        .site-branding .site-title,
        .site-description {
            clip: rect(1px, 1px, 1px, 1px);
        }
    </style>
    <?php
 }
 endif; // wellness_header_style

/**
 * Filter the except length to 20 characters.
 *
 * @param int $length Excerpt length.
 * @return int (Maybe) modified excerpt length.
 */
function wellness_custom_excerpt_length( $length ) {
    return 20;
}
add_filter( 'excerpt_length', 'wellness_custom_excerpt_length', 999 );

/**
 * Filter the excerpt "read more" string.
 *
 * @param string $more "Read more" excerpt string.
 * @return string (Maybe) modified "read more" excerpt string.
 */
function wellness_excerpt_more( $more ) {
    return ' &hellip;';
}
add_filter( 'excerpt_more', 'wellness_excerpt_more' );

/**
 * Get random posts for any post type
 */
function wellness_get_random_posts( $number = 1, $post_type = 'post' ) {
	$query = new WP_Query( array(
		'posts_per_page' => 100,
		'fields'         => 'ids',
		'post_type'      => $post_type
	) );

	$post_ids = $query->posts;
	shuffle( $post_ids );
	$post_ids = array_splice( $post_ids, 0, $number );

	$random_posts = get_posts( array(
		'post__in'    => $post_ids,
		'numberposts' => count( $post_ids ),
		'post_type'   => $post_type
	) );

	return $random_posts;
}

/**
 * Add footer theme info
 */
function wellness_footer_credits(){

   
        $copyright_text = sprintf(esc_html__('Copyright %1$s %2$s %3$s. All Rights Reserved.', 'wellness'), '&copy;', date_i18n('Y'), get_bloginfo());
    

    ?>
    <div class=" site-info">
        <div class="container">
            <div class="site-copyright">
                <?php echo wp_filter_post_kses( $copyright_text ); ?>
            </div><!-- .site-copyright -->
            <?php if ( ! get_theme_mod( 'wellness_footer_credit' ) ) { ?>
            <div class="theme-info">
                <?php printf(esc_html__('Wellness theme by %1s.', 'wellness'), '<a href="https://www.famethemes.com/">FameThemes</a>' ); ?>
            </div>
            <?php } ?>
        </div>
    </div><!-- .site-info -->
    <?php
}
add_action( 'wellness_footer', 'wellness_footer_credits' );


function wellness_n2t($number, $sanitize = true )
{
    $result = array();
    $tens = floor($number / 10);
    $units = $number % 10;

    $words = array
    (
        'units' => array('', 'One', 'Two', 'Three', 'Four', 'Five', 'Six', 'Seven', 'Eight', 'Nine', 'Ten', 'Eleven', 'Twelve', 'Thirteen', 'Fourteen', 'Fifteen', 'Sixteen', 'Seventeen', 'Eightteen', 'Nineteen'),
        'tens' => array('', '', 'Twenty', 'Thirty', 'Fourty', 'Fifty', 'Sixty', 'Seventy', 'Eigthy', 'Ninety')
    );

    if ($tens < 2)
    {
        $result[] = $words['units'][$tens * 10 + $units];
    }

    else
    {
        $result[] = $words['tens'][$tens];

        if ($units > 0)
        {
            $result[count($result) - 1] .= '-' . $words['units'][$units];
        }
    }

    if (empty($result[0]))
    {
        $result[0] = 'Zero';
    }

    if ( $sanitize ) {
        $s = trim(implode('_', $result));
        $s = strtolower( $s );
    } else {
        $s = trim(implode(' ', $result));
    }

    return $s;
}