<?php
/*
 * @package Weight Loss Club
 */


 function weight_loss_club_admin_enqueue_scripts() {
    wp_enqueue_style( 'weight-loss-club-admin-style', esc_url( get_template_directory_uri() ).'/css/addon.css' );
}
add_action( 'admin_enqueue_scripts', 'weight_loss_club_admin_enqueue_scripts' );

function weight_loss_club_theme_info_menu_link() {

    $weight_loss_club_theme = wp_get_theme();
    add_theme_page(
        sprintf( esc_html__( 'Welcome to %1$s', 'weight-loss-club' ), $weight_loss_club_theme->get( 'Name' )),
        esc_html__( 'Theme Demo Import', 'weight-loss-club' ),
        'edit_theme_options',
        'weight-loss-club',
        'weight_loss_club_theme_info_page'
    );
}
add_action( 'admin_menu', 'weight_loss_club_theme_info_menu_link' );

function weight_loss_club_theme_info_page() {

    $weight_loss_club_theme = wp_get_theme();
    ?>
<div class="wrap theme-info-wrap">
    <h1><?php printf( esc_html__( 'Welcome to %1$s', 'weight-loss-club' ), esc_html($weight_loss_club_theme->get( 'Name' ))); ?>
    </h1>
    <p class="theme-description">
    <?php esc_html_e( 'Do you want to configure this theme? Look no further, our easy-to-follow theme documentation will walk you through it.', 'weight-loss-club' ); ?>
    </p>
    <div class="columns-wrapper clearfix theme-demo">
        <div class="column column-quarter clearfix start-box"> 
            <div class="demo-import">
                <div class="theme-name">
                    <h2><?php echo esc_html( $weight_loss_club_theme->get( 'Name' ) ); ?></h2>
                    <p class="version"><?php esc_html_e( 'Version', 'weight-loss-club' ); ?>: <?php echo esc_html( wp_get_theme()->get( 'Version' ) ); ?></p>	
                </div>
                <?php
                    $weight_loss_club_demo_content_file = apply_filters(
                        'weight_loss_club_demo_content_path',
                        get_parent_theme_file_path( '/inc/demo-content.php' )
                    );
                    require $weight_loss_club_demo_content_file;             
                ?>               
                <div id="demo-import-loader">
                    <img src="<?php echo esc_url(get_template_directory_uri() . '/images/status.gif'); ?>" alt="<?php echo esc_attr( 'Loading...', 'weight-loss-club'); ?>" />
                </div>
            </div>
        </div>
        <div class="column column-first clearfix">
            <div class="important-link">
                <div class="main-box columns-wrapper clearfix">
                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Pro version of our theme', 'weight-loss-club' ); ?></strong></p>
                        <p><?php esc_html_e( 'Are you excited for our theme? Then we will proceed for pro version of theme.', 'weight-loss-club' ); ?></p>
                        <a class="get-premium" href="<?php echo esc_url( WEIGHT_LOSS_CLUB_PREMIUM_PAGE ); ?>" target="_blank">
                        <?php esc_html_e( 'Go To Premium', 'weight-loss-club' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Need Help?', 'weight-loss-club' ); ?></strong></p>
                        <p><?php esc_html_e( 'Go to our support forum to help you out in case of queries and doubts regarding our theme.', 'weight-loss-club' ); ?></p>
                        <a href="<?php echo esc_url( WEIGHT_LOSS_CLUB_SUPPORT ); ?>" target="_blank">
                        <?php esc_html_e( 'Contact Us', 'weight-loss-club' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Check Our Demo', 'weight-loss-club' ); ?></strong></p>
                        <p><?php esc_html_e( 'Here, you can view a live demonstration of our premium theme.', 'weight-loss-club' ); ?></p>
                        <a href="<?php echo esc_url( WEIGHT_LOSS_CLUB_PRO_DEMO ); ?>" target="_blank">
                        <?php esc_html_e( 'Premium Demo', 'weight-loss-club' ); ?>
                        </a>
                    </div>
                </div>
                <hr>
                <div class="main-box columns-wrapper clearfix">
                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Check all classic features', 'weight-loss-club' ); ?></strong></p>
                        <p><?php esc_html_e( 'Explore all our 90+ Premium Themes Collections', 'weight-loss-club' ); ?></p>
                        <a href="<?php echo esc_url( WEIGHT_LOSS_CLUB_THEME_PAGE ); ?>" target="_blank">
                        <?php esc_html_e( 'Theme Page', 'weight-loss-club' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Leave us a review', 'weight-loss-club' ); ?></strong></p>
                        <p><?php esc_html_e( 'Are you enjoying our theme? We would love to hear your feedback.', 'weight-loss-club' ); ?></p>
                        <a href="<?php echo esc_url( WEIGHT_LOSS_CLUB_REVIEW ); ?>" target="_blank">
                        <?php esc_html_e( 'Rate This Theme', 'weight-loss-club' ); ?>
                        </a>
                    </div>

                    <div class="themelink column column-third clearfix">
                        <p><strong><?php esc_html_e( 'Theme Documentation', 'weight-loss-club' ); ?></strong></p>
                        <p><?php esc_html_e( 'Need more details? Please check our full documentation for detailed theme setup.', 'weight-loss-club' ); ?></p>
                        <a href="<?php echo esc_url( WEIGHT_LOSS_CLUB_THEME_DOCUMENTATION ); ?>" target="_blank">
                        <?php esc_html_e( 'Documentation', 'weight-loss-club' ); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="getting-started">
        <div class="section">
            <h3><?php printf( esc_html__( 'Getting started with %s', 'weight-loss-club' ),
            esc_html($weight_loss_club_theme->get( 'Name' ))); ?></h3>
            <div class="columns-wrapper clearfix">
                <div class="column column-half clearfix">
                    <div class="section themelink">
                        <div class="">
                            <a class="" href="<?php echo esc_url( WEIGHT_LOSS_CLUB_PREMIUM_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Get Premium', 'weight-loss-club' ); ?></a>
                            <a href="<?php echo esc_url( WEIGHT_LOSS_CLUB_PRO_DEMO ); ?>" target="_blank"><?php esc_html_e( 'View Demo', 'weight-loss-club' ); ?></a>
                            <a class="get-premium" href="<?php echo esc_url( WEIGHT_LOSS_CLUB_BUNDLE_PAGE ); ?>" target="_blank"><?php esc_html_e( 'Bundle of 90+ Themes at $99', 'weight-loss-club' ); ?></a>
                        </div>
                        <div class="theme-description-1"><?php echo esc_html($weight_loss_club_theme->get( 'Description' )); ?></div>
                    </div>
                </div>
                <div class="column column-half clearfix">
                    <img src="<?php echo esc_url( $weight_loss_club_theme->get_screenshot() ); ?>" alt=""/>
                </div>
            </div>
        </div>
    </div>
    <hr>
    <div id="theme-author">
      <p><?php
        printf( esc_html__( '%1$s is proudly brought to you by %2$s. If you like this theme, %3$s :)', 'weight-loss-club' ),
            esc_html($weight_loss_club_theme->get( 'Name' )),
            '<a target="_blank" href="' . esc_url( 'https://www.theclassictemplates.com/', 'weight-loss-club' ) . '">classictemplate</a>',
            '<a target="_blank" href="' . esc_url(WEIGHT_LOSS_CLUB_REVIEW ) . '" title="' . esc_attr__( 'Rate it', 'weight-loss-club' ) . '">' . esc_html_x( 'rate it', 'If you like this theme, rate it', 'weight-loss-club' ) . '</a>'
        );
        ?></p>
    </div>
</div>
<?php
}
?>