<?php
// Set Panel ID
$panel_id = 'weh_lite_social_options';

// Set prefix
$prefix = 'weh_lite';

/***********************************************/
/**************** CONTACT US  ******************/
/***********************************************/

$wp_customize->add_panel( $panel_id,
    array(
        'priority'          => 109,
        'capability'        => 'edit_theme_options',
        'theme_supports'    => '',
        'title'             => __( 'Social Profile Links', 'weh-lite' ),
        'description'       => __( 'Control various options for contact us section from front page.', 'weh-lite' ),
    )
);

    /***********************************************/
    /************** Contact Details  ***************/
    /***********************************************/


    $wp_customize->add_section( $prefix.'_social_section' ,
        array(
            'title'         => __( 'Social Links', 'weh-lite' ),
            'description'   => __( 'These are the contact details displayed in the Contact us section from front page.', 'weh-lite' ),
            'priority'      => 3,
            'panel'         => $panel_id
        )
    );

    /* Twitter URL */
    $wp_customize->add_setting( $prefix.'_twitter_url',
        array(
            'sanitize_callback'  => 'esc_url_raw',
            'default'            =>  esc_url_raw('#'),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_twitter_url',
        array(
            'label'          => __( 'Twitter URL', 'weh-lite' ),
            'description'    => __('Will be displayed in the contact section from front page.', 'weh-lite'),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_twitter_url',
            'priority'       => 10
        )
    );

    /* Twitter Text */
    $wp_customize->add_setting( $prefix.'_twitter_text',
        array(
            'sanitize_callback'  => 'weh_sanitize_html',
            'default'            => __( 'Follow us', 'weh-lite' ),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_twitter_text',
        array(
            'label'          => __( 'Twitter Text', 'weh-lite' ),
            'description'    => __('Will be displayed beside social icon.', 'weh-lite'),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_twitter_text',
            'priority'       => 10
        )
    );

    /* Google+ URL */
    $wp_customize->add_setting( $prefix.'_googlep_url',
        array(
            'sanitize_callback'  => 'esc_url_raw',
            'default'            => esc_url_raw('#'),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_googlep_url',
        array(
            'label'          => __( 'Google+ URL', 'weh-lite' ),
            'description'    => __('Will be displayed in the contact section from front page.', 'weh-lite'),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_googlep_url',
            'priority'       => 10
        )
    );

    /* Google+ Text */
    $wp_customize->add_setting( $prefix.'_googlep_text',
        array(
            'sanitize_callback'  => 'weh_sanitize_html',
            'default'            => __( 'Follow us', 'weh-lite' ),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_googlep_text',
        array(
            'label'          => __( 'Google+ Text', 'weh-lite' ),
            'description'    => __('Will be displayed beside social icon.', 'weh-lite'),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_googlep_text',
            'priority'       => 10
        )
    );

    /* Facebook URL */
    $wp_customize->add_setting( $prefix.'_facebook_url',
        array(
            'sanitize_callback'  => 'esc_url_raw',
            'default'            =>  esc_url_raw('#'),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_facebook_url',
        array(
            'label'          => __( 'Facebook URL', 'weh-lite' ),
            'description'    => __( 'Will be displayed in the contact section from front page.', 'weh-lite' ),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_facebook_url',
            'priority'       => 10
        )
    );

    /* Facebook Text */
    $wp_customize->add_setting( $prefix.'_facebook_text',
        array(
            'sanitize_callback'  => 'weh_sanitize_html',
            'default'            => __( 'Follow us', 'weh-lite' ),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_facebook_text',
        array(
            'label'          => __( 'Facebook Text', 'weh-lite' ),
            'description'    => __('Will be displayed beside social icon.', 'weh-lite'),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_facebook_text',
            'priority'       => 10
        )
    );


    /* LinkedIN URL */
    $wp_customize->add_setting( $prefix.'_linkedin_url',
        array(
            'sanitize_callback'  => 'esc_url_raw',
            'default'            => esc_url_raw('#'),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_linkedin_url',
        array(
            'label'          => __( 'LinkedIN URL', 'weh-lite' ),
            'description'    => __('Will be displayed in the contact section from front page.', 'weh-lite'),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_linkedin_url',
            'priority'       => 10
        )
    );

    /* LinkedIN Text */
    $wp_customize->add_setting( $prefix.'_linkedin_text',
        array(
            'sanitize_callback'  => 'weh_sanitize_html',
            'default'            => __( 'Follow us', 'weh-lite' ),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_linkedin_text',
        array(
            'label'          => __( 'LinkedIn Text', 'weh-lite' ),
            'description'    => __('Will be displayed beside social icon.', 'weh-lite'),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_linkedin_text',
            'priority'       => 10
        )
    );

	/* Pinterest URL */
	$wp_customize->add_setting( $prefix.'_pinterest_url',
		array(
			'sanitize_callback'  => 'esc_url_raw',
			'default'            => esc_url_raw('#'),
			'transport'          => 'postMessage'
		)
	);

	$wp_customize->add_control( $prefix.'_pinterest_url',
		array(
			'label'          => __( 'Pinterest URL', 'weh-lite' ),
			'description'    => __('Will be displayed in the contact section from front page.', 'weh-lite'),
			'section'        => $prefix.'_social_section',
			'settings'       => $prefix.'_pinterest_url',
			'priority'       => 10
		)
	);

    /* Pinterest Text */
    $wp_customize->add_setting( $prefix.'_pinterest_text',
        array(
            'sanitize_callback'  => 'weh_sanitize_html',
            'default'            => __( 'Follow us', 'weh-lite' ),
            'transport'          => 'postMessage'
        )
    );

    $wp_customize->add_control( $prefix.'_pinterest_text',
        array(
            'label'          => __( 'Pinterest Text', 'weh-lite' ),
            'description'    => __('Will be displayed beside social icon.', 'weh-lite'),
            'section'        => $prefix.'_social_section',
            'settings'       => $prefix.'_pinterest_text',
            'priority'       => 10
        )
    );