<?php

class WEH_LITE_Category_Customize_Control extends WP_Customize_Control {
    /**
     * Render the control's content.
     *
     * @since 3.4.0
     */
    public function render_content() {
        $dropdown = wp_dropdown_categories(
            array(
                'name'              => '_customize-dropdown-categories-' . $this->id,
                'echo'              => 0,
                'show_option_none'  => esc_html__( '&mdash; Select &mdash;', 'weh-lite'),
                'option_none_value' => '0',
                'selected'          => $this->value(),
            )
        );

        // Hackily add in the data link parameter.
        $dropdown = str_replace( '<select', '<select ' . $this->get_link(), $dropdown );

        printf(
            '<label class="customize-control-select"><span class="customize-control-title">%s</span> %s</label>',
            $this->label,
            $dropdown
        );
    }
}

$wp_customize->add_section('weh_lite_upgrade', array('title' => esc_html__('Upgrade to Premium', 'weh-lite'), 'capability' => 'edit_theme_options', 'theme_supports' => '', 'priority' => 2));
	$wp_customize->add_section(
	    'tcx_category',
	    array(
	        'title'     => 'Category for Photostack',
	        'priority'  => 202
	    )
	);

	$wp_customize->add_setting('tcx_category', array('sanitize_callback' => 'esc_attr')
	);

	$wp_customize->add_control(
	    new WEH_LITE_Category_Customize_Control(
	        $wp_customize,
	        'tcx_category',
	        array(
	            'label'    => 'Category',
	            'settings' => 'tcx_category',
	            'section'  => 'tcx_category'
	        )
	    )
	);