<?php
// Set Panel ID
$panel_id = 'weh_lite_panel_general';

// Set prefix
$prefix = 'weh_lite';


// Change panel for Colors
$site_bg_color        = $wp_customize->get_section( 'colors' );
$site_bg_color->panel = $panel_id;
$site_bg_color->title = esc_html__( 'Background Color', 'weh-lite' );
$site_bg_color->priority = 4;

// Change panel for Background Image
$site_bg_img        = $wp_customize->get_section( 'background_image' );
$site_bg_img->panel = $panel_id;
$site_bg_img->priority = 5;

// Change panel for Static Front Page
$site_title        = $wp_customize->get_section( 'static_front_page' );
$site_title->panel = $panel_id;

// Change Logo section
$site_logo              = $wp_customize->get_control( 'custom_logo' );
$site_logo->description = esc_html__( 'The site logo is used as a graphical representation of your company name. Recommended size: 105 (width) x 75 (height) pixels(px).', 'weh-lite' );
$site_logo->label       = esc_html__( 'Site logo', 'weh-lite' );
$site_logo->section     = $prefix . '_general_logo_section';
$site_logo->priority    = 1;

// Change site icon section
$site_icon           = $wp_customize->get_control( 'site_icon' );
$site_icon->section  = $prefix . '_general_logo_section';
$site_icon->priority = 2;

// Change panel for Static Front Page
$bocah        = $wp_customize->get_section( 'title_tagline' );
$bocah->panel = $panel_id;
$bocah->priority    = 1;

/***********************************************/
/************** GENERAL OPTIONS  ***************/
/***********************************************/


$wp_customize->add_panel( $panel_id, array(
	'priority'       => 1,
	'capability'     => 'edit_theme_options',
	'theme_supports' => '',
	'title'          => esc_html__( 'General Options', 'weh-lite' ),
	'description'    => esc_html__( 'You can change the site layout in this area as well as your contact details (the ones displayed in the header & footer) ', 'weh-lite' ),
) );

/***********************************************/
/*********** Logo section  ************/
/***********************************************/

$wp_customize->add_section( $prefix . '_general_logo_section', array(
	'title'    => esc_html__( 'Logo', 'weh-lite' ),
	'priority' => 2,
	'panel'    => $panel_id,
) );


/***********************************************/
/************** Footer Details  ***************/
/***********************************************/
$wp_customize->add_section( $prefix . '_general_footer_section', array(
	'title'       => esc_html__( 'Footer Section', 'weh-lite' ),
	'description' => esc_html__( 'Change the footer copyright and widgets area column.', 'weh-lite' ),
	'priority'    => 3,
	'panel'       => $panel_id,
) );

/* Footer Copyright */
$wp_customize->add_setting( $prefix . '_footer_copyright', array(
	'sanitize_callback' => 'weh_lite_sanitize_html',
	'default'           => esc_html__( '&copy; Copyright 2016. All Rights Reserved.', 'weh-lite' ),
	'transport'         => 'postMessage',
) );

$wp_customize->add_control( $prefix . '_footer_copyright', array(
	'label'       => esc_html__( 'Footer Copyright', 'weh-lite' ),
	'description' => esc_html__( 'Use this to display your company copyright message.', 'weh-lite' ),
	'section'     => $prefix . '_general_footer_section',
	'priority'    => 2,
) );

$wp_customize->add_setting( $prefix . '_widget_select', array(
	'sanitize_callback' => 'weh_lite_sanitize_select',
	'default'           => 1,
) );

$wp_customize->add_control( $prefix . '_widget_select', array(
	'label'         => esc_html__( 'Footer Widget Column', 'weh-lite' ),
    'type'          => 'select',
    'section'     => $prefix . '_general_footer_section',
    'choices'       => array(
        1   => esc_html__( 'One Column', 'weh-lite' ),
        2   => esc_html__( 'Two Column', 'weh-lite' ),
        3   => esc_html__( 'Theree Column', 'weh-lite' ),
        4   => esc_html__( 'Four Column', 'weh-lite' ),
    ),
    'priority' => 8,
) );