<?php 


//EXCERPT

function weh_lite_custom_excerpt_length( $length ) {
	return 40;
}
add_filter( 'excerpt_length', 'weh_lite_custom_excerpt_length', 999 );

function weh_lite_new_excerpt_more( $more ) {
	return '...';
}
add_filter('excerpt_more', 'weh_lite_new_excerpt_more');




function weh_lite_excerpt(){
global $post;
	?> 
	<div class="akmanda-excerpt entry-content" itemprop="text"> 
	<?php
		the_excerpt();
		weh_lite_comments(); weh_lite_author();
	 ?>
		<div class="more-button">
			<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="more"><?php esc_html_e( 'Continue Reading' , 'weh-lite' ); ?></a>
		</div>

	</div>
<?php }

//POST TITLE

function weh_lite_post_title(){ ?> 
	
	<?php if (!is_singular()) { ?>
	<div class="post-title">
		<h2 class="entry-title text-center" itemprop="headline"><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
	</div><!-- post-title --> 
	<?php }
	else { ?>
	<div class="post-title">
		<h1 class="entry-title text-center" itemprop="headline"><?php the_title(); ?></h1>
	</div><!-- post-title --> 
	<?php }
}

function weh_lite_page_title(){ ?>
	<div class="page-title">
		<h2>
			<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a>
		</h2>					 
	</div><!-- post-title --> 
<?php }

//POST THUMBNAIL

function weh_lite_post_thumbnail(){

	if ( has_post_thumbnail()) {
		$real_image = get_post_thumbnail_id();
		$image_url = wp_get_attachment_image_src( $real_image, 'full'); 
		$image_meta = wp_get_attachment_metadata( $real_image );
		$image_width = $image_meta["width"];
		$image_height = $image_meta["height"];
	?>

	<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>">
		<div class="post-thumb">
			<div itemprop="image" itemscope itemtype="https://schema.org/ImageObject">
				<img class="singleimg" src="<?php echo esc_url($image_url[0]) ?>">
				<meta itemprop="url" content="<?php echo esc_url( $image_url[0] ); ?>">
				<?php echo '<meta itemprop="width" content="'.$image_width.'"><meta itemprop="height" content="'.$image_height.'">'; ?>
			</div>
		</div><!-- post thumb -->
	</a>

	<?php } 
}

//CONTENT

function weh_lite_content() {
	global $post;

	if (is_singular() && $post->post_content !== '') { ?>

		<div class="inner-content entry-content" itemprop="text">
			<?php 
			the_content();
			wp_link_pages();
			weh_lite_tags();
			?>
		</div>


	<?php } if (!is_singular()) { 
		weh_lite_excerpt();
	}
}