<?php
/**
 * Getting started template
 */

$customizer_url = wp_customize_url() ;
?>

<div id="getting_started" class="weh-tab-pane active">

<div class="content-info-about">

	<div class="intro-head">
		<h1 class="weh-welcome-title"><?php _e('Welcome to Weh!', 'weh-lite'); ?> <?php if( !empty($weh_lite['Version']) ): ?> <sup id="weh-theme-version"><?php echo esc_attr( $weh_lite['Version'] ); ?> </sup><?php endif; ?></h1>
		<p><?php esc_html_e( 'We want to make sure you have the best experience using weh and that is why we gathered here all the necessary information for you. We hope you will enjoy using weh, as much as we enjoy creating great products.', 'weh-lite' ); ?>
	</div>

	<div class="weh-tab-pane-center column column-3">
		<div class="inner-info">
			<h1><?php esc_html_e( 'Getting started', 'weh-lite' ); ?></h1>

			<h4><?php esc_html_e( 'Customize everything in a single place.' ,'weh-lite' ); ?></h4>
			<p><?php esc_html_e( 'Using the WordPress Customizer you can easily customize every aspect of the theme.', 'weh-lite' ); ?></p>
			<p><a href="<?php echo esc_url( $customizer_url ); ?>" class="button button-primary"><?php esc_html_e( 'Go to Customizer', 'weh-lite' ); ?></a></p>
		</div>
	</div>

	<div class="weh-tab-pane-center column column-3">
		<div class="inner-info">
			<h1><?php esc_html_e( 'Need more features?', 'weh-lite' ); ?></h1>

			<h4><?php esc_html_e( 'Check our premium version for this theme.' ,'weh-lite' ); ?></h4>
			<p><?php esc_html_e( 'Check out the Premium version of this theme which comes with additional features and advanced customization.', 'weh-lite' ); ?></p>
			<p><a href="<?php $my_theme = wp_get_theme(); echo $my_theme->get( 'AuthorURI' ); ?>/products/wordpress-themes/weh/" class="button button-primary"><?php esc_html_e( 'Learn Premium Version', 'weh-lite' ); ?></a></p>
		</div>
	</div>

	<div class="weh-tab-pane-center column column-3">
		<div class="inner-info">
			<h1><?php esc_html_e( 'Documentation', 'weh-lite' ); ?></h1>

			<h4><?php esc_html_e( 'How to install this theme with a minutes.' ,'weh-lite' ); ?></h4>
			<p><?php esc_html_e( 'Please read our online documentation page to setup this theme. Install from clean WordPress within a minutes.', 'weh-lite' ); ?></p>
			<p><a href="https://themesawesome.zendesk.com/hc/en-us/categories/200206500-Weh" class="button button-primary"><?php esc_html_e( 'Read Documentation', 'weh-lite' ); ?></a></p>
		</div>
	</div>
</div>
</div>
