<?php

define('WEH_LITE_DIR', get_template_directory_uri());
define('WEH_LITE_TEMPLATE_DIR', get_template_directory());

//Set the content width based on the theme's design and stylesheet.
if ( ! isset( $content_width ) )
	$content_width = 1170; /* pixels */

/*-----------------------------------------------------------------------------------*/
/*  SETUP THEME
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'weh_lite_setup' ) ) :

	function weh_lite_setup() {
		// several theme support
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'custom-background' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form' ) );	
		add_theme_support( 'html5', array( 'gallery', 'caption' ) );
		load_theme_textdomain( 'weh-lite', WEH_LITE_TEMPLATE_DIR .'/languages' );
		add_image_size('weh-lite-photostack', 240, 240, array( 'top', 'top' ));
		add_theme_support( "title-tag" );
		add_theme_support( 'custom-logo', array(
            'flex-width'  => true,
            'flex-height' => true,
        ) );

        /*******************************************/
	    /*************  Welcome screen *************/
	    /*******************************************/

	    if ( is_admin() ) {

	        require WEH_LITE_TEMPLATE_DIR . '/inc/admin/about-theme/about-theme.php';
	    }
}
endif;
add_action( 'after_setup_theme', 'weh_lite_setup' );


/*-----------------------------------------------------------------------------------*/
/*  SCRIPTS & STYLES
/*-----------------------------------------------------------------------------------*/

function weh_lite_scripts() {

//All necessary CSS
wp_enqueue_style( 'weh-lite-bootstrap', WEH_LITE_DIR .'/css/bootstrap.min.css', array(), null );
wp_enqueue_style( 'weh-lite-plugin-css', WEH_LITE_DIR .'/css/plugin.css', array(), null );
wp_enqueue_style( 'weh-lite-style', get_stylesheet_uri(), array( 'weh-lite-bootstrap','weh-lite-plugin-css' ) );
wp_enqueue_style( 'weh-lite-font', WEH_LITE_DIR .'/css/font.css', array(), null );

//All Necessary Script
wp_enqueue_script( 'weh-lite-modernizr', WEH_LITE_DIR. '/js/modernizr.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'weh-lite-respond', WEH_LITE_DIR. '/js/respond.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'weh-lite-fitvids', WEH_LITE_DIR. '/js/fitVids.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'weh-lite-smartmenus', WEH_LITE_DIR. '/js/smartmenus.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'weh-lite-admin-script-js', WEH_LITE_DIR. '/js/admin-script.js', array( 'jquery' ), '', true );
wp_enqueue_script( 'weh-lite-main-js', WEH_LITE_DIR. '/js/main.js', array( 'jquery' ), '', true );
}

add_action( 'wp_enqueue_scripts', 'weh_lite_scripts' );

function weh_photostack_getpart_layout( $slug, $name ){
  if( $name == 'photostack' ){
	wp_enqueue_script( 'weh-lite-classie', WEH_LITE_DIR. '/js/classie.js', array( 'jquery' ), '', true );
	wp_enqueue_script( 'weh-lite-photostack', WEH_LITE_DIR. '/js/photostack.js', array( 'jquery' ), '', true );
  }
}

add_action( 'get_template_part_inc/part/layout', 'weh_photostack_getpart_layout', 10, 2);





add_action( 'wp_enqueue_scripts', 'weh_lite_comment_reply' );
function weh_lite_comment_reply(){
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
		}
		
}

/*-----------------------------------------------------------------------------------*/
/*  FONT SCRIPTS
/*-----------------------------------------------------------------------------------*/

function weh_lite_font_setup() {
    $fonts_url = '';
 
    /* Translators: If there are characters in your language that are not
    * supported by Patua One, translate this to 'off'. Do not translate
    * into your own language.
    */
    $patuaone = _x( 'on', 'Patua One font: on or off', 'weh-lite' );
 
    /* Translators: If there are characters in your language that are not
    * supported by Droid Sans, translate this to 'off'. Do not translate
    * into your own language.
    */
    $droidsans = _x( 'on', 'Droid Sans font: on or off', 'weh-lite' );
 
    if ( 'off' !== $patuaone || 'off' !== $droidsans ) {
        $font_families = array();
 
        if ( 'off' !== $patuaone ) {
            $font_families[] = 'Patua One:400';
        }
 
        if ( 'off' !== $droidsans ) {
            $font_families[] = 'Droid Sans:400,700';
        }
 
        $query_args = array(
            'family' => urlencode( implode( '|', $font_families ) ),
            'subset' => urlencode( 'latin,latin-ext' ),
        );
 
        $fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
    }
 
    return esc_url_raw( $fonts_url );
}

function weh_lite_font_scripts() {
    wp_enqueue_style( 'weh-slug-fonts', weh_lite_font_setup(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'weh_lite_font_scripts' );

/*-----------------------------------------------------------------------------------*/
/*  MENU
/*-----------------------------------------------------------------------------------*/

//Register Menus
add_action( 'after_setup_theme', 'weh_lite_register_my_menu' );
function weh_lite_register_my_menu() {
  register_nav_menu( 'header-menu', __( 'Header Menu', 'weh-lite' ) );
}

//TOP MENU
function weh_lite_top_nav_menu(){
  wp_nav_menu( array(
	'theme_location' => 'header-menu',
	'container'       => 'ul',
   'menu_class'      => 'sm sm-clean',
	'fallback_cb'  => 'weh_lite_header_menu_cb'
  ));
}

// FALLBACK IF PRIMARY MENU HAVEN'T SET YET
function weh_lite_header_menu_cb() {
  echo '<ul id="menu-top-menu" class="sm sm-clean">';
  wp_list_pages('title_li=');
  echo '</ul>';
}


/*-----------------------------------------------------------------------------------*/
/*  CUSTOM FUNCTIONS
/*-----------------------------------------------------------------------------------*/
require_once( WEH_LITE_TEMPLATE_DIR . '/inc/function/navigation.php' );
require_once( WEH_LITE_TEMPLATE_DIR . '/inc/function/comment.php' );
require_once( WEH_LITE_TEMPLATE_DIR . '/inc/function/themeta.php' );
require_once( WEH_LITE_TEMPLATE_DIR . '/inc/function/thecontent.php' );
require_once( WEH_LITE_TEMPLATE_DIR . '/inc/function/customizer.php');
require_once( WEH_LITE_TEMPLATE_DIR . '/inc/function/thefooter.php' );
require_once( WEH_LITE_TEMPLATE_DIR . '/inc/function/custom.php' );