<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>

<meta http-equiv="Content-Type" content="<?php echo esc_attr(get_bloginfo('html_type')); ?>; charset=<?php echo esc_attr(get_bloginfo('charset')); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.2, user-scalable=yes" />

<?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

<?php
	if ( function_exists( 'wp_body_open' ) )
	{
		wp_body_open();
	}else{
		do_action('wp_body_open');
	}
?>

<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'wedding-planner-lite' ); ?></a>

<?php if(get_theme_mod('wedding_planner_lite_site_loader',false)!= ''){ ?>
    <?php if(get_theme_mod( 'wedding_planner_lite_preloader_type','four-way-loader') == 'four-way-loader'){ ?>
	    <div class="cssloader">
	    	<div class="sh1"></div>
	    	<div class="sh2"></div>
	    	<h1 class="lt"><?php esc_html_e( 'loading',  'wedding-planner-lite' ); ?></h1>
	    </div>
    <?php }else if(get_theme_mod( 'wedding_planner_lite_preloader_type') == 'cube-loader') {?>
		<div class="cssloader">
    		<div class="loader-main ">
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
				<div class="triangle35b"></div>
			</div>
    	</div>
    <?php }?>
<?php }?>

<header id="site-navigationn">
	<div class="topheader py-3">
		<div class="container-fluid">
			<div class="row px-lg-3 wow fadeInDown">
				<div class="col-lg-7 col-md-6 align-self-center">
					<?php if ( get_theme_mod('wedding_planner_lite_topheader_text') ) : ?>
						<p class="top-text mb-lg-0 mb-md-0"><?php echo esc_html( get_theme_mod('wedding_planner_lite_topheader_text' ) ); ?></p>
					<?php endif; ?>
				</div>
				<div class="col-lg-5 col-md-6 align-self-center">
					<div class="row">
						<div class="col-lg-6 col-md-6 col-sm-6 col-5 align-self-center">
							<?php $wedding_planner_lite_settings = get_theme_mod( 'wedding_planner_lite_social_links_settings' ); ?>
							<div class="social-links text-center">
								<?php if ( is_array($wedding_planner_lite_settings) || is_object($wedding_planner_lite_settings) ){ ?>
							    	<?php foreach( $wedding_planner_lite_settings as $wedding_planner_lite_setting ) { ?>
								        <a href="<?php echo esc_url( $wedding_planner_lite_setting['link_url'] ); ?>">
								            <i class="<?php echo esc_attr( $wedding_planner_lite_setting['link_text'] ); ?> me-3 pr-lg-2"></i>
								        </a>
							    	<?php } ?>
								<?php } ?>
							</div>
						</div>
						<div class="col-lg-6 col-md-6 col-sm-6 col-7 align-self-center">
							<?php if ( get_theme_mod('wedding_planner_lite_header_contact_us_txt') || get_theme_mod('wedding_planner_lite_header_contact_us_lnk') ) : ?>
							<p class="slider-button text-lg-end text-md-end text-center mb-0"><a href="<?php echo esc_url( get_theme_mod('wedding_planner_lite_header_contact_us_lnk' ) ); ?>"><?php echo esc_html( get_theme_mod('wedding_planner_lite_header_contact_us_txt' ) ); ?><i class="fas fa-arrow-right ms-2"></i></a></p>
							<?php endif; ?>
			       		</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="header-center-box">
		<div class="container-fluid">
			<div class="row px-lg-3 wow fadeInDown">
				<div class="col-lg-3 col-md-4  col-sm-4 align-self-center">
					<div class="logo text-lg-start text-center">
			    		<div class="logo-image">
			    			<?php the_custom_logo(); ?>
				    	</div>
				    	<div class="logo-content">
					    	<?php
					    		if ( get_theme_mod('wedding_planner_lite_display_header_title', true) == true ) :
						      		echo '<a href="' . esc_url(home_url('/')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
						      			echo esc_html(get_bloginfo('name'));
						      		echo '</a>';
						      	endif;

						      	if ( get_theme_mod('wedding_planner_lite_display_header_text', false) == true ) :
					      			echo '<span>'. esc_html(get_bloginfo('description')) . '</span>';
					      		endif;
				    		?>
						</div>
					</div>
				</div>
				<div class="col-lg-5 col-md-8 col-sm-3 align-self-center text-lg-start text-center">
					<div class="top-menu-wrapper">
					    <div class="navigation_header">
					        <div class="toggle-nav mobile-menu">
					            <button onclick="wedding_planner_lite_openNav()">
					                <span class="dashicons dashicons-menu"></span>
					            </button>
					        </div>
					        <div id="mySidenav" class="nav sidenav">
					            <nav id="site-navigation" class="main-navigation navbar navbar-expand-xl" aria-label="<?php esc_attr_e( 'Top Menu', 'wedding-planner-lite' ); ?>">
					                <?php {
					                    wp_nav_menu(
					                        array(
					                            'theme_location' => 'main-menu',
					                            'container_class' => 'navi clearfix navbar-nav',
					                            'menu_class'     => 'menu clearfix',
					                            'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
					                            'fallback_cb'    => 'wp_page_menu',
					                        )
					                    );
					                } ?>
					            </nav>
					            <a href="javascript:void(0)" class="closebtn mobile-menu" onclick="wedding_planner_lite_closeNav()">
					                <span class="dashicons dashicons-no"></span>
					            </a>
					        </div>
					    </div>
					</div>
				</div>
				<div class="col-lg-2 col-md-5 col-sm-3 col-7 align-self-center">
			        <div class="header-search text-right">
			        	<?php if ( get_theme_mod('wedding_planner_lite_search_box_enable', true) == true ) : ?>
							<?php if(class_exists('woocommerce')){ ?>
					          	<form method="get" class="woocommerce-product-search" action="<?php echo esc_url(home_url('/')); ?>">
						            <label class="screen-reader-text" for="woocommerce-product-search-field"><?php esc_html_e('Search for:', 'wedding-planner-lite'); ?></label>
						            <input type="search" id="woocommerce-product-search-field" class="search-field " placeholder="<?php echo esc_html('Search Here','wedding-planner-lite'); ?>" value="<?php echo get_search_query(); ?>" name="s"/>
						            <button type="submit" value="" class="search-button"><i class="fas fa-search"></i></button>
						            <input type="hidden" name="post_type" value="product"/>
					          	</form>
					        <?php }?>
			        	<?php endif; ?>
		        	</div>
	       		</div>
			    <div class="col-lg-1 col-md-5 col-sm-1 col-3 text-center align-self-center">
					<div class="woo-other-info">
						<?php if ( class_exists( 'woocommerce' ) ) {?>
							<a class="cart-customlocation" href="<?php if(function_exists('wc_get_cart_url')){ echo esc_url(wc_get_cart_url()); } ?>" title="<?php esc_attr_e( 'View Shopping Cart','wedding-planner-lite' ); ?>"><i class="fas fa-shopping-bag"></i></a>
						<?php }?>
					</div>
				</div>
				<div class="col-lg-1 col-md-2 col-sm-1 col-2 text-center align-self-center">
					<div class="offcanvas-div d-flex">
						<button type="button" data-bs-toggle="offcanvas" data-bs-target="#demo">
							<i class="fas fa-bars"></i>
						</button>
						<div class="offcanvas offcanvas-end" id="demo">
							<div class="offcanvas-header"> 
								<button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
							</div>
							<div class="offcanvas-body">
								<?php dynamic_sidebar('wedding-planner-lite-menu-sidebar'); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</header>