<?php if ( get_theme_mod('wedding_planner_lite_blog_box_enable',false) ) : ?>

<?php $wedding_planner_lite_args = array(
  'post_type' => 'post',
  'post_status' => 'publish',
  'category_name' =>  get_theme_mod('wedding_planner_lite_blog_slide_category'),
  'posts_per_page' => get_theme_mod('wedding_planner_lite_blog_slide_number'),
); ?>

<div class="slider">
  <div class="owl-carousel main-slider">
    <?php $wedding_planner_lite_arr_posts = new WP_Query( $wedding_planner_lite_args );
    if ( $wedding_planner_lite_arr_posts->have_posts() ) :
      while ( $wedding_planner_lite_arr_posts->have_posts() ) :
        $wedding_planner_lite_arr_posts->the_post();
        ?>
        <div class="blog_inner_box">
          <?php
            if ( has_post_thumbnail() ) :
              the_post_thumbnail();
            else:
              ?>
              <div class="slider-alternate">
                <img src="<?php echo esc_url( get_stylesheet_directory_uri() ). '/assets/images/banner.png'; ?>">
              </div>
              <?php
            endif;
          ?>
          <div class="blog_box">
            <div class="blog_box_inner">
              <div class="container-fluid">
                <div class="row  px-3">
                  <div class="col-lg-6 col-md-5">
                    <div class="slide-content pr-lg-5 wow fadeInLeft">
                      <?php if ( get_theme_mod('wedding_planner_lite_slider_short_title') ) : ?>
                        <h6><?php echo esc_html( get_theme_mod('wedding_planner_lite_slider_short_title' ) ); ?></h6>
                      <?php endif; ?>
                      <h3><?php the_title(); ?></h3>
                      <p><?php echo wp_trim_words( get_the_content(), 25); ?></p>
                      <p class="slider-button mt-4">
                        <a href="<?php echo esc_url(get_permalink($post->ID)); ?>"><?php esc_html_e('Shop Now','wedding-planner-lite'); ?><i class="fas fa-arrow-right ms-2"></i></a>
                      </p>
                    </div> 
                  </div>
                  <?php if ( get_theme_mod('wedding_planner_lite_slider_product_box_enable',true) ) { ?>
                    <div class="slider-product-box col-lg-6 col-md-7">
                      <div class="slide-product  owl-carousel">
                        <?php
                        $wedding_planner_lite_slider_catData = get_theme_mod('wedding_planner_lite_sider_product_category','');
                        if ( class_exists( 'WooCommerce' ) ) {
                            $wedding_planner_lite_args = array(
                              'post_type' => 'product',
                              'posts_per_page' => 100,
                              'product_cat' => $wedding_planner_lite_slider_catData,
                              'order' => 'ASC'
                            );
                            $loop = new WP_Query( $wedding_planner_lite_args );
                            while ( $loop->have_posts() ) : $loop->the_post(); global $product; ?>
                                <div class="product-content wow fadeInRight">
                                  <div class="row">
                                    <div class="col-lg-7 col-md-6 col-5">
                                      <div class="product-img box">
                                          <figure class="mb-0">
                                            <?php if (has_post_thumbnail( $loop->post->ID )) echo get_the_post_thumbnail($loop->post->ID, 'shop_catalog'); else echo '<img src="'.esc_url(wc_placeholder_img_src()).'" />'; ?>
                                            <?php if ( has_post_thumbnail() ) { ?>
                                              <?php woocommerce_show_product_sale_flash( $post, $product ); ?>
                                            <?php }?>
                                          </figure>
                                        </div>
                                    </div>
                                    <div class="col-lg-5 col-md-6 col-7  align-self-center">
                                      <div class="product-info">
                                          <h5 class="product-title mt-2 mb-3"><a href="<?php echo esc_url(get_permalink( $loop->post->ID )); ?>"><?php the_title(); ?></a></h5>

                                          <h6 class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?> mb-2"><?php echo $product->get_price_html(); ?></h6>

                                          <?php if( $product->is_type( 'simple' ) ){ woocommerce_template_loop_rating( $loop->post, $product ); } ?>

                                          <p class="product-dis mb-0 mt-2"><?php echo wp_trim_words( get_the_content(),15); ?></p>

                                          <div class="product-buy-now mt-5">
                                            <?php $current_product_id = get_the_ID(); 
                                            $checkout_url = wc_get_checkout_url();
                                            ?>
                                            <span class="buy-now-btn">
                                              <?php
                                              if( $product->is_type( 'simple' ) ){
                                                echo '<a href="'.$checkout_url.'?add-to-cart='.$current_product_id.'" class="buy-now button">Buy Now<i class="fas fa-arrow-right ms-2"></i></a>';
                                                } ?>
                                            </span>
                                            <span>
                                              <?php if( $product->is_type( 'simple' ) ) { woocommerce_template_loop_add_to_cart(  $loop->post, $product );} ?>
                                            </span>
                                            
                                          </div>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                            <?php endwhile; wp_reset_postdata(); ?>
                        <?php } ?>
                      </div>
                    </div>
                  <?php }?>
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php
    endwhile;
    wp_reset_postdata();
    endif; ?>
  </div>
</div>

<?php endif; ?>