<?php if ( get_theme_mod('wedding_planner_lite_our_product_section_enable',false) ) : ?>
	<div id="our-product" class="py-5">
		<div class="container">
			<div class="row main-row">
				<div class="col-lg-4 col-md-5 wow fadeInLeft">
					<div class="daily-deals">

						<?php if ( get_theme_mod('wedding_planner_lite_daily_deals_heading_text') ) : ?>
		      				<h2 class="mb-2"><?php echo esc_html(get_theme_mod('wedding_planner_lite_daily_deals_heading_text'));?></h2>
		      			<?php endif; ?>

						<?php if( get_theme_mod('wedding_planner_lite_daily_deals_timmer') != '' ){ ?>
							<div id="countdown-timer" class="text-center mb-2 px-3">
								<input type="hidden" name="new-year-date" id="new-year-date" value="<?php echo esc_attr(get_theme_mod('wedding_planner_lite_daily_deals_timmer','')); ?>">
								<div class="row">
									<div class="col-lg-3 col-md-3 col-3 px-2">
										<div class="count-box "><p id="days" class="time-number mb-0">118 </p> <p class="time-countdown-text mb-0"><?php esc_html_e('Days','wedding-planner-lite'); ?></p></div>
									</div>
									<div class="col-lg-3 col-md-3 col-3 px-2">
										<div class="count-box "><p id="hours" class="time-number mb-0"> 14 </p> <p class="time-countdown-text mb-0"><?php esc_html_e('Hours','wedding-planner-lite'); ?></p></div>
									</div>
									<div class="col-lg-3 col-md-3 col-3 px-2">
										<div class="count-box "><p id="mins" class="time-number mb-0"> 36 </p> <p class="time-countdown-text mb-0"><?php esc_html_e('Mins','wedding-planner-lite'); ?></p></div>
									</div>
									<div class="col-lg-3 col-md-3 col-3 px-2">
										<div class="count-box"><p id="seconds" class="time-number mb-0"> 24 </p> <p class="time-countdown-text mb-0"><?php esc_html_e('Sec','wedding-planner-lite'); ?></p></div>
									</div>
								</div>
							</div>
            			<?php }?>

            			<div class="owl-carousel">
	                        <?php
	                        $wedding_planner_lite_deals_catData = get_theme_mod('wedding_planner_lite_daily_deals_product_category','');
	                        if ( class_exists( 'WooCommerce' ) ) {
	                            $wedding_planner_lite_args = array(
	                              'post_type' => 'product',
	                              'posts_per_page' => 100,
	                              'product_cat' => $wedding_planner_lite_deals_catData,
	                              'order' => 'ASC'
	                            );
	                            $loop = new WP_Query( $wedding_planner_lite_args );
	                            while ( $loop->have_posts() ) : $loop->the_post(); global $product; ?>
	                                <div class="daily-deals-box">
										<div class="deals-image-box">
											<figure class="mb-0 daily-deals-img">
											<?php if (has_post_thumbnail( $loop->post->ID )) echo get_the_post_thumbnail($loop->post->ID, 'shop_catalog'); else echo '<img src="'.esc_url(wc_placeholder_img_src()).'" />'; ?>
											</figure>
										</div>
										<div class="deals-info-box text-center pt-2 px-1">
											<h5 class="mb-2"><a href="<?php echo esc_url(get_permalink( $loop->post->ID )); ?>"><?php the_title(); ?></a></h5>

											<?php if( $product->is_type( 'simple' ) ){ woocommerce_template_loop_rating( $loop->post, $product ); } ?>

											<h6 class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?> my-2"><?php echo $product->get_price_html(); ?></h6>

											<?php if( $product->is_type( 'simple' ) ) { ?>
												<p class="mb-2 add-to-cart-btn"><?php woocommerce_template_loop_add_to_cart(  $loop->post, $product );?><i class="fas fa-arrow-right ms-2"></i></p>
											<?php } ?>
										</div>
	                                </div>
	                            <?php endwhile; wp_reset_postdata(); ?>
	                        <?php } ?>
                      	</div>
					</div>
				</div>
				<div class="col-lg-8 col-md-7 align-self-end  wow fadeInRight">
					<div class="product-tabs">
		      			<div class="tab">
		      				<div class="row">
		      					<div class="col-lg-3 col-md-12 align-self-center">
		      						<?php if ( get_theme_mod('wedding_planner_lite_our_product_heading') ) : ?>
		      							<h2 class=""><?php echo esc_html(get_theme_mod('wedding_planner_lite_our_product_heading'));?></h2>
		      						<?php endif; ?>
		      					</div>
		      					<div class="col-lg-9 col-md-12 px-0 align-self-center">
		      						<div class="tab-section">
										<ul class="mb-0 px-0 text-lg-end">
									        <?php 
												$wedding_planner_lite_product_post = get_theme_mod('wedding_planner_lite_our_product_tab_number', '');
												for ( $wedding_planner_lite_i = 1; $wedding_planner_lite_i <= $wedding_planner_lite_product_post; $wedding_planner_lite_i++ ){ ?>
											 	<li class="product-tab align-self-center">
										            <button class="tablinks" onclick="wedding_planner_lite_openCity(event, '<?php $wedding_planner_lite_main_id = get_theme_mod('wedding_planner_lite_our_product_tabs_text'.$wedding_planner_lite_i); $wedding_planner_lite_tab_id = str_replace(' ', '-', $wedding_planner_lite_main_id); echo $wedding_planner_lite_tab_id; ?> ')">
									              		<?php echo esc_html(get_theme_mod('wedding_planner_lite_our_product_tabs_text'.$wedding_planner_lite_i)); ?>
										            </button>
										        </li>
									        <?php }?>
									    </ul>
					      		  	</div>
		      					</div>
		      				</div>
						</div>
						<?php for ( $wedding_planner_lite_i = 1; $wedding_planner_lite_i <= $wedding_planner_lite_product_post; $wedding_planner_lite_i++ ){ ?>
					        <div id="<?php $wedding_planner_lite_main_id = get_theme_mod('wedding_planner_lite_our_product_tabs_text'.$wedding_planner_lite_i); $wedding_planner_lite_tab_id = str_replace(' ', '-', $wedding_planner_lite_main_id); echo $wedding_planner_lite_tab_id; ?>" class="tabcontent mt-3">
						        <div class="owl-carousel">
						            <?php
						            $wedding_planner_lite_catData = get_theme_mod('wedding_planner_lite_our_product_category'.$wedding_planner_lite_i);
						            if ( class_exists( 'WooCommerce' ) ) {
						              $wedding_planner_lite_args = array( 
						                'post_type' => 'product',
						                'posts_per_page' => 8,
						                'product_cat' => $wedding_planner_lite_catData,
						                'order' => 'ASC'
						              );
						              $loop = new WP_Query( $wedding_planner_lite_args );
						              while ( $loop->have_posts() ) : $loop->the_post(); global $product; ?>
						                <div class="tab-product">
						                    <div class="product-image-box">
						                    	<figure class="mb-0 tab-img">
						                        	<?php if (has_post_thumbnail( $loop->post->ID )) echo get_the_post_thumbnail($loop->post->ID, 'shop_catalog'); else echo '<img src="'.esc_url(wc_placeholder_img_src()).'" />'; ?>
						                        	<?php if (   has_post_thumbnail() ) { ?>      
							                            <?php woocommerce_show_product_sale_flash( $post, $product ); ?>
							                        <?php }?>
						                        </figure>
						                        <div class="product-hover">
							                    	<span class="add-to-cart-btn mb-3"><?php if( $product->is_type( 'simple' ) ) { woocommerce_template_loop_add_to_cart(  $loop->post, $product );} ?><i class="fas fa-arrow-right ms-2"></i></span>
							                    	<p class="product-dis mb-0"><?php echo wp_trim_words( get_the_content(),8); ?></p>
						                        </div>
						                    </div>
						                    <div class="product-details p-3">
						                    	<h5 class="product-text mb-3 "><a href="<?php echo esc_url(get_permalink( $loop->post->ID )); ?>"><?php the_title(); ?></a></h5>
						                    	<?php if( $product->is_type( 'simple' ) ){ woocommerce_template_loop_rating( $loop->post, $product ); } ?>
							                  	<h6 class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?> mb-0 mt-3"><?php echo $product->get_price_html(); ?></h6>               	
							                </div>
						                </div>
						              <?php endwhile; wp_reset_postdata(); ?>
						            <?php } ?>
						        </div>
					        </div>
						<?php }?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>
