<?php

/**
* Get started notice
*/

add_action( 'wp_ajax_wedding_planner_lite_dismissed_notice_handler', 'wedding_planner_lite_ajax_notice_handler' );

function wedding_planner_lite_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function wedding_planner_lite_deprecated_hook_admin_notice() {
    // Check if it's been dismissed...
    if ( ! get_option( 'dismissed-get_started', false ) ) {
        $current_screen = get_current_screen();

        // Check screen ID correctly
        if ( 
            $current_screen && 
            $current_screen->id !== 'appearance_page_wedding-planner-lite-guide-page' &&
            $current_screen->id !== 'appearance_page_weddingplannerlite-wizard'
        ) {
            $wedding_planner_lite_comments_theme = wp_get_theme();
            ?>
            <div class="wedding-planner-lite-notice-wrapper updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="wedding-planner-lite-notice">
                    <div class="wedding-planner-lite-notice-content">
                        <div class="wedding-planner-lite-notice-heading">
                            <h2>
                                <?php esc_html_e('Thanks For Installing ', 'wedding-planner-lite'); ?>
                                <?php echo esc_html( $wedding_planner_lite_comments_theme ); ?>
                                <?php esc_html_e('Theme', 'wedding-planner-lite'); ?>
                            </h2>
                            <p>
                                <?php
                                /* translators: %s: theme name */
                                printf(
                                    esc_html__("%s is now installed and ready to use. We've provided some links to get you started.", 'wedding-planner-lite'),
                                    $wedding_planner_lite_comments_theme
                                );
                                ?>
                            </p>
                        </div>
                        <div class="diplay-flex-btn">
                            <a class="button button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=wedding-planner-lite-guide-page' ) ); ?>">
                                <?php echo esc_html__('GET STARTED', 'wedding-planner-lite'); ?>
                            </a>
                            <a class="button button-primary" href="<?php echo esc_url( WEDDING_PLANNER_LITE_BUY_NOW ); ?>">
                                <?php echo esc_html__('GO TO PREMIUM', 'wedding-planner-lite'); ?>
                            </a>
                            <a class="button button-primary import" href="<?php echo esc_url( admin_url( 'themes.php?page=weddingplannerlite-wizard' ) ); ?>">
                                <?php echo esc_html__('ONE CLICK DEMO IMPORTER', 'wedding-planner-lite'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="wedding-planner-lite-notice-img">
                        <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/notification.png' ); ?>" alt="<?php esc_attr_e('logo', 'wedding-planner-lite'); ?>">
                    </div>
                </div>
            </div>
            <?php
        }
    }
}
add_action( 'admin_notices', 'wedding_planner_lite_deprecated_hook_admin_notice' );

add_action( 'admin_menu', 'wedding_planner_lite_getting_started' );
function wedding_planner_lite_getting_started() {
	add_theme_page( esc_html__('Get Started', 'wedding-planner-lite'), esc_html__('Get Started', 'wedding-planner-lite'), 'edit_theme_options', 'wedding-planner-lite-guide-page', 'wedding_planner_lite_test_guide');
}

function wedding_planner_lite_admin_enqueue_scripts() {
	wp_enqueue_style( 'wedding-planner-lite-admin-style', esc_url( get_template_directory_uri() ).'/css/main.css' );
	wp_enqueue_script( 'wedding-planner-lite-admin-script', get_template_directory_uri() . '/js/wedding-planner-lite-admin-script.js', array( 'jquery' ), '', true );
    wp_localize_script( 'wedding-planner-lite-admin-script', 'wedding_planner_lite_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
}
add_action( 'admin_enqueue_scripts', 'wedding_planner_lite_admin_enqueue_scripts' );


if ( ! defined( 'WEDDING_PLANNER_LITE_DOCS_FREE' ) ) {
define('WEDDING_PLANNER_LITE_DOCS_FREE',__('https://demo.misbahwp.com/docs/wedding-planner-free-docs/','wedding-planner-lite'));
}
 if ( ! defined( 'WEDDING_PLANNER_LITE_DOCS_PRO' ) ) {
define('WEDDING_PLANNER_LITE_DOCS_PRO',__('https://demo.misbahwp.com/docs/wedding-planner-pro-docs','wedding-planner-lite'));
}
if ( ! defined( 'WEDDING_PLANNER_LITE_BUY_NOW' ) ) {
define('WEDDING_PLANNER_LITE_BUY_NOW',__('https://www.misbahwp.com/products/wedding-planner-wordpress-theme','wedding-planner-lite'));
}
if ( ! defined( 'WEDDING_PLANNER_LITE_SUPPORT_FREE' ) ) {
define('WEDDING_PLANNER_LITE_SUPPORT_FREE',__('https://wordpress.org/support/theme/wedding-planner-lite','wedding-planner-lite'));
}
if ( ! defined( 'WEDDING_PLANNER_LITE_REVIEW_FREE' ) ) {
define('WEDDING_PLANNER_LITE_REVIEW_FREE',__('https://wordpress.org/support/theme/wedding-planner-lite/reviews/#new-post','wedding-planner-lite'));
}
if ( ! defined( 'WEDDING_PLANNER_LITE_DEMO_PRO' ) ) {
define('WEDDING_PLANNER_LITE_DEMO_PRO',__('https://demo.misbahwp.com/wedding-planner/','wedding-planner-lite'));
}
if( ! defined( 'WEDDING_PLANNER_LITE_THEME_BUNDLE' ) ) {
define('WEDDING_PLANNER_LITE_THEME_BUNDLE',__('https://www.misbahwp.com/products/wordpress-bundle','wedding-planner-lite'));
}

function wedding_planner_lite_test_guide() { ?>
	<?php $wedding_planner_lite_theme = wp_get_theme(); ?>

	<div class="wrap" id="main-page">
		<div id="lefty">
			<div id="admin_links">
				<a href="<?php echo esc_url( WEDDING_PLANNER_LITE_DOCS_FREE ); ?>" target="_blank" class="blue-button-1"><?php esc_html_e( 'Documentation', 'wedding-planner-lite' ) ?></a>
				<a href="<?php echo esc_url( admin_url('customize.php') ); ?>" id="customizer" target="_blank"><?php esc_html_e( 'Customize', 'wedding-planner-lite' ); ?> </a>
				<a class="blue-button-1" href="<?php echo esc_url( WEDDING_PLANNER_LITE_SUPPORT_FREE ); ?>" target="_blank" class="btn3"><?php esc_html_e( 'Support', 'wedding-planner-lite' ) ?></a>
				<a class="blue-button-2" href="<?php echo esc_url( WEDDING_PLANNER_LITE_REVIEW_FREE ); ?>" target="_blank" class="btn4"><?php esc_html_e( 'Review', 'wedding-planner-lite' ) ?></a>
			</div>
			<div id="description">
				<h3><?php esc_html_e('Welcome! Thank you for choosing ','wedding-planner-lite'); ?><?php echo esc_html( $wedding_planner_lite_theme ); ?>  <span><?php esc_html_e('Version: ', 'wedding-planner-lite'); ?><?php echo esc_html($wedding_planner_lite_theme['Version']);?></span></h3>
				<div class="demo-import-box">
					<h4><?php echo esc_html__('Import homepage demo in just one click.','wedding-planner-lite'); ?></h4>
					<p><?php echo esc_html__('Get started with the wordpress theme installation','wedding-planner-lite'); ?></p>
					<a class="button button-primary import" href="themes.php?page=weddingplannerlite-wizard"><?php echo esc_html__('ONE CLICK DEMO IMPORTER','wedding-planner-lite'); ?></a>
				</div>
				<img class="img_responsive" style="width: 100%;" src="<?php echo esc_url( $wedding_planner_lite_theme->get_screenshot() ); ?>" />
				<div id="description-insidee">
					<?php
						$wedding_planner_lite_theme = wp_get_theme();
						echo wp_kses_post( apply_filters( 'misbah_theme_description', esc_html( $wedding_planner_lite_theme->get( 'Description' ) ) ) );
					?>
				</div>
			</div>
		</div>

		<div id="righty">
			<div class="volleyball-postboxx">
				<h3 class="hndle"><?php esc_html_e( 'Upgrade to Premium', 'wedding-planner-lite' ); ?></h3>
				<div class="volleyball-insidee">
					<p><?php esc_html_e('Discover upgraded pro features with premium version click to upgrade.','wedding-planner-lite'); ?></p>
					<div id="admin_pro_links">
						<a class="blue-button-2" href="<?php echo esc_url( WEDDING_PLANNER_LITE_BUY_NOW ); ?>" target="_blank"><?php esc_html_e( 'Go Pro', 'wedding-planner-lite' ); ?></a>
						<a class="blue-button-1" href="<?php echo esc_url( WEDDING_PLANNER_LITE_DEMO_PRO ); ?>" target="_blank"><?php esc_html_e( 'Live Demo', 'wedding-planner-lite' ) ?></a>
						<a class="blue-button-2" href="<?php echo esc_url( WEDDING_PLANNER_LITE_DOCS_PRO ); ?>" target="_blank"><?php esc_html_e( 'Pro Docs', 'wedding-planner-lite' ) ?></a>
					</div>
				</div>

				<h3 class="hndle bundle"><?php esc_html_e( 'Get All Themes', 'wedding-planner-lite' ); ?></h3>
				<div class="insidee theme-bundle">
					<img width="100%" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/bundle-image.png' ); ?>" alt="<?php esc_attr_e('logo', 'wedding-planner-lite'); ?>">
					<p class="offer"><?php esc_html_e('Get 100+ Perfect WordPress Theme In A Single Package at just $89."','wedding-planner-lite'); ?></p>
					<p class="coupon"><?php esc_html_e('Get Our Theme Pack of 100+ WordPress Themes At 15% Off','wedding-planner-lite'); ?><span class="coupon-code"><?php esc_html_e('"Bundleup15"','wedding-planner-lite'); ?></span></p>
					<div id="admin_pro_linkss">
						<a class="blue-button-1" href="<?php echo esc_url( WEDDING_PLANNER_LITE_THEME_BUNDLE ); ?>" target="_blank"><?php esc_html_e( 'Theme Bundle', 'wedding-planner-lite' ) ?></a>
					</div>
				</div>
				<div class="d-table">
			    <ul class="d-column">
			      <li class="feature"><?php esc_html_e('Features','wedding-planner-lite'); ?></li>
			      <li class="free"><?php esc_html_e('Pro','wedding-planner-lite'); ?></li>
			      <li class="plus"><?php esc_html_e('Free','wedding-planner-lite'); ?></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('24hrs Priority Support','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('LearnPress Campatiblity','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Kirki Framework','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Posttype','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('One Click Demo Import','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Reordering','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Enable / Disable Option','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Multiple Sections','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Color Pallete','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Widgets','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-yes"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Page Templates','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Advance Typography','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
			    <ul class="d-row">
			      <li class="points"><?php esc_html_e('Section Background Image / Color ','wedding-planner-lite'); ?></li>
			      <li class="right"><span class="dashicons dashicons-yes"></span></li>
			      <li class="wrong"><span class="dashicons dashicons-no"></span></li>
			    </ul>
	  		</div>
			</div>
		</div>
	</div>

<?php } ?>