<?php

if ( class_exists("Kirki")){

	// LOGO

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'wedding_planner_lite_logo_resizer',
		'label'       => esc_html__( 'Adjust Your Logo Size ', 'wedding-planner-lite' ),
		'section'     => 'title_tagline',
		'choices'     => [
			'min'  => 10,
			'max'  => 300,
			'step' => 10,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_enable_logo_text',
		'section'     => 'title_tagline',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Site Title and Tagline', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_display_header_title',
		'label'       => esc_html__( 'Site Title Enable / Disable Button', 'wedding-planner-lite' ),
		'section'     => 'title_tagline',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_display_header_text',
		'label'       => esc_html__( 'Tagline Enable / Disable Button', 'wedding-planner-lite' ),
		'section'     => 'title_tagline',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );

	// FONT STYLE TYPOGRAPHY

	Kirki::add_panel( 'wedding_planner_lite_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Typography', 'wedding-planner-lite' ),
	) );

	Kirki::add_section( 'wedding_planner_lite_font_style_section', array(
		'title'      => esc_html__( 'Typography Option',  'wedding-planner-lite' ),
		'priority'   => 2,
		'capability' => 'edit_theme_options',
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_font_style_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_all_headings_typography',
		'section'     => 'wedding_planner_lite_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Heading Of All Sections',  'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'wedding_planner_lite_all_headings_typography',
		'label'       => esc_html__( 'Heading Typography',  'wedding-planner-lite' ),
		'description' => esc_html__( 'Select the typography options for your heading.',  'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'h1','h2','h3','h4','h5','h6', ),
			),
		),
	) );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_body_content_typography',
		'section'     => 'wedding_planner_lite_font_style_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Body Content',  'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'global', array(
		'type'        => 'typography',
		'settings'    => 'wedding_planner_lite_body_content_typography',
		'label'       => esc_html__( 'Content Typography',  'wedding-planner-lite' ),
		'description' => esc_html__( 'Select the typography options for your content.',  'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_font_style_section',
		'priority'    => 10,
		'default'     => array(
			'font-family'    => '',
			'variant'        => '',
		),
		'output' => array(
			array(
				'element' => array( 'body', ),
			),
		),
	) );

		// PANEL
	Kirki::add_panel( 'wedding_planner_lite_panel_id_5', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Animations', 'wedding-planner-lite' ),
	) );

	// ANIMATION SECTION
	Kirki::add_section( 'wedding_planner_lite_section_animation', array(
	    'title'          => esc_html__( 'Animations', 'wedding-planner-lite' ),
	    'priority'       => 2,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_section_animation',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_animation_enabled',
		'label'       => esc_html__( 'Turn To Show Animation', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_animation',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );

	// PANEL
	Kirki::add_panel( 'wedding_planner_lite_panel_id_2', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Dark Mode', 'wedding-planner-lite' ),
	) );

	// DARK MODE SECTION
	Kirki::add_section( 'wedding_planner_lite_section_dark_mode', array(
	    'title'          => esc_html__( 'Dark Mode', 'wedding-planner-lite' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_section_dark_mode',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'wedding_planner_lite_dark_colors',
	    'section'     => 'wedding_planner_lite_section_dark_mode',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Dark Appearance', 'wedding-planner-lite' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_is_dark_mode_enabled',
		'label'       => esc_html__( 'Turn To Dark Mode', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_dark_mode',
		'default'     => false,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );


	// PANEL
	Kirki::add_panel( 'wedding_planner_lite_panel_id_3', array(
	    'priority'    => 10,
	    'title'       => esc_html__( '404 Settings / No Result', 'wedding-planner-lite' ),
	) );

	// 404 SECTION
	Kirki::add_section( 'wedding_planner_lite_section_404', array(
		'panel'          => 'wedding_planner_lite_panel_id_3',
	    'title'          => esc_html__( '404 Settings', 'wedding-planner-lite' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_section_404',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'wedding_planner_lite_404_heading',
	    'section'     => 'wedding_planner_lite_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Heading', 'wedding-planner-lite' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'wedding_planner_lite_404_page_title',
		'section'  => 'wedding_planner_lite_section_404',
		'default'  => esc_html__('404 Not Found', 'wedding-planner-lite'),
		'priority' => 10,
	] );

		Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'wedding_planner_lite_404_text',
	    'section'     => 'wedding_planner_lite_section_404',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( '404 Content', 'wedding-planner-lite' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'wedding_planner_lite_404_page_content',
		'section'  => 'wedding_planner_lite_section_404',
		'default'  => esc_html__('Sorry, no posts matched your criteria.', 'wedding-planner-lite'),
		'priority' => 10,
	] );

	// NO Result
	Kirki::add_section( 'wedding_planner_lite_no_result', array(
		'panel'          => 'wedding_planner_lite_panel_id_3',
	    'title'          => esc_html__( 'No Result Page Settings', 'wedding-planner-lite' ),
	    'priority'       => 3,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_no_result',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
		'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'wedding_planner_lite_not_found_heading',
	    'section'     => 'wedding_planner_lite_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Heading', 'wedding-planner-lite' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'wedding_planner_lite_no_results_page_title',
		'section'  => 'wedding_planner_lite_no_result',
		'default'  => esc_html__('404 Not Found', 'wedding-planner-lite'),
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	    'type'        => 'custom',
	    'settings'    => 'wedding_planner_lite_not_found_text',
	    'section'     => 'wedding_planner_lite_no_result',
	    'default'     => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'No Search Result Content', 'wedding-planner-lite' ) . '</h3>',
	    'priority'    => 10,
	]);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'wedding_planner_lite_no_results_page_content',
		'section'  => 'wedding_planner_lite_no_result',
		'default'  => esc_html__('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'wedding-planner-lite'),
		'priority' => 10,
	] );


	// PANEL

	Kirki::add_panel( 'wedding_planner_lite_panel_id', array(
	    'priority'    => 10,
	    'title'       => esc_html__( 'Theme Options', 'wedding-planner-lite' ),
	) );

	//COLOR SECTION

	Kirki::add_section( 'wedding_planner_lite_section_color', array(
	    'title'          => esc_html__( 'Global Color', 'wedding-planner-lite' ),
	    'panel'          => 'wedding_planner_lite_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_section_color',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. More Font Family Options </p><p>3. Color Pallete Setup </p><p>4. Section Reordering Facility</p><p>5. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_global_colors',
		'section'     => 'wedding_planner_lite_section_color',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Here you can change your theme color on one click.', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'wedding_planner_lite_first_color',
		'label'       => __( 'choose your First Color', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_color',
		'default'     => '#fc7277',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'wedding_planner_lite_second_color',
		'label'       => __( 'Choose Your Second Color', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_color',
		'default'     => '#000000',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'wedding_planner_lite_third_color',
		'label'       => __( 'Choose Your Third Color', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_color',
		'default'     => '#FFB4B6',
	] );

	// Additional Settings

	Kirki::add_section( 'wedding_planner_lite_additional_settings', array(
	    'title'          => esc_html__( 'Additional Settings', 'wedding-planner-lite' ),
	    'panel'          => 'wedding_planner_lite_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_additional_settings',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );


	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'wedding_planner_lite_scroll_enable_setting',
		'label'       => esc_html__( 'Here you can enable or disable your scroller.', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_additional_settings',
		'default'     => '1',
		'priority'    => 10,
	] );

	new \Kirki\Field\Radio_Buttonset(
		[
			'settings'    => 'wedding_planner_lite_scroll_top_position',
			'label'       => esc_html__( 'Alignment for Scroll To Top', 'wedding-planner-lite' ),
			'section'     => 'wedding_planner_lite_additional_settings',
			'default'     => 'Right',
			'priority'    => 10,
			'choices'     => [
				'Left'   => esc_html__( 'Left', 'wedding-planner-lite' ),
				'Center' => esc_html__( 'Center', 'wedding-planner-lite' ),
				'Right'  => esc_html__( 'Right', 'wedding-planner-lite' ),
			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'dashicons',
		'settings' => 'wedding_planner_lite_scroll_top_icon',
		'label'    => esc_html__( 'Select Appropriate Scroll Top Icon', 'wedding-planner-lite' ),
		'section'  => 'wedding_planner_lite_additional_settings',
		'default'  => 'dashicons dashicons-arrow-up-alt',
		'priority' => 10,
	] );

	new \Kirki\Field\Select(
		[
			'settings'    => 'menu_text_transform_wedding_planner_lite',
			'label'       => esc_html__( 'Menus Text Transform', 'wedding-planner-lite' ),
			'section'     => 'wedding_planner_lite_additional_settings',
			'default'     => 'CAPITALISE',
			'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
			'choices'     => [
				'CAPITALISE' => esc_html__( 'CAPITALISE', 'wedding-planner-lite' ),
				'UPPERCASE' => esc_html__( 'UPPERCASE', 'wedding-planner-lite' ),
				'LOWERCASE' => esc_html__( 'LOWERCASE', 'wedding-planner-lite' ),

			],
		]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'wedding_planner_lite_container_width',
		'label'       => esc_html__( 'Theme Container Width', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_additional_settings',
		'default'     => 100,
		'choices'     => [
			'min'  => 50,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'wedding_planner_lite_site_loader',
		'label'       => esc_html__( 'Here you can enable or disable your Site Loader.', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_additional_settings',
		'default'     => false,
		'priority'    => 10,
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'wedding_planner_lite_preloader_type',
		'label'       => esc_html__( 'Preloader Type', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_additional_settings',
		'default' => 'four-way-loader',
		'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
		'choices'     => [
			'four-way-loader' => __('Type 1','wedding-planner-lite'),
            'cube-loader' => __('Type 2','wedding-planner-lite'),
		],
	] );


		new \Kirki\Field\Select(
	[
		'settings'    => 'wedding_planner_lite_page_layout',
		'label'       => esc_html__( 'Page Layout Setting', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_additional_settings',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','wedding-planner-lite'),
            'Right Sidebar' => __('Right Sidebar','wedding-planner-lite'),
            'One Column' => __('One Column','wedding-planner-lite')
		],
	] );

	if ( class_exists("woocommerce")){

		// Woocommerce Settings

		Kirki::add_section( 'wedding_planner_lite_woocommerce_settings', array(
			'title'          => esc_html__( 'Woocommerce Settings', 'wedding-planner-lite' ),
			'panel'          => 'wedding_planner_lite_panel_id',
			'priority'       => 160,
		) );

		Kirki::add_field( 'theme_config_id', [
		    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
		    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
		    'type'        => 'custom',
		    'section'     => 'wedding_planner_lite_woocommerce_settings',
		    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
		] );


		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'wedding_planner_lite_shop_sidebar',
			'label'       => esc_html__( 'Here you can enable or disable shop page sidebar.', 'wedding-planner-lite' ),
			'section'     => 'wedding_planner_lite_woocommerce_settings',
			'default'     => '1',
			'priority'    => 10,
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'wedding_planner_lite_product_sidebar',
			'label'       => esc_html__( 'Here you can enable or disable product page sidebar.', 'wedding-planner-lite' ),
			'section'     => 'wedding_planner_lite_woocommerce_settings',
			'default'     => '1',
			'priority'    => 10,
		] );

		Kirki::add_field( 'theme_config_id', [
			'type'        => 'toggle',
			'settings'    => 'wedding_planner_lite_related_product_setting',
			'label'       => esc_html__( 'Here you can enable or disable your related products.', 'wedding-planner-lite' ),
			'section'     => 'wedding_planner_lite_woocommerce_settings',
			'default'     => true,
			'priority'    => 10,
		] );

		new \Kirki\Field\Number(
			[
				'settings' => 'wedding_planner_lite_per_columns',
				'label'    => esc_html__( 'Product Per Row', 'wedding-planner-lite' ),
				'section'  => 'wedding_planner_lite_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 4,
					'step' => 1,
				],
			]
		);

		new \Kirki\Field\Number(
			[
				'settings' => 'wedding_planner_lite_product_per_page',
				'label'    => esc_html__( 'Product Per Page', 'wedding-planner-lite' ),
				'section'  => 'wedding_planner_lite_woocommerce_settings',
				'default'  => 9,
				'choices'  => [
					'min'  => 1,
					'max'  => 15,
					'step' => 1,
				],
			]
		);

		new \Kirki\Field\Number(
			[
				'settings' => 'custom_related_products_number_per_row',
				'label'    => esc_html__( 'Related Product Per Column', 'wedding-planner-lite' ),
				'section'  => 'wedding_planner_lite_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 4,
					'step' => 1,
				],
			]
		);

	new \Kirki\Field\Number(
			[
				'settings' => 'custom_related_products_number',
				'label'    => esc_html__( 'Related Product Per Page', 'wedding-planner-lite' ),
				'section'  => 'wedding_planner_lite_woocommerce_settings',
				'default'  => 3,
				'choices'  => [
					'min'  => 1,
					'max'  => 10,
					'step' => 1,
				],
			]
		);

		new \Kirki\Field\Select(
		[
			'settings'    => 'wedding_planner_lite_shop_page_layout',
			'label'       => esc_html__( 'Shop Page Layout Setting', 'wedding-planner-lite' ),
			'section'     => 'wedding_planner_lite_woocommerce_settings',
			'default' => 'Right Sidebar',
			'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
			'choices'     => [
				'Left Sidebar' => __('Left Sidebar','wedding-planner-lite'),
	            'Right Sidebar' => __('Right Sidebar','wedding-planner-lite')
			],
		] );

		new \Kirki\Field\Select(
		[
			'settings'    => 'wedding_planner_lite_product_page_layout',
			'label'       => esc_html__( 'Product Page Layout Setting', 'wedding-planner-lite' ),
			'section'     => 'wedding_planner_lite_woocommerce_settings',
			'default' => 'Right Sidebar',
			'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
			'choices'     => [
				'Left Sidebar' => __('Left Sidebar','wedding-planner-lite'),
	            'Right Sidebar' => __('Right Sidebar','wedding-planner-lite')
			],
		] );

		new \Kirki\Field\Radio_Buttonset(
		[
			'settings'    => 'wedding_planner_lite_woocommerce_pagination_position',
			'label'       => esc_html__( 'Woocommerce Pagination Alignment', 'wedding-planner-lite' ),
			'section'     => 'wedding_planner_lite_woocommerce_settings',
			'default'     => 'Center',
			'priority'    => 10,
			'choices'     => [
				'Left'   => esc_html__( 'Left', 'wedding-planner-lite' ),
				'Center' => esc_html__( 'Center', 'wedding-planner-lite' ),
				'Right'  => esc_html__( 'Right', 'wedding-planner-lite' ),
			],
		]
		);
	}

	// POST SECTION

	Kirki::add_section( 'wedding_planner_lite_section_post', array(
	    'title'          => esc_html__( 'Post Settings', 'wedding-planner-lite' ),
	    'panel'          => 'wedding_planner_lite_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_section_post',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );

	new \Kirki\Field\Sortable(
	[
		'settings' => 'wedding_planner_lite_archive_element_sortable',
		'label'    => __( 'Archive Post Page Element Reordering', 'wedding-planner-lite' ),
		'description'    => esc_html__( 'This setting is not favorable with post format.', 'wedding-planner-lite' ),
		'section'  => 'wedding_planner_lite_section_post',
		'default'  => [ 'option1', 'option2', 'option3', 'option4', 'option5' ],
		'choices'  => [
			'option1' => esc_html__( 'Post Image', 'wedding-planner-lite' ),
			'option2' => esc_html__( 'Post Meta', 'wedding-planner-lite' ),
			'option3' => esc_html__( 'Post Title', 'wedding-planner-lite' ),
			'option4' => esc_html__( 'Post Content', 'wedding-planner-lite' ),
			'option5' => esc_html__( 'Post Button', 'wedding-planner-lite' ),
		],
	]
	);

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'slider',
		'settings'    => 'wedding_planner_lite_post_excerpt_number',
		'label'       => esc_html__( 'Post Content Range', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_post',
		'default'     => 10,
		'choices'     => [
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'toggle',
		'settings'    => 'wedding_planner_lite_pagination_setting',
		'label'       => esc_html__( 'Here you can enable or disable your Pagination.', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_post',
		'default'     => true,
		'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'wedding_planner_lite_archive_sidebar_layout',
		'label'       => esc_html__( 'Archive Post Sidebar Layout Setting', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','wedding-planner-lite'),
            'Right Sidebar' => __('Right Sidebar','wedding-planner-lite'),
            'Three Column' => __('Three Column','wedding-planner-lite'),
            'Four Column' => __('Four Column','wedding-planner-lite'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','wedding-planner-lite'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','wedding-planner-lite'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','wedding-planner-lite')
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'wedding_planner_lite_single_post_sidebar_layout',
		'label'       => esc_html__( 'Single Post Sidebar Layout Setting', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','wedding-planner-lite'),
            'Right Sidebar' => __('Right Sidebar','wedding-planner-lite'),
		],
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'wedding_planner_lite_search_sidebar_layout',
		'label'       => esc_html__( 'Search Page Sidebar Layout Setting', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_section_post',
		'default' => 'Right Sidebar',
		'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
		'choices'     => [
			'Left Sidebar' => __('Left Sidebar','wedding-planner-lite'),
            'Right Sidebar' => __('Right Sidebar','wedding-planner-lite'),
            'Three Column' => __('Three Column','wedding-planner-lite'),
            'Four Column' => __('Four Column','wedding-planner-lite'),
            'Grid Layout Without Sidebar' => __('Grid Layout Without Sidebar','wedding-planner-lite'),
            'Grid Layout With Right Sidebar' => __('Grid Layout With Right Sidebar','wedding-planner-lite'),
            'Grid Layout With Left Sidebar' => __('Grid Layout With Left Sidebar','wedding-planner-lite')
		],
	] );

	// Breadcrumb
	Kirki::add_section( 'wedding_planner_lite_bradcrumb', array(
	    'title'          => esc_html__( 'Breadcrumb Settings', 'wedding-planner-lite' ),
	    'panel'          => 'wedding_planner_lite_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_bradcrumb',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );


	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_enable_breadcrumb_heading',
		'section'     => 'wedding_planner_lite_bradcrumb',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Single Page Breadcrumb', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_breadcrumb_enable',
		'label'       => esc_html__( 'Breadcrumb Enable / Disable', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_bradcrumb',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'default'     => '/',
        'settings' => 'wedding_planner_lite_breadcrumb_separator' ,
        'label'    => esc_html__( 'Breadcrumb Separator',  'wedding-planner-lite' ),
        'section'  => 'wedding_planner_lite_bradcrumb',
    ] );

	// HEADER SECTION

	Kirki::add_section( 'wedding_planner_lite_section_header', array(
	    'title'          => esc_html__( 'Header Settings', 'wedding-planner-lite' ),
	    'panel'          => 'wedding_planner_lite_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_section_header',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );


	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Top Header Text', 'wedding-planner-lite' ),
		'settings' => 'wedding_planner_lite_topheader_text',
		'section'  => 'wedding_planner_lite_section_header',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_enable_socail_link',
		'section'     => 'wedding_planner_lite_section_header',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'wedding_planner_lite_section_header',
		'priority'    => 10,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Social Icon', 'wedding-planner-lite' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'wedding-planner-lite' ),
		'settings'     => 'wedding_planner_lite_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'wedding-planner-lite' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'wedding-planner-lite' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'wedding-planner-lite' ),
				'description' => esc_html__( 'Add the social icon url here.', 'wedding-planner-lite' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_header_contact_us_enable',
		'section'     => 'wedding_planner_lite_section_header',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Contact Button', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Button Text', 'wedding-planner-lite' ),
		'settings' => 'wedding_planner_lite_header_contact_us_txt',
		'section'  => 'wedding_planner_lite_section_header',
		'default'  => '',
		'priority' => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'link',
		'label'       => esc_html__( 'Button Link', 'wedding-planner-lite' ),
		'settings' => 'wedding_planner_lite_header_contact_us_lnk',
		'section'  => 'wedding_planner_lite_section_header',
		'default'  => '',
		'priority' => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_enable_search',
		'section'     => 'wedding_planner_lite_section_header',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Search Box', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 12,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_search_box_enable',
		'section'     => 'wedding_planner_lite_section_header',
		'default'     => '1',
		'priority'    => 12,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );
 
	// SLIDER SECTION

	Kirki::add_section( 'wedding_planner_lite_blog_slide_section', array(
        'title'          => esc_html__( ' Slider Settings', 'wedding-planner-lite' ),
        'panel'          => 'wedding_planner_lite_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_blog_slide_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );


    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_enable_heading',
		'section'     => 'wedding_planner_lite_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Slider', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_blog_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_blog_slide_section',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_slider_heading',
		'section'     => 'wedding_planner_lite_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Main Slider', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'number',
		'settings'    => 'wedding_planner_lite_blog_slide_number',
		'label'       => esc_html__( 'Number of slides to show', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_blog_slide_section',
		'default'     => 2,
		'choices'     => [
			'min'  => 0,
			'max'  => 3,
			'step' => 1,
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'select',
		'settings'    => 'wedding_planner_lite_blog_slide_category',
		'label'       => esc_html__( 'Select the category to show slider ( Image Dimension 750 x 450 )', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_blog_slide_section',
		'default'     => '',
		'placeholder' => esc_html__( 'Select an category...', 'wedding-planner-lite' ),
		'priority'    => 10,
		'choices'     => wedding_planner_lite_get_categories_select(),
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'label'       => esc_html__( 'Slider Sub Title', 'wedding-planner-lite' ),
		'settings' => 'wedding_planner_lite_slider_short_title',
		'section'  => 'wedding_planner_lite_blog_slide_section',
		'priority' => 10,
    ] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'wedding_planner_lite_slider_content_alignment',
		'label'       => esc_html__( 'Slider Content Alignment', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_blog_slide_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'wedding-planner-lite' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'wedding-planner-lite' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'wedding-planner-lite' ),

		],
	] );

		new \Kirki\Field\Select(
	[
		'settings'    => 'wedding_planner_lite_slider_opacity_color',
		'label'       => esc_html__( 'Slider Opacity Option', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_blog_slide_section',
		'default'     => 'unset',
		'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
		'choices'     => [
			'0' => esc_html__( '0', 'wedding-planner-lite' ),
			'0.1' => esc_html__( '0.1', 'wedding-planner-lite' ),
			'0.2' => esc_html__( '0.2', 'wedding-planner-lite' ),
			'0.3' => esc_html__( '0.3', 'wedding-planner-lite' ),
			'0.4' => esc_html__( '0.4', 'wedding-planner-lite' ),
			'0.5' => esc_html__( '0.5', 'wedding-planner-lite' ),
			'0.6' => esc_html__( '0.6', 'wedding-planner-lite' ),
			'0.7' => esc_html__( '0.7', 'wedding-planner-lite' ),
			'0.8' => esc_html__( '0.8', 'wedding-planner-lite' ),
			'0.9' => esc_html__( '0.9', 'wedding-planner-lite' ),
			'unset' => esc_html__( 'Unset', 'wedding-planner-lite' ),
			

		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_second_slider_heading',
		'section'     => 'wedding_planner_lite_blog_slide_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Product Slider', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_slider_product_box_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_blog_slide_section',
		'default'     => true,
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );

	add_action( 'customize_register', 'wedding_planner_lite_customizer_slider_settings' );
	function wedding_planner_lite_customizer_slider_settings( $wp_customize ) {
		$wedding_planner_lite_args = array(
	       'type'                     => 'product',
	        'child_of'                 => 0,
	        'parent'                   => '',
	        'orderby'                  => 'term_group',
	        'order'                    => 'ASC',
	        'hide_empty'               => false,
	        'hierarchical'             => 1,
	        'number'                   => '',
	        'taxonomy'                 => 'product_cat',
	        'pad_counts'               => false
	    );
		$categories = get_categories($wedding_planner_lite_args);
		$cat_posts = array();
		$m = 0;
		$cat_posts[]='Select';
		foreach($categories as $category){
			if($m==0){
				$default = $category->slug;
				$m++;
			}
			$cat_posts[$category->slug] = $category->name;
		}

		$wp_customize->add_setting('wedding_planner_lite_sider_product_category',array(
			'default'	=> 'select',
			'sanitize_callback' => 'wedding_planner_lite_sanitize_select',
		));
		$wp_customize->add_control('wedding_planner_lite_sider_product_category',array(
			'type'    => 'select',
			'choices' => $cat_posts,
			'label' => __('Select category to display products ','wedding-planner-lite'),
			'section' => 'wedding_planner_lite_blog_slide_section',
		));
	}

	// OUR PRODUCT SECTION

	Kirki::add_section( 'wedding_planner_lite_our_product_section', array(
	    'title'          => esc_html__( 'Our Product Settings', 'wedding-planner-lite' ),
	    'panel'          => 'wedding_planner_lite_panel_id',
	    'priority'       => 160,
	) );

	Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_our_product_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_enable_heading',
		'section'     => 'wedding_planner_lite_our_product_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Our Product Section',  'wedding-planner-lite' ) . '</h3>',
		'priority'    => 1,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_our_product_section_enable',
		'label'       => esc_html__( 'Section Enable / Disable',  'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_our_product_section',
		'default'     => false,
		'priority'    => 2,
		'choices'     => [
			'on'  => esc_html__( 'Enable',  'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable',  'wedding-planner-lite' ),
		],
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_daily_deals_heading',
		'section'     => 'wedding_planner_lite_our_product_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Daily Deals',  'wedding-planner-lite' ) . '</h3>',
		'priority'    => 3,
	] );

    Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'wedding_planner_lite_daily_deals_heading_text' ,
        'label'    => esc_html__( 'Heading',  'wedding-planner-lite' ),
        'section'  => 'wedding_planner_lite_our_product_section',
        'priority'    => 3,
    ] );

    Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'wedding_planner_lite_daily_deals_timmer' ,
        'label'    => esc_html__( 'Add  Daily Deals Timer',  'wedding-planner-lite' ),
        'section'  => 'wedding_planner_lite_our_product_section',
        'description' => esc_html__( 'Ex: 10 March 2024', 'wedding-planner-lite' ),
        'priority'    => 3,
    ] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_tab_section_heading',
		'section'     => 'wedding_planner_lite_our_product_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Tab Section',  'wedding-planner-lite' ) . '</h3>',
		'priority'    => 4,
	] );

	Kirki::add_field( 'theme_config_id', [
        'type'     => 'text',
        'settings' => 'wedding_planner_lite_our_product_heading' ,
        'label'    => esc_html__( 'Heading',  'wedding-planner-lite' ),
        'section'  => 'wedding_planner_lite_our_product_section',
    ] );

	// FOOTER SECTION

	Kirki::add_section( 'wedding_planner_lite_footer_section', array(
        'title'          => esc_html__( 'Footer Settings', 'wedding-planner-lite' ),
        'panel'          => 'wedding_planner_lite_panel_id',
        'priority'       => 160,
    ) );

    Kirki::add_field( 'theme_config_id', [
	    'label'       => '<span class="custom-label-class">' . esc_html__( 'INFORMATION ABOUT PREMIUM VERSION :-', 'wedding-planner-lite' ) . '</span>',
	    'default'     => '<a class="premium_info_btn" target="_blank" href="' . esc_url( WEDDING_PLANNER_LITE_BUY_NOW ) . '">' . __( 'GO TO PREMIUM', 'wedding-planner-lite' ) . '</a>',
	    'type'        => 'custom',
	    'section'     => 'wedding_planner_lite_footer_section',
	    'description' => '<div class="custom-description-class">' . __( '<p>1. One Click Demo Importer </p><p>2. Color Pallete Setup </p><p>3. Section Reordering Facility</p><p>4. For More Options kindly Go For Premium Version.</p>', 'wedding-planner-lite' ) . '</div>',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_footer_enable_heading',
		'section'     => 'wedding_planner_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Enable / Disable Footer Link', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'switch',
		'settings'    => 'wedding_planner_lite_copyright_enable',
		'label'       => esc_html__( 'Section Enable / Disable', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_footer_section',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => [
			'on'  => esc_html__( 'Enable', 'wedding-planner-lite' ),
			'off' => esc_html__( 'Disable', 'wedding-planner-lite' ),
		],
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_footer_text_heading',
		'section'     => 'wedding_planner_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Text', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 10,
	] );

    Kirki::add_field( 'theme_config_id', [
		'type'     => 'text',
		'settings' => 'wedding_planner_lite_footer_text',
		'section'  => 'wedding_planner_lite_footer_section',
		'default'  => '',
		'priority' => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'wedding_planner_lite_footer_text_heading_2',
	'section'     => 'wedding_planner_lite_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Alignment', 'wedding-planner-lite' ) . '</h3>',
	'priority'    => 10,
	] );

	new \Kirki\Field\Select(
	[
		'settings'    => 'wedding_planner_lite_copyright_text_alignment',
		'label'       => esc_html__( 'Copyright text Alignment', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_footer_section',
		'default'     => 'LEFT-ALIGN',
		'placeholder' => esc_html__( 'Choose an option', 'wedding-planner-lite' ),
		'choices'     => [
			'LEFT-ALIGN' => esc_html__( 'LEFT-ALIGN', 'wedding-planner-lite' ),
			'CENTER-ALIGN' => esc_html__( 'CENTER-ALIGN', 'wedding-planner-lite' ),
			'RIGHT-ALIGN' => esc_html__( 'RIGHT-ALIGN', 'wedding-planner-lite' ),

		],
	] );

	Kirki::add_field( 'theme_config_id', [
	'type'        => 'custom',
	'settings'    => 'wedding_planner_lite_footer_text_heading_1',
	'section'     => 'wedding_planner_lite_footer_section',
		'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Footer Copyright Background Color', 'wedding-planner-lite' ) . '</h3>',
	'priority'    => 10,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'color',
		'settings'    => 'wedding_planner_lite_copyright_bg',
		'label'       => __( 'Choose Your Copyright Background Color', 'wedding-planner-lite' ),
		'section'     => 'wedding_planner_lite_footer_section',
		'default'     => '#000000',
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'custom',
		'settings'    => 'wedding_planner_lite_enable_footer_socail_link',
		'section'     => 'wedding_planner_lite_footer_section',
			'default'         => '<h3 style="color: #2271b1; padding:10px; background:#fff; margin:0; border-left: solid 5px #2271b1; ">' . __( 'Social Media Link', 'wedding-planner-lite' ) . '</h3>',
		'priority'    => 11,
	] );

	Kirki::add_field( 'theme_config_id', [
		'type'        => 'repeater',
		'section'     => 'wedding_planner_lite_footer_section',
		'priority'    => 11,
		'row_label' => [
			'type'  => 'field',
			'value' => esc_html__( 'Footer Social Icon', 'wedding-planner-lite' ),
			'field' => 'link_text',
		],
		'button_label' => esc_html__('Add New Social Icon', 'wedding-planner-lite' ),
		'settings'     => 'wedding_planner_lite_footer_social_links_settings',
		'default'      => '',
		'fields' 	   => [
			'link_text' => [
				'type'        => 'text',
				'label'       => esc_html__( 'Icon', 'wedding-planner-lite' ),
				'description' => esc_html__( 'Add the fontawesome class ex: "fab fa-facebook-f".', 'wedding-planner-lite' ),
				'default'     => '',
			],
			'link_url' => [
				'type'        => 'url',
				'label'       => esc_html__( 'Social Link', 'wedding-planner-lite' ),
				'description' => esc_html__( 'Add the social icon url here.', 'wedding-planner-lite' ),
				'default'     => '',
			],
		],
		'choices' => [
			'limit' => 5
		],
	] );
}


add_action( 'customize_register', 'wedding_planner_lite_customizer_settings' );
function wedding_planner_lite_customizer_settings( $wp_customize ) {

	$wedding_planner_lite_args = array(
	       'type'                     => 'product',
	        'child_of'                 => 0,
	        'parent'                   => '',
	        'orderby'                  => 'term_group',
	        'order'                    => 'ASC',
	        'hide_empty'               => false,
	        'hierarchical'             => 1,
	        'number'                   => '',
	        'taxonomy'                 => 'product_cat',
	        'pad_counts'               => false
	    );
		$categories = get_categories($wedding_planner_lite_args);
		$daily_deals_cat_posts = array();
		$m = 0;
		$daily_deals_cat_posts[]='Select';
		foreach($categories as $category){
			if($m==0){
				$default = $category->slug;
				$m++;
			}
			$daily_deals_cat_posts[$category->slug] = $category->name;
		}

		$wp_customize->add_setting('wedding_planner_lite_daily_deals_product_category',array(
			'default'	=> 'select',
			'sanitize_callback' => 'wedding_planner_lite_sanitize_select',
		));
		$wp_customize->add_control('wedding_planner_lite_daily_deals_product_category',array(
			'type'    => 'select',
			'choices' => $daily_deals_cat_posts,
			'label' => __('Select category to display products ','wedding-planner-lite'),
			'section' => 'wedding_planner_lite_our_product_section',
			'priority' => 3,
		));

	$wp_customize->add_setting('wedding_planner_lite_our_product_tab_number',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control('wedding_planner_lite_our_product_tab_number',array(
		'type' => 'number',
		'label' => __('Show number of product tab','wedding-planner-lite'),
		'section' => 'wedding_planner_lite_our_product_section',
	));

	$wedding_planner_lite_product_post = get_theme_mod('wedding_planner_lite_our_product_tab_number','');
    for ( $wedding_planner_lite_j = 1; $wedding_planner_lite_j <= $wedding_planner_lite_product_post; $wedding_planner_lite_j++ ) {

		$wp_customize->add_setting('wedding_planner_lite_our_product_tabs_text'.$wedding_planner_lite_j,array(
			'default' => '',
			'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control('wedding_planner_lite_our_product_tabs_text'.$wedding_planner_lite_j,array(
			'type' => 'text',
			'label' => __('Tab Text ','wedding-planner-lite').$wedding_planner_lite_j,
			'section' => 'wedding_planner_lite_our_product_section',
		));

		$wedding_planner_lite_args = array(
	       'type'                     => 'product',
	        'child_of'                 => 0,
	        'parent'                   => '',
	        'orderby'                  => 'term_group',
	        'order'                    => 'ASC',
	        'hide_empty'               => false,
	        'hierarchical'             => 1,
	        'number'                   => '',
	        'taxonomy'                 => 'product_cat',
	        'pad_counts'               => false
	    );
		$categories = get_categories($wedding_planner_lite_args);
		$wedding_planner_lite_cat_posts = array();
		$wedding_planner_lite_m = 0;
		$wedding_planner_lite_cat_posts[]='Select';
		foreach($categories as $category){
			if($wedding_planner_lite_m==0){
				$default = $category->slug;
				$wedding_planner_lite_m++;
			}
			$wedding_planner_lite_cat_posts[$category->slug] = $category->name;
		}

		$wp_customize->add_setting('wedding_planner_lite_our_product_category'.$wedding_planner_lite_j,array(
			'default'	=> 'select',
			'sanitize_callback' => 'wedding_planner_lite_sanitize_select',
		));

		$wp_customize->add_control('wedding_planner_lite_our_product_category'.$wedding_planner_lite_j,array(
			'type'    => 'select',
			'choices' => $wedding_planner_lite_cat_posts,
			'label' => __('Select category to display products ','wedding-planner-lite').$wedding_planner_lite_j,
			'section' => 'wedding_planner_lite_our_product_section',
		));
	}
}

/*
 *  Customizer Notifications
 */

$wedding_planner_lite_config_customizer = array(
    'recommended_plugins' => array( 
        'kirki' => array(
            'recommended' => true,
            'description' => sprintf( 
                /* translators: %s: plugin name */
                esc_html__( 'If you want to show all the sections of the FrontPage, please install and activate %s plugin', 'wedding-planner-lite' ), 
                '<strong>' . esc_html__( 'Kirki Customizer', 'wedding-planner-lite' ) . '</strong>'
            ),
        ),
    ),
    'wedding_planner_lite_recommended_actions'       => array(),
    'wedding_planner_lite_recommended_actions_title' => esc_html__( 'Recommended Actions', 'wedding-planner-lite' ),
    'wedding_planner_lite_recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'wedding-planner-lite' ),
    'wedding_planner_lite_install_button_label'      => esc_html__( 'Install and Activate', 'wedding-planner-lite' ),
    'wedding_planner_lite_activate_button_label'     => esc_html__( 'Activate', 'wedding-planner-lite' ),
    'wedding_planner_lite_deactivate_button_label'   => esc_html__( 'Deactivate', 'wedding-planner-lite' ),
);

Wedding_Planner_Lite_Customizer_Notify::init( apply_filters( 'wedding_planner_lite_customizer_notify_array', $wedding_planner_lite_config_customizer ) );