<?php

class Wedding_Planner_Lite_Customizer_Notify {

	private $config = array(); // Declare $config property
	
	private $wedding_planner_lite_recommended_actions;
	
	private $recommended_plugins;
	
	private static $instance;
	
	private $wedding_planner_lite_recommended_actions_title;
	
	private $wedding_planner_lite_recommended_plugins_title;
	
	private $dismiss_button;
	
	private $wedding_planner_lite_install_button_label;
	
	private $wedding_planner_lite_activate_button_label;
	
	private $wedding_planner_lite_deactivate_button_label;

	
	public static function init( $config ) {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Wedding_Planner_Lite_Customizer_Notify ) ) {
			self::$instance = new Wedding_Planner_Lite_Customizer_Notify;
			if ( ! empty( $config ) && is_array( $config ) ) {
				self::$instance->config = $config;
				self::$instance->setup_config();
				self::$instance->setup_actions();
			}
		}

	}

	
	public function setup_config() {

		global $wedding_planner_lite_customizer_notify_recommended_plugins;
		global $wedding_planner_lite_customizer_notify_wedding_planner_lite_recommended_actions;

		global $wedding_planner_lite_install_button_label;
		global $wedding_planner_lite_activate_button_label;
		global $wedding_planner_lite_deactivate_button_label;

		$this->wedding_planner_lite_recommended_actions = isset( $this->config['wedding_planner_lite_recommended_actions'] ) ? $this->config['wedding_planner_lite_recommended_actions'] : array();
		$this->recommended_plugins = isset( $this->config['recommended_plugins'] ) ? $this->config['recommended_plugins'] : array();

		$this->wedding_planner_lite_recommended_actions_title = isset( $this->config['wedding_planner_lite_recommended_actions_title'] ) ? $this->config['wedding_planner_lite_recommended_actions_title'] : '';
		$this->wedding_planner_lite_recommended_plugins_title = isset( $this->config['wedding_planner_lite_recommended_plugins_title'] ) ? $this->config['wedding_planner_lite_recommended_plugins_title'] : '';
		$this->dismiss_button            = isset( $this->config['dismiss_button'] ) ? $this->config['dismiss_button'] : '';

		$wedding_planner_lite_customizer_notify_recommended_plugins = array();
		$wedding_planner_lite_customizer_notify_wedding_planner_lite_recommended_actions = array();

		if ( isset( $this->recommended_plugins ) ) {
			$wedding_planner_lite_customizer_notify_recommended_plugins = $this->recommended_plugins;
		}

		if ( isset( $this->wedding_planner_lite_recommended_actions ) ) {
			$wedding_planner_lite_customizer_notify_wedding_planner_lite_recommended_actions = $this->wedding_planner_lite_recommended_actions;
		}

		$wedding_planner_lite_install_button_label    = isset( $this->config['wedding_planner_lite_install_button_label'] ) ? $this->config['wedding_planner_lite_install_button_label'] : '';
		$wedding_planner_lite_activate_button_label   = isset( $this->config['wedding_planner_lite_activate_button_label'] ) ? $this->config['wedding_planner_lite_activate_button_label'] : '';
		$wedding_planner_lite_deactivate_button_label = isset( $this->config['wedding_planner_lite_deactivate_button_label'] ) ? $this->config['wedding_planner_lite_deactivate_button_label'] : '';

	}

	
	public function setup_actions() {

		// Register the section
		add_action( 'customize_register', array( $this, 'wedding_planner_lite_plugin_notification_customize_register' ) );

		// Enqueue scripts and styles
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'wedding_planner_lite_customizer_notify_scripts_for_customizer' ), 0 );

		/* ajax callback for dismissable recommended actions */
		add_action( 'wp_ajax_quality_customizer_notify_dismiss_action', array( $this, 'wedding_planner_lite_customizer_notify_dismiss_recommended_action_callback' ) );

		add_action( 'wp_ajax_ti_customizer_notify_dismiss_recommended_plugins', array( $this, 'wedding_planner_lite_customizer_notify_dismiss_recommended_plugins_callback' ) );

	}

	
	public function wedding_planner_lite_customizer_notify_scripts_for_customizer() {

		wp_enqueue_style( 'wedding-planner-lite-customizer-notify-css', get_template_directory_uri() . '/core/includes/customizer-notice/css/wedding-planner-lite-customizer-notify.css', array());

		wp_enqueue_style( 'plugin-install' );
		wp_enqueue_script( 'plugin-install' );
		wp_add_inline_script( 'plugin-install', 'var pagenow = "customizer";' );

		wp_enqueue_script( 'updates' );

		wp_enqueue_script( 'wedding-planner-lite-customizer-notify-js', get_template_directory_uri() . '/core/includes/customizer-notice/js/wedding-planner-lite-customizer-notify.js', array( 'customize-controls' ));
		wp_localize_script(
			'wedding-planner-lite-customizer-notify-js', 'weddingplannerliteCustomizercompanionObject', array(
				'ajaxurl'            => admin_url( 'admin-ajax.php' ),
				'template_directory' => get_template_directory_uri(),
				'base_path'          => admin_url(),
				'activating_string'  => __( 'Activating', 'wedding-planner-lite' ),
			)
		);

	}

	
	public function wedding_planner_lite_plugin_notification_customize_register( $wp_customize ) {

		
		require_once get_template_directory() . '/core/includes/customizer-notice/wedding-planner-lite-customizer-notify-section.php';

		$wp_customize->register_section_type( 'Wedding_Planner_Lite_Customizer_Notify_Section' );

		$wp_customize->add_section(
			new Wedding_Planner_Lite_Customizer_Notify_Section(
				$wp_customize,
				'wedding-planner-lite-customizer-notify-section',
				array(
					'title'          => $this->wedding_planner_lite_recommended_actions_title,
					'plugin_text'    => $this->wedding_planner_lite_recommended_plugins_title,
					'dismiss_button' => $this->dismiss_button,
					'priority'       => 0,
				)
			)
		);

	}

	
	public function wedding_planner_lite_customizer_notify_dismiss_recommended_action_callback() {

		global $wedding_planner_lite_customizer_notify_wedding_planner_lite_recommended_actions;

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */ 

		if ( ! empty( $action_id ) ) {
			
			if ( get_option( 'wedding_planner_lite_customizer_notify_show' ) ) {

				$wedding_planner_lite_customizer_notify_show_wedding_planner_lite_recommended_actions = get_option( 'wedding_planner_lite_customizer_notify_show' );
				switch ( $_GET['todo'] ) {
					case 'add':
						$wedding_planner_lite_customizer_notify_show_wedding_planner_lite_recommended_actions[ $action_id ] = true;
						break;
					case 'dismiss':
						$wedding_planner_lite_customizer_notify_show_wedding_planner_lite_recommended_actions[ $action_id ] = false;
						break;
				}
				update_option( 'wedding_planner_lite_customizer_notify_show', $wedding_planner_lite_customizer_notify_show_wedding_planner_lite_recommended_actions );

				
			} else {
				$wedding_planner_lite_customizer_notify_show_wedding_planner_lite_recommended_actions = array();
				if ( ! empty( $wedding_planner_lite_customizer_notify_wedding_planner_lite_recommended_actions ) ) {
					foreach ( $wedding_planner_lite_customizer_notify_wedding_planner_lite_recommended_actions as $wedding_planner_lite_lite_customizer_notify_recommended_action ) {
						if ( $wedding_planner_lite_lite_customizer_notify_recommended_action['id'] == $action_id ) {
							$wedding_planner_lite_customizer_notify_show_wedding_planner_lite_recommended_actions[ $wedding_planner_lite_lite_customizer_notify_recommended_action['id'] ] = false;
						} else {
							$wedding_planner_lite_customizer_notify_show_wedding_planner_lite_recommended_actions[ $wedding_planner_lite_lite_customizer_notify_recommended_action['id'] ] = true;
						}
					}
					update_option( 'wedding_planner_lite_customizer_notify_show', $wedding_planner_lite_customizer_notify_show_wedding_planner_lite_recommended_actions );
				}
			}
		}
		die(); 
	}

	
	public function wedding_planner_lite_customizer_notify_dismiss_recommended_plugins_callback() {

		$action_id = ( isset( $_GET['id'] ) ) ? $_GET['id'] : 0;

		echo esc_html( $action_id ); /* this is needed and it's the id of the dismissable required action */

		if ( ! empty( $action_id ) ) {

			$wedding_planner_lite_lite_customizer_notify_show_recommended_plugins = get_option( 'wedding_planner_lite_customizer_notify_show_recommended_plugins' );

			switch ( $_GET['todo'] ) {
				case 'add':
					$wedding_planner_lite_lite_customizer_notify_show_recommended_plugins[ $action_id ] = false;
					break;
				case 'dismiss':
					$wedding_planner_lite_lite_customizer_notify_show_recommended_plugins[ $action_id ] = true;
					break;
			}
			update_option( 'wedding_planner_lite_customizer_notify_show_recommended_plugins', $wedding_planner_lite_lite_customizer_notify_show_recommended_plugins );
		}
		die(); 
	}

}
