<?php
/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Wedding_Planner_Lite_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	*/
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/core/includes/upgrade-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Wedding_Planner_Lite_Customize_Section_Pro' );

		// Add the PRO Upgrade section.
		$manager->add_section(
		    new Wedding_Planner_Lite_Customize_Section_Pro(
		        $manager,
		        'wedding_planner_lite_upgrade_pro',
		        array(
		            'title'         => esc_html__( 'Wedding Planner Lite PRO', 'wedding-planner-lite' ),
		            'pro_text'      => esc_html__( 'Wedding PRO', 'wedding-planner-lite' ),
		            'pro_url'       => esc_url( WEDDING_PLANNER_LITE_BUY_NOW ),
		            'demo_text'     => esc_html__( 'Demo', 'wedding-planner-lite' ),
		            'demo_url'      => esc_url( WEDDING_PLANNER_LITE_DEMO_PRO ),
		            'support_text'  => esc_html__( 'Support', 'wedding-planner-lite' ),
		            'support_url'   => esc_url( WEDDING_PLANNER_LITE_SUPPORT_FREE ),
		            'bundle_text'   => esc_html__( 'Get All Themes', 'wedding-planner-lite' ),
		            'bundle_url'    => esc_url( WEDDING_PLANNER_LITE_THEME_BUNDLE ),
		            'lite_doc_text' => esc_html__( 'Lite Doc', 'wedding-planner-lite' ),
		            'lite_doc_url'  => esc_url( WEDDING_PLANNER_LITE_DOCS_FREE ),
		            'review_text'   => esc_html__( 'Review', 'wedding-planner-lite' ),
		            'review_url'    => esc_url( WEDDING_PLANNER_LITE_REVIEW_FREE ),
		            'priority'      => 1,
		        )
		    )
		);

	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script(
			'wedding-planner-lite-customize-controls',
			trailingslashit( get_template_directory_uri() ) . '/js/customize-controls.js',
			array( 'customize-controls' )
		);

		wp_enqueue_style(
			'wedding-planner-lite-customize-controls',
			trailingslashit( get_template_directory_uri() ) . '/css/customize-controls.css'
		);
	}
}

// Doing this customizer thang!
Wedding_Planner_Lite_Customize::get_instance();
