<?php 

/* Meta boxes */

function webvideo_settings(){
	add_meta_box("webvideo_post_meta", "Webvideo Settings", "webvideo_display_options", "post", "normal", "high");
}
add_action("admin_init", "webvideo_settings");

function webvideo_display_options($callback_args) {
	global $post;
			
	$webvideo_fs_video = get_post_meta( $post->ID, '_et_webvideo_video_url', true );
?>
	
	<?php wp_nonce_field( basename( __FILE__ ), 'webvideo_settings_nonce' ); ?>
	
	<div id="webvideo_custom_settings">				
		
		<h4><?php esc_html_e('Video Post Format Settings: ','webvideo'); ?></h4>
		
		<div class="webvideo_fs_setting">
			<label for="webvideo_fs_video"> <?php esc_html_e('Video url:','webvideo'); ?> </label>
			<input type="text" value="<?php echo esc_url($webvideo_fs_video); ?>" id="webvideo_fs_video" name="webvideo_fs_video" size="67" />
			<br />
			
		</div>
		
	</div> 
		
	<?php
}

add_action( 'save_post', 'webvideo_save_details', 10, 2 );
function webvideo_save_details( $post_id, $post ){
	global $pagenow;
	if ( 'post.php' != $pagenow ) return $post_id;
		
	if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE ) 
		return $post_id;

	$post_type = get_post_type_object( $post->post_type );
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;
		
	if ( !isset( $_POST['webvideo_settings_nonce'] ) || !wp_verify_nonce( $_POST['webvideo_settings_nonce'], basename( __FILE__ ) ) )
        return $post_id;
		
	if ( isset($_POST["webvideo_fs_video"]) ) update_post_meta( $post_id, "_et_webvideo_video_url", esc_url_raw( $_POST["webvideo_fs_video"] ) );

} ?>