<?php  
  function webvideo_get_option($Aoption_name, $default = null)
  {
    return stripslashes(get_option($Aoption_name, $default));
  };
  
  function webvideo_register_my_menus() {
	register_nav_menus(
		array(
			'menu-1' => __( 'Menu 1', 'webvideo' ),		
		)
	);
}
add_action( 'after_setup_theme', 'webvideo_register_my_menus' );

function webvideo_script_loader() {      
    global $wp_styles;
        
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
   wp_enqueue_style( 'webvideo', get_template_directory_uri() . '/style.css');
}
add_action('wp_enqueue_scripts', 'webvideo_script_loader');

  function webvideo_template_setup() 
  {	
    global $webvideo_content_width, $webvideo_favicon_url;

	
    if ( ! isset( $content_width ) ) 
      $content_width = 630;  
	load_theme_textdomain('webvideo', get_template_directory() . '/languages');	
	  require_once(get_template_directory()  . '/includes/additional_functions.php');

	function webvideo_add_editor_styles() {
    add_editor_style( 'custom-editor-style.css' );
}
	add_action( 'init', 'webvideo_add_editor_styles' );	
	add_theme_support( 'automatic-feed-links' );	
	add_theme_support('post-thumbnails');
	set_post_thumbnail_size( 700, 9999, true );
	add_theme_support( 'custom-background' );	
		   
  };

  
  add_action('after_setup_theme', 'webvideo_template_setup');
  
  
if ( ! function_exists( 'webvideo_filter_wp_title' ) ) :	
function webvideo_filter_wp_title( $title ) {
	global $page, $paged;
    $site_name = get_bloginfo( 'name' );
    $filtered_title = $site_name . $title;
      return $filtered_title;
	  $site_description = get_bloginfo( 'description', 'display' );
	if ( $site_description && ( is_home() || is_front_page() ) )
		echo " | $site_description";
		if ( $paged >= 2 || $page >= 2 )
		echo ' | ' . sprintf( __( 'Page %s', 'webvideo' ), max( $paged, $page ) ); 
}
endif; 
add_filter( 'wp_title', 'webvideo_filter_wp_title' );

  
  if ( ! function_exists( 'webvideo_comment' ) ) :	
  function webvideo_comment( $comment, $args, $depth ) {
	$GLOBALS['comment'] = $comment;
	switch ( $comment->comment_type ) :
		case '' :
	?>
	<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
		<div id="comment-<?php comment_ID(); ?>">
		<div class="comment-author vcard">
			<?php echo sanitize_text_field(get_avatar( $comment, 40 )); ?>
			<?php printf( __( '%s <span class="says">says:</span>', 'webvideo' ), sprintf( '<cite class="fn">%s</cite>', get_comment_author_link() ) ); ?>
		</div><!-- .comment-author .vcard -->
		<?php if ( $comment->comment_approved == '0' ) : ?>
			<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'webvideo' ); ?></em>
			<br />
		<?php endif; ?>

		<div class="comment-meta commentmetadata"><a href="<?php echo sanitize_text_field(esc_url( get_comment_link( $comment->comment_ID ) )); ?>">
			<?php
				/* translators: 1: date, 2: time */
				printf( __( '%1$s at %2$s', 'webvideo' ), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)', 'webvideo' ), ' ' );
			?>
		</div><!-- .comment-meta .commentmetadata -->

		<div class="comment-body"><?php sanitize_text_field(comment_text()); ?></div>

		<div class="reply">
			<?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
		</div><!-- .reply -->
	</div><!-- #comment-##  -->

	<?php
			break;
		case 'pingback'  :
		case 'trackback' :
	?>
	<li class="post pingback">
		<p><?php _e( 'Pingback:', 'webvideo' ); ?> <?php comment_author_link(); ?><?php edit_comment_link( __( '(Edit)', 'webvideo' ), ' ' ); ?></p>
	<?php
			break;
	endswitch;
  };
  endif; 

function webvideo_widgets_init() {
 register_sidebar( array(
'name' => __('Footer Sidebar 1', 'webvideo'),
'id' => 'footer-sidebar-1',
'description' => __('Appears in the footer area', 'webvideo'),
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
register_sidebar( array(
'name' => __('Footer Sidebar 2', 'webvideo'),
'id' => 'footer-sidebar-2',
'description' => __('Appears in the footer area', 'webvideo'),
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
register_sidebar( array(
'name' => __('Footer Sidebar 3', 'webvideo'),
'id' => 'footer-sidebar-3',
'description' => __('Appears in the footer area', 'webvideo'),
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
}
  add_action('widgets_init', 'webvideo_widgets_init');
   


	
	function webvideo_wp_corenavi() {
  global $wp_query, $wp_rewrite;
  $pages = '';
  $max = $wp_query->max_num_pages;
  if (!$current = get_query_var('paged')) $current = 1;
  $a['base'] = str_replace(999999999, '%#%', get_pagenum_link(999999999));
  $a['total'] = $max;
  $a['current'] = $current;

  $total = 1; 
  $a['mid_size'] = 3; 
  $a['end_size'] = 1; 
  $a['prev_text'] = '&laquo;'; 
  $a['next_text'] = '&raquo;'; 

  if ($max > 1) echo '<div class="navigation">';

  echo $pages . paginate_links($a);
  if ($max > 1) echo '</div>';
}


if ( ! function_exists( 'webvideo_options_admin_menu' ) ) :
  function webvideo_options_admin_menu() 
  {	    
	$vbw_theme_page = add_theme_page(__("Webvideo Options", 'webvideo'), __("Webvideo Options", 'webvideo'), 
	  'edit_theme_options', 'webvideo_general_options_page', 'webvideo_general_options_page');	
  };
  endif; 
  
  add_action('admin_menu', 'webvideo_options_admin_menu');
  
  $webvideo_options = get_option( 'webvideo_options' );	

	   
add_action('wp_head', 'webvideo_head');

  function webvideo_head()
  {  
    if (!is_admin())
	{
	  global $webvideo_favicon_url;
?>	
<link rel="shortcut icon" href="<?php echo sanitize_text_field(webvideo_get_option('webvideo_favicon_url', $webvideo_favicon_url)); ?>" type="image/x-icon" />


<?php	  
	};
  };   
   
 
   function webvideo_options_update() 
   {
     global $_POST, $webvideo_favicon_url;
		
	 if ($_POST['webvideo_favicon_url'] != '')
	 {
	   update_option('webvideo_favicon_url', $_POST['webvideo_favicon_url']);
	 } else 
	 {
	   update_option('webvideo_favicon_url', $webvideo_favicon_url);	  
	 };
		
		  };
		  
 function webvideo_options_validate ( $webvideo_options) {  
    $output = array();  
    foreach( $webvideo_options as $key => $value ) {  
        if( isset( $webvideo_options[$key] ) ) {  
            $output[$key] = strip_tags( stripslashes( $webvideo_options[ $key ] ) );        
        }          
    }  
    return apply_filters( 'webvideo_options_validate', $output, $webvideo_options );    
}  

  

	
function webvideo_general_options_input() {  
register_setting('webvideo_general_options_page','webvideo_general_options_page','webvideo_options_validate'); 
register_setting( 'webvideo_general_options_page', 'webvideo_favicon_url' ); 
}

add_action( 'admin_init', 'webvideo_general_options_input' );  		  
 
   
    if ( ! function_exists( 'webvideo_general_options_page' ) ) :
  function webvideo_general_options_page()
  {
    global  $_POST, $webvideo_favicon_url; 
	
 if ( isset($_POST['update_options']) && $_POST['update_options'] == 'true' )
?>	
	    <div class="wrap">
		<div id="icon-options-general" class="icon32"><br /></div>
      		<h2><?php _e('Webvideo General Options', 'webvideo'); ?></h2>

        <form method="post" action="options.php">
		<?php 
 wp_nonce_field('update-options'); ?>

			
            <table class="form-table">

 <tr valign="top">
                    <th scope="row"><label for="webvideo_favicon_url"><?php _e('Favicon:', 'webvideo'); ?></label></th>
                    <td><input type="text" name="webvideo_favicon_url" size="95" 
					  value="<?php echo sanitize_text_field(webvideo_get_option('webvideo_favicon_url', $webvideo_favicon_url)); ?>"/>
					<br/>
					<span class="description"> 
					<?php printf(__('<a href="%s" target="_blank">Upload your favicon</a> using WordPress Media Library and insert its URL here', 
					  'webvideo'), home_url().'/wp-admin/media-new.php'); ?>
					</span><br/><br/>
					<img src="<?php echo sanitize_text_field(webvideo_get_option('webvideo_favicon_url', $webvideo_favicon_url)); ?>" alt=""/>
					</td>
                </tr>	  		
			    										
					
            </table>
	<input type="hidden" name="action" value="update" />
	<input type="hidden" name="page_options" value="webvideo_favicon_url" />
		<a href="https://twitter.com/wpmole" class="twitter-follow-button" data-show-count="false">Follow @wpmole</a>
<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script> <a href="http://www.facebook.com/pages/WPMole/142454599181539" target="_blank"><img src="<?php echo get_template_directory_uri(); ?>/img/facebook.png" /></a>  <a href="http://wpmole.com" target="_blank">WPMole</a>
 <?php submit_button(); ?>
        </form>
		
    </div>
	<?php

if ( !empty($_POST) && check_admin_referer( 'update-options') ) {
}

  };
   endif; 
?>