document.addEventListener('DOMContentLoaded', () => {
    // Ensure Swiper elements are present in the DOM
    const mainSwiperContainer = document.querySelector('.swiper-container');
    const sliderGridContainer = document.querySelector('.slider-grid-widget');

    if (mainSwiperContainer) {
        // Initialize the main Swiper slider
        const mainSwiper = new Swiper('.swiper-container', {
            slidesPerView: 1,
            spaceBetween: 20,
            autoplay: {
                delay: 3000, // 3 seconds delay before autoplay starts
                disableOnInteraction: false, // Keep autoplay running even after user interacts
            },
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
        });

        console.log('Main Swiper Initialized:', mainSwiper);
    } else {
        console.warn('Main Swiper container not found.');
    }

    if (sliderGridContainer) {
        // Initialize the Slider Grid Swiper
        const sliderGridSwiper = new Swiper('.slider-grid-widget', {
            slidesPerView: 4, // Default to 4 slides
            spaceBetween: 10,
            loop: true,
            autoplay: {
                delay: 3000, // 3 seconds delay before autoplay starts
                disableOnInteraction: false, // Keep autoplay running even after user interacts
            },
            navigation: {
                nextEl: '.custom-swiper-next',
                prevEl: '.custom-swiper-prev',
            },
            breakpoints: {
                // For screens smaller than 768px
                0: {
                    slidesPerView: 1, // Mobile: 1 slide
                },
                // For screens 768px and larger
                768: {
                    slidesPerView: 4, // Tablet and larger: 4 slides
                },
            },
        });

        console.log('Slider Grid Swiper Initialized:', sliderGridSwiper);

        // Debugging navigation buttons
        const nextButton = document.querySelector('.custom-swiper-next');
        const prevButton = document.querySelector('.custom-swiper-prev');

        if (nextButton) {
            nextButton.addEventListener('click', () => {
                console.log('Slider Grid Next button clicked');
            });
        } else {
            console.warn('Next button for Slider Grid Swiper not found.');
        }

        if (prevButton) {
            prevButton.addEventListener('click', () => {
                console.log('Slider Grid Previous button clicked');
            });
        } else {
            console.warn('Previous button for Slider Grid Swiper not found.');
        }
    } else {
        console.warn('Slider Grid container not found.');
    }
});
