<?php
/**
 *  Font Sizes
 *  Google fonts
 *  Excerpt Lenth Controller
 *  Sticky Sidebar
 */ 

function wavypixel_options_settings_customize_register( $wp_customize ) {
	$wp_customize->add_panel(
		'wavypixel-general-settings', array(
			'title'		=>	__('WavyPixel Options', 'wavypixel'),
			'priority'	=>	20
		)
	);

	// Theme Color Section
	$wp_customize->add_section( 'wavypixel_colors_section', array(
		'title'    => __( 'Theme Color', 'wavypixel' ),
		'priority' => 25,
		'panel'    => 'wavypixel-general-settings', // Associate with the 'wavypixel Options' panel
	) );

	$wp_customize->add_setting( 'wavypixel_theme_color', array(
			'default'	=>	'#fc6239',
			'sanitize_callback'	=>	'sanitize_hex_color'
		)
	);

	$wp_customize->add_control( new WP_Customize_Color_Control(
			$wp_customize, 'wavypixel_theme_color', array(
				'label'		=>	esc_html__('Theme Color', 'wavypixel'),
				'section'	=>	'wavypixel_colors_section',
				'settings'	=>	'wavypixel_theme_color'
			)
		)
	);


// Add a section within the panel for sticky sidebar
	$wp_customize->add_section( 'wavypixel-sticky-sidebar', array(
		'title'    => __( 'Sticky Sidebar', 'wavypixel' ),
		'priority' => 30,
		'panel'    => 'wavypixel-general-settings', // Associate with the 'General Settings' panel
	) );

// Add a setting for sticky sidebar
	$wp_customize->add_setting( 'wavypixel-sticky-sidebar_set', array(
		'default'           => true,
		'sanitize_callback' => 'wavypixel_sanitize_checkbox', 
	) );

// Add a control to set the excerpt length
	$wp_customize->add_control( 'wavypixel-sticky-sidebar_set_ctrl', array(
		'label'    => __( 'Sticky Sidebar', 'wavypixel' ),
		'section'  => 'wavypixel-sticky-sidebar',
		'settings' => 'wavypixel-sticky-sidebar_set',
		'type'     => 'checkbox',
		'priority' => 10,
	) );

	// Add a section within the panel for sticky sidebar
	$wp_customize->add_section( 'wavypixel-disable-readmore', array(
		'title'    => __( 'Read More', 'wavypixel' ),
		'priority' => 30,
		'panel'    => 'wavypixel-general-settings', // Associate with the 'General Settings' panel
	) );

// Add a setting for sticky sidebar
	$wp_customize->add_setting( 'wavypixel-disable-readmore_set', array(
		'default'           => true,
		'sanitize_callback' => 'wavypixel_sanitize_checkbox', 
	) );

// Add a control to set the excerpt length
	$wp_customize->add_control( 'wavypixel-disable-readmore_set_ctrl', array(
		'label'    => __( 'Read More', 'wavypixel' ),
		'section'  => 'wavypixel-disable-readmore',
		'settings' => 'wavypixel-disable-readmore_set',
		'type'     => 'checkbox',
		'description' => 'Check the box to enable "Read More" button on posts',
		'priority' => 10,
	) );

	}
add_action('customize_register', 'wavypixel_options_settings_customize_register');
