<?php
/**
 * Adds Slider_Grid_Widget widget.
 */
class Slider_Grid_Widget extends WP_Widget {

    /**
     * Register widget with WordPress.
     */
    function __construct() {
        parent::__construct(
            'slider_grid_widget', // Base ID
            esc_html__( 'Slider Grid', 'wavypixel' ), // Name
            array( 'description' => esc_html__( 'Displays a slider of posts in a grid layout.', 'wavypixel' ) ) // Args
        );
    }

    /**
     * Front-end display of widget.
     *
     * @see WP_Widget::widget()
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        $title            = ! empty( $instance['title'] ) ? $instance['title'] : '';
        $number_of_posts  = ! empty( $instance['number_of_posts'] ) ? absint( $instance['number_of_posts'] ) : 4;
        $order            = ! empty( $instance['order'] ) ? $instance['order'] : 'random';
        $category         = ! empty( $instance['category'] ) ? $instance['category'] : '';

        $args['before_widget'] = str_replace('class="widget', 'class="widget widget_block', $args['before_widget']);
        echo $args['before_widget'];
        if ( ! empty( $title ) ) {
            echo $args['before_title'] . apply_filters( 'widget_title', $title ) . $args['after_title'];
        }

        $featured_post_args = array(
            'posts_per_page'      => $number_of_posts,
            'ignore_sticky_posts' => 1,
            'order'               => $order,
            'cat'                 => $category,
        );

        $featured_posts = new WP_Query( $featured_post_args );

        if ( $featured_posts->have_posts() ) {
            echo '<div class="swiper-container slider-grid-widget">';
            echo '<div class="swiper-wrapper">'; // Start Swiper wrapper
        
            while ( $featured_posts->have_posts() ) {
                $featured_posts->the_post();
                $link = get_the_permalink();
                $title = get_the_title();
                ?>
                <div class="swiper-slide slider-grid-item md-4"> <!-- Add swiper-slide class -->
                    <div class="slider-grid-thumb">
                        <a href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_attr( $title ); ?>">
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php the_post_thumbnail(); ?>
                            <?php else : ?>
                                <img src="<?php echo esc_url( get_template_directory_uri() . '/images/thumbnail.jpg' ); ?>" alt="<?php echo esc_attr( $title ); ?>">
                            <?php endif; ?>
                        </a>
                    </div>
                    <div class="slider-grid-content">
                        <h4 class="slider-grid-title">
                            <a href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_attr( $title ); ?>">
                                <?php echo esc_html( $title ); ?>
                            </a>
                        </h4>
                        <div class="slider-grid-meta">
                            <?php wavypixel_posted_on(); ?>
                        </div>
                    </div>
                </div>
                <?php
            }
        
            echo '</div><!-- .swiper-wrapper -->'; // End Swiper wrapper
        
            // Add navigation buttons and pagination
            echo '<div class="custom-swiper-next">&rarr;</div>';
            echo '<div class="custom-swiper-prev">&larr;</div>';
            
            echo '<div class="swiper-pagination"></div>';
            echo '</div><!-- .swiper-container -->'; // End Swiper container
        }
        

        wp_reset_postdata();
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $title            = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'New title', 'wavypixel' );
        $number_of_posts  = ! empty( $instance['number_of_posts'] ) ? absint( $instance['number_of_posts'] ) : 4;
        $order            = ! empty( $instance['order'] ) ? $instance['order'] : 'random';
        $category         = ! empty( $instance['category'] ) ? $instance['category'] : '';
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'wavypixel' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'number_of_posts' ) ); ?>"><?php esc_html_e( 'Number of Posts:', 'wavypixel' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number_of_posts' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number_of_posts' ) ); ?>" type="number" min="1" step="1" value="<?php echo esc_attr( $number_of_posts ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'order' ) ); ?>"><?php esc_html_e( 'Post Order:', 'wavypixel' ); ?></label>
            <select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'order' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'order' ) ); ?>">
                <option value="random" <?php selected( $order, 'random' ); ?>><?php esc_html_e( 'Random', 'wavypixel' ); ?></option>
                <option value="date" <?php selected( $order, 'date' ); ?>><?php esc_html_e( 'Date', 'wavypixel' ); ?></option>
            </select>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'category' ) ); ?>"><?php esc_html_e( 'Category:', 'wavypixel' ); ?></label>
            <?php wp_dropdown_categories( array(
                'show_option_none' => esc_html__( 'Select category', 'wavypixel' ),
                'name'             => $this->get_field_name( 'category' ),
                'id'               => $this->get_field_id( 'category' ),
                'selected'         => $category,
                'class'            => 'widefat',
            ) ); ?>
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance                 = array();
        $instance['title']        = ( ! empty( $new_instance['title'] ) ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['number_of_posts'] = ( ! empty( $new_instance['number_of_posts'] ) ) ? absint( $new_instance['number_of_posts'] ) : 4;
        $instance['order']        = ( ! empty( $new_instance['order'] ) ) ? sanitize_text_field( $new_instance['order'] ) : 'random';
        $instance['category']     = ( ! empty( $new_instance['category'] ) ) ? sanitize_text_field( $new_instance['category'] ) : '';

        return $instance;
    }

}

// Register Slider Grid Widget
function register_slider_grid_widget() {
    register_widget( 'Slider_Grid_Widget' );
}
add_action( 'widgets_init', 'register_slider_grid_widget' );
