<?php
/**
 * Displays main header
 *
 * @package Watch Store Shop
 */
?>

<div class="main-header text-center text-md-start">
    <div class="container">
        <div class="row nav-box">
            <div class="col-xl-4 col-lg-2 col-md-4 align-self-center">
                <?php if (get_theme_mod('watch_store_shop_header_sidebar_setting', false) != '') { ?>
                    <div class="bar-icon">
                        <button onclick="watch_store_shop_openSidebar()"><i class="fas fa-bars"></i></button>
                        <div class="header-widgets">
                            <a href="javascript:void(0)" class="closebtn" onclick="watch_store_shop_closeSidebar()"><i class="fas fa-times"></i></a>
                            <div class="sidebar">
                                <?php if( is_active_sidebar('header-sidebar') ) : ?>
                                    <?php dynamic_sidebar( 'header-sidebar' );?>
                                <?php else : ?>
                                    <h4><?php esc_html_e('Add Widgets Here.', 'watch-store-shop'); ?></h4>
                                <?php endif;?>
                            </div>
                        </div>
                    </div>
                <?php }?>
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 logo-box align-self-center">
                <div class="navbar-brand ">
                    <?php if ( has_custom_logo() ) : ?>
                        <div class="site-logo"><?php the_custom_logo(); ?></div>
                    <?php endif; ?>
                    <?php $watch_store_shop_blog_info = get_bloginfo( 'name' ); ?>
                        <?php if ( ! empty( $watch_store_shop_blog_info ) ) : ?>
                            <?php if ( is_front_page() && is_home() ) : ?>
                                <?php if( get_theme_mod('watch_store_shop_logo_title_text',true) != ''){ ?>
                                    <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
                                <?php } ?>
                            <?php else : ?>
                                <?php if( get_theme_mod('watch_store_shop_logo_title_text',true) != ''){ ?>
                                    <p class="site-title "><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
                                <?php } ?>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php
                            $watch_store_shop_description = get_bloginfo( 'description', 'display' );
                            if ( $watch_store_shop_description || is_customize_preview() ) :
                        ?>
                        <?php if( get_theme_mod('watch_store_shop_theme_description',false) != ''){ ?>
                            <p class="site-description pb-2"><?php echo esc_html($watch_store_shop_description); ?></p>
                        <?php } ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-xl-4 col-lg-6 col-md-4 align-self-center">
                <?php get_template_part('template-parts/navigation/nav'); ?>
            </div>
        </div>
    </div>
</div>
