<?php
/**
 * Template Name: Home Template
 */

get_header(); ?>

<main id="skip-content">
  <?php if (get_theme_mod('watch_store_shop_banner_section_setting', false) != '') { ?>
    <section id="top-banner" class="banner-bg">
            <div class="container slider-box">
              <div class="row slide-index">
                <div class="col-xl-4 col-lg-4 col-md-12 align-self-center slide-contentt">
                  <div class="banner-content">
                    <?php if(get_theme_mod('watch_store_shop_banner_content') != ''){ ?>
                      <p><?php echo esc_html(get_theme_mod('watch_store_shop_banner_content')); ?></p>
                    <?php }?>
                  </div>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-6 align-self-center slide-imgg">
                  <?php if(get_theme_mod('watch_store_shop_banner_main_image') != ''){ ?>
                    <div class="icon-img3">
                      <img src="<?php echo esc_url(get_theme_mod('watch_store_shop_banner_main_image')); ?>" alt="" />
                    </div>
                  <?php } else{?>
                    <div class="icon-img3">
                      <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/slider.png" alt="" />
                    </div>
                  <?php } ?>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-6 align-self-center btn-head">
                    <?php if(get_theme_mod('watch_store_shop_banner_heading') != ''){ ?>
                      <div class="banner-head">
                          <h6><?php echo esc_html(get_theme_mod('watch_store_shop_banner_heading')); ?></h6><br>
                      </div>
                    <?php }?>
                    <?php if(get_theme_mod('watch_store_shop_banner_btn_text') != '' || get_theme_mod('watch_store_shop_banner_btn_url') != ''){?>
                      <div class="banner-btn">
                        <a href="<?php echo esc_url(get_theme_mod('watch_store_shop_banner_btn_url')); ?>"><?php echo esc_html(get_theme_mod('watch_store_shop_banner_btn_text')); ?></a>
                      </div>
                    <?php }?>
                </div>
              </div>
            </div>
            <div class="service-box">
              <div class="container">
                <div class="row">
                  <div class="col-lg-4 col-md-4 serv-text">
                    <?php if(get_theme_mod('watch_store_shop_banner_service1') != ''){ ?>
                      <span class="serv-span"><i class="fas fa-check-double me-md-1"></i><p class="mb-0"><?php echo esc_html(get_theme_mod('watch_store_shop_banner_service1')); ?></p></span>
                    <?php }?>
                  </div>
                  <div class="col-lg-4 col-md-4 serv-text text-lg-center">
                    <?php if(get_theme_mod('watch_store_shop_banner_service2') != ''){ ?>
                      <span class="serv-span"><i class="fas fa-credit-card me-md-1"></i><p class="mb-0"><?php echo esc_html(get_theme_mod('watch_store_shop_banner_service2')); ?></p></span>
                    <?php }?>
                  </div>
                  <div class="col-lg-4 col-md-4 serv-text text-lg-end">
                    <?php if(get_theme_mod('watch_store_shop_banner_service3') != ''){ ?>
                      <span class="serv-span"><i class="fas fa-headset me-md-1"></i><p class="mb-0"><?php echo esc_html(get_theme_mod('watch_store_shop_banner_service3')); ?></p></span>
                    <?php }?>
                  </div>
                </div>
              </div>
            </div>
            <div class="icon-1"><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/Icon1.png"></div>
            <div class="icon-2"><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/img/Icon2.png"></div>
    </section>
  <?php }?>

<?php if ( get_theme_mod( 'watch_store_shop_activities_section_setting', false ) != '' ) { ?>
<section class="featured py-5 text-center mt-md-4">
  <div class="container">

    <?php if ( get_theme_mod( 'watch_store_shop_services_sub_heading' ) != '' ) { ?>
      <p class="sub-heading">
        <?php echo esc_html( get_theme_mod( 'watch_store_shop_services_sub_heading' ) ); ?>
      </p>
    <?php } ?>

    <?php if ( get_theme_mod( 'watch_store_shop_services_heading' ) != '' ) { ?>
      <h3 class="main-heading mb-5">
        <?php echo esc_html( get_theme_mod( 'watch_store_shop_services_heading' ) ); ?>
      </h3>
    <?php } ?>
    <div class="one-position">
    <?php if ( get_theme_mod( 'watch_store_shop_services_one_word' ) != '' ) { ?>
      <p class="slide-one">
        <?php echo esc_html( get_theme_mod( 'watch_store_shop_services_one_word' ) ); ?>
      </p>
    <?php } ?>

    <div class="row owl-carousel watch-store-product-carousel">
      <?php if ( class_exists( 'woocommerce' ) ) {
        $args = array(
          'post_type'   => 'product',
          'product_cat' => get_theme_mod( 'watch_store_shop_product_category' ),
          'orderby'     => 'date',
          'order'       => 'DESC',
        );

        // Optional store filter
        if ( isset( $_GET['Productstore'] ) && ! empty( $_GET['Productstore'] ) ) {
          $args['tax_query'] = array(
            array(
              'taxonomy' => 'product_store',
              'field'    => 'slug',
              'terms'    => sanitize_text_field( $_GET['Productstore'] ),
            ),
          );
        }

        $loop = new WP_Query( $args );
        while ( $loop->have_posts() ) :
          $loop->the_post();
          global $product;
        ?>
          <div class="sells-product">
            <div class="mask1">
              <div class="prodimg_box">
                <?php
                if ( has_post_thumbnail( $loop->post->ID ) ) {
                  echo get_the_post_thumbnail( $loop->post->ID, 'shop_catalog' );
                } else {
                  echo '<img src="' . esc_url( wc_placeholder_img_src() ) . '" alt="">';
                }
                ?>
              </div>
              <div class="text_box">
                <h4 class="mb-2">
                  <a href="<?php echo esc_url( get_permalink( $loop->post->ID ) ); ?>">
                    <?php the_title(); ?>
                  </a>
                </h4>
                <!-- Product Short Description -->
                <?php
                $watch_store_shop_short_description = apply_filters(
                  'woocommerce_short_description',
                  $product->get_short_description()
                );
                if ( ! empty( $watch_store_shop_short_description ) ) {
                  echo '<p class="product-short-desc">' .
                    wp_kses_post( wp_trim_words( $watch_store_shop_short_description, 15 ) ) .
                  '</p>';
                }
                ?>
                <p class="<?php echo esc_attr( apply_filters( 'woocommerce_product_price_class', 'price' ) ); ?>">
                  <?php echo $product->get_price_html(); ?>
                </p>

              </div>
            </div>
          </div>
        <?php endwhile; wp_reset_postdata(); ?>
      <?php } ?>
    </div>
    </div>
  </div>
</section>
<?php } ?>
  <section id="page-content">
    <div class="container">
      <div class="spacer">
        <?php
          if ( have_posts() ) :
            while ( have_posts() ) : the_post();
              the_content();
            endwhile;
          endif;
        ?>
      </div>
    </div>
  </section>
</main>

<?php get_footer(); ?>