<?php
/**
 * Watch Store Shop Theme Customizer
 *
 * @link: https://developer.wordpress.org/themes/customize-api/customizer-objects/
 *
 * @package Watch Store Shop
 */

if ( ! function_exists( 'watch_store_shop_file_setup' ) ) :

    function watch_store_shop_file_setup() {

        if ( ! defined( 'WATCH_STORE_SHOP_URL' ) ) {
            define( 'WATCH_STORE_SHOP_URL', esc_url( 'https://www.themagnifico.net/products/watch-store-wordpress-theme', 'watch-store-shop') );
        }
        if ( ! defined( 'WATCH_STORE_SHOP_TEXT' ) ) {
            define( 'WATCH_STORE_SHOP_TEXT', __( 'Watch Store Shop Pro','watch-store-shop' ));
        }
        if ( ! defined( 'WATCH_STORE_SHOP_BUY_TEXT' ) ) {
            define( 'WATCH_STORE_SHOP_BUY_TEXT', __( 'Buy Watch Store Shop Pro','watch-store-shop' ));
        }

    }
endif;
add_action( 'after_setup_theme', 'watch_store_shop_file_setup' );

use WPTRT\Customize\Section\Watch_Store_Shop_Button;

add_action( 'customize_register', function( $manager ) {

    $manager->register_section_type( Watch_Store_Shop_Button::class );

    $manager->add_section(
        new Watch_Store_Shop_Button( $manager, 'watch_store_shop_pro', [
            'title'       => esc_html( WATCH_STORE_SHOP_TEXT,'watch-store-shop' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'watch-store-shop' ),
            'button_url'  => esc_url( WATCH_STORE_SHOP_URL )
        ] )
    );

} );

// Load the JS and CSS.
add_action( 'customize_controls_enqueue_scripts', function() {

    $version = wp_get_theme()->get( 'Version' );

    wp_enqueue_script(
        'watch-store-shop-customize-section-button',
        get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/js/customize-controls.js' ),
        [ 'customize-controls' ],
        $version,
        true
    );

    wp_enqueue_style(
        'watch-store-shop-customize-section-button',
        get_theme_file_uri( 'vendor/wptrt/customize-section-button/public/css/customize-controls.css' ),
        [ 'customize-controls' ],
        $version
    );

} );

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function watch_store_shop_customize_register($wp_customize){

    // Pro Version
    class Watch_Store_Shop_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>For More <strong>'. esc_html( $this->label ) .'</strong>?</span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( WATCH_STORE_SHOP_BUY_TEXT  ,'watch-store-shop' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function watch_store_shop_sanitize_custom_control( $input ) {
        return $input;
    }

    $wp_customize->get_setting('blogname')->transport = 'postMessage';
    $wp_customize->get_setting('blogdescription')->transport = 'postMessage';

    $wp_customize->add_setting('watch_store_shop_logo_title_text', array(
        'default' => true,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_logo_title_text',array(
        'label'          => __( 'Enable Disable Title', 'watch-store-shop' ),
        'section'        => 'title_tagline',
        'settings'       => 'watch_store_shop_logo_title_text',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('watch_store_shop_logo_title_font_size',array(
        'default'   => '',
        'sanitize_callback' => 'watch_store_shop_sanitize_number_absint'
    ));
    $wp_customize->add_control('watch_store_shop_logo_title_font_size',array(
        'label' => esc_html__('Title Font Size','watch-store-shop'),
        'section' => 'title_tagline',
        'type'    => 'number'
    ));

    $wp_customize->add_setting('watch_store_shop_theme_description', array(
        'default' => false,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_theme_description',array(
        'label'          => __( 'Enable Disable Tagline', 'watch-store-shop' ),
        'section'        => 'title_tagline',
        'settings'       => 'watch_store_shop_theme_description',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('watch_store_shop_logo_tagline_font_size',array(
        'default'   => '',
        'sanitize_callback' => 'watch_store_shop_sanitize_number_absint'
    ));
    $wp_customize->add_control('watch_store_shop_logo_tagline_font_size',array(
        'label' => esc_html__('Tagline Font Size','watch-store-shop'),
        'section'   => 'title_tagline',
        'type'      => 'number'
    ));

    //Logo
    $wp_customize->add_setting('watch_store_shop_logo_max_height',array(
        'default'   => '200',
        'sanitize_callback' => 'watch_store_shop_sanitize_number_absint'
    ));
    $wp_customize->add_control('watch_store_shop_logo_max_height',array(
        'label' => esc_html__('Logo Width','watch-store-shop'),
        'section'   => 'title_tagline',
        'type'      => 'number'
    ));

    // Global Color Settings
     $wp_customize->add_section('watch_store_shop_global_color_settings',array(
        'title' => esc_html__('Global Settings','watch-store-shop'),
        'priority'   => 28,
    ));

    $wp_customize->add_setting( 'watch_store_shop_first_color', array(
        'default' => '#DC0521',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'watch_store_shop_first_color', array(
        'label' => __('Select Your First Color', 'watch-store-shop'),
        'description' => __('Change the global color of the theme in one click.', 'watch-store-shop'),
        'section' => 'watch_store_shop_global_color_settings',
        'settings' => 'watch_store_shop_first_color',
    )));

    //Typography option
    $watch_store_shop_font_array = array(
        ''                       => 'No Fonts',
        'Abril Fatface'          => 'Abril Fatface',
        'Acme'                   => 'Acme',
        'Anton'                  => 'Anton',
        'Architects Daughter'    => 'Architects Daughter',
        'Arimo'                  => 'Arimo',
        'Arsenal'                => 'Arsenal',
        'Arvo'                   => 'Arvo',
        'Alegreya'               => 'Alegreya',
        'Alfa Slab One'          => 'Alfa Slab One',
        'Averia Serif Libre'     => 'Averia Serif Libre',
        'Bangers'                => 'Bangers',
        'Boogaloo'               => 'Boogaloo',
        'Bad Script'             => 'Bad Script',
        'Bitter'                 => 'Bitter',
        'Bree Serif'             => 'Bree Serif',
        'BenchNine'              => 'BenchNine',
        'Cabin'                  => 'Cabin',
        'Cardo'                  => 'Cardo',
        'Courgette'              => 'Courgette',
        'Cherry Swash'           => 'Cherry Swash',
        'Cormorant Garamond'     => 'Cormorant Garamond',
        'Crimson Text'           => 'Crimson Text',
        'Cuprum'                 => 'Cuprum',
        'Cookie'                 => 'Cookie',
        'Chewy'                  => 'Chewy',
        'Days One'               => 'Days One',
        'Dosis'                  => 'Dosis',
        'Droid Sans'             => 'Droid Sans',
        'Economica'              => 'Economica',
        'Fredoka One'            => 'Fredoka One',
        'Fjalla One'             => 'Fjalla One',
        'Francois One'           => 'Francois One',
        'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
        'Gloria Hallelujah'      => 'Gloria Hallelujah',
        'Great Vibes'            => 'Great Vibes',
        'Handlee'                => 'Handlee',
        'Hammersmith One'        => 'Hammersmith One',
        'Inconsolata'            => 'Inconsolata',
        'Indie Flower'           => 'Indie Flower',
        'IM Fell English SC'     => 'IM Fell English SC',
        'Julius Sans One'        => 'Julius Sans One',
        'Josefin Slab'           => 'Josefin Slab',
        'Josefin Sans'           => 'Josefin Sans',
        'Kanit'                  => 'Kanit',
        'Lobster'                => 'Lobster',
        'Lato'                   => 'Lato',
        'Lora'                   => 'Lora',
        'Libre Baskerville'      => 'Libre Baskerville',
        'Lobster Two'            => 'Lobster Two',
        'Merriweather'           => 'Merriweather',
        'Monda'                  => 'Monda',
        'Montserrat'             => 'Montserrat',
        'Muli'                   => 'Muli',
        'Marck Script'           => 'Marck Script',
        'Noto Serif'             => 'Noto Serif',
        'Open Sans'              => 'Open Sans',
        'Overpass'               => 'Overpass',
        'Overpass Mono'          => 'Overpass Mono',
        'Oxygen'                 => 'Oxygen',
        'Orbitron'               => 'Orbitron',
        'Patua One'              => 'Patua One',
        'Pacifico'               => 'Pacifico',
        'Padauk'                 => 'Padauk',
        'Playball'               => 'Playball',
        'Playfair Display'       => 'Playfair Display',
        'PT Sans'                => 'PT Sans',
        'Philosopher'            => 'Philosopher',
        'Permanent Marker'       => 'Permanent Marker',
        'Poiret One'             => 'Poiret One',
        'Quicksand'              => 'Quicksand',
        'Quattrocento Sans'      => 'Quattrocento Sans',
        'Raleway'                => 'Raleway',
        'Rubik'                  => 'Rubik',
        'Roboto'                 => 'Roboto',
        'Rokkitt'                => 'Rokkitt',
        'Russo One'              => 'Russo One',
        'Righteous'              => 'Righteous',
        'Slabo'                  => 'Slabo',
        'Source Sans Pro'        => 'Source Sans Pro',
        'Shadows Into Light Two' => 'Shadows Into Light Two',
        'Shadows Into Light'     => 'Shadows Into Light',
        'Sacramento'             => 'Sacramento',
        'Shrikhand'              => 'Shrikhand',
        'Tangerine'              => 'Tangerine',
        'Ubuntu'                 => 'Ubuntu',
        'VT323'                  => 'VT323',
        'Varela Round'           => 'Varela Round',
        'Vampiro One'            => 'Vampiro One',
        'Vollkorn'               => 'Vollkorn',
        'Volkhov'                => 'Volkhov',
        'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
    );

    // Heading Typography
    $wp_customize->add_setting( 'watch_store_shop_heading_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'watch_store_shop_heading_color', array(
        'label' => __('Heading Color', 'watch-store-shop'),
        'section' => 'watch_store_shop_global_color_settings',
        'settings' => 'watch_store_shop_heading_color',
    )));

    $wp_customize->add_setting('watch_store_shop_heading_font_family', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices',
    ));
    $wp_customize->add_control( 'watch_store_shop_heading_font_family', array(
        'section' => 'watch_store_shop_global_color_settings',
        'label'   => __('Heading Fonts', 'watch-store-shop'),
        'type'    => 'select',
        'choices' => $watch_store_shop_font_array,
    ));

    $wp_customize->add_setting('watch_store_shop_heading_font_size',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_heading_font_size',array(
        'label' => esc_html__('Heading Font Size','watch-store-shop'),
        'section' => 'watch_store_shop_global_color_settings',
        'setting' => 'watch_store_shop_heading_font_size',
        'type'  => 'text'
    ));

    // Paragraph Typography
    $wp_customize->add_setting( 'watch_store_shop_paragraph_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'watch_store_shop_paragraph_color', array(
        'label' => __('Paragraph Color', 'watch-store-shop'),
        'section' => 'watch_store_shop_global_color_settings',
        'settings' => 'watch_store_shop_paragraph_color',
    )));

    $wp_customize->add_setting('watch_store_shop_paragraph_font_family', array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices',
    ));
    $wp_customize->add_control( 'watch_store_shop_paragraph_font_family', array(
        'section' => 'watch_store_shop_global_color_settings',
        'label'   => __('Paragraph Fonts', 'watch-store-shop'),
        'type'    => 'select',
        'choices' => $watch_store_shop_font_array,
    ));

    $wp_customize->add_setting('watch_store_shop_paragraph_font_size',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_paragraph_font_size',array(
        'label' => esc_html__('Paragraph Font Size','watch-store-shop'),
        'section' => 'watch_store_shop_global_color_settings',
        'setting' => 'watch_store_shop_paragraph_font_size',
        'type'  => 'text'
    ));

    // Post Layouts Settings
     $wp_customize->add_section('watch_store_shop_post_layouts_settings',array(
        'title' => esc_html__('Post Layouts Settings','watch-store-shop'),
        'priority'   => 30,
    ));

    $wp_customize->add_setting('watch_store_shop_post_layout',array(
        'default' => 'pattern_two_column_right',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices'
    ));
    $wp_customize->add_control(new Watch_Store_Shop_Image_Radio_Control($wp_customize, 'watch_store_shop_post_layout', array(
        'type' => 'select',
        'label' => __('Blog Post Layouts','watch-store-shop'),
        'section' => 'watch_store_shop_post_layouts_settings',
        'choices' => array(
            'pattern_one_column' => esc_url(get_template_directory_uri()).'/assets/img/1column.png',
            'pattern_two_column_right' => esc_url(get_template_directory_uri()).'/assets/img/right-sidebar.png',
            'pattern_two_column_left' => esc_url(get_template_directory_uri()).'/assets/img/left-sidebar.png',
            'pattern_three_column' => esc_url(get_template_directory_uri()).'/assets/img/3column.png',
            'pattern_four_column' => esc_url(get_template_directory_uri()).'/assets/img/4column.png',
            'pattern_grid_post' => esc_url(get_template_directory_uri()).'/assets/img/grid.png',
    ))
    ));

    // General Settings
     $wp_customize->add_section('watch_store_shop_general_settings',array(
        'title' => esc_html__('General Settings','watch-store-shop'),
        'priority'   => 30,
    ));

     $wp_customize->add_setting('watch_store_shop_width_option',array(
        'default' => 'Full Width',
        'transport' => 'refresh',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices'
    ));
    $wp_customize->add_control('watch_store_shop_width_option',array(
        'type' => 'select',
        'section' => 'watch_store_shop_general_settings',
        'choices' => array(
            'Full Width' => __('Full Width','watch-store-shop'),
            'Wide Width' => __('Wide Width','watch-store-shop'),
            'Boxed Width' => __('Boxed Width','watch-store-shop')
        ),
    ) );

    $wp_customize->add_setting('watch_store_shop_nav_menu_text_transform',array(
        'default'=> 'Capitalize',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices'
    ));
    $wp_customize->add_control('watch_store_shop_nav_menu_text_transform',array(
        'type' => 'radio',
        'choices' => array(
            'Uppercase' => __('Uppercase','watch-store-shop'),
            'Capitalize' => __('Capitalize','watch-store-shop'),
            'Lowercase' => __('Lowercase','watch-store-shop'),
        ),
        'section'=> 'watch_store_shop_general_settings',
    ));

    $wp_customize->add_setting('watch_store_shop_preloader_hide', array(
        'default' => 0,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_preloader_hide',array(
        'label'          => __( 'Show Theme Preloader', 'watch-store-shop' ),
        'section'        => 'watch_store_shop_general_settings',
        'settings'       => 'watch_store_shop_preloader_hide',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting( 'watch_store_shop_preloader_bg_color', array(
        'default' => '#dc0521',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'watch_store_shop_preloader_bg_color', array(
        'label' => esc_html__('Preloader Background Color','watch-store-shop'),
        'section' => 'watch_store_shop_general_settings',
        'settings' => 'watch_store_shop_preloader_bg_color'
    )));

    $wp_customize->add_setting( 'watch_store_shop_preloader_dot_1_color', array(
        'default' => '#ffffff',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'watch_store_shop_preloader_dot_1_color', array(
        'label' => esc_html__('Preloader First Dot Color','watch-store-shop'),
        'section' => 'watch_store_shop_general_settings',
        'settings' => 'watch_store_shop_preloader_dot_1_color'
    )));

    $wp_customize->add_setting( 'watch_store_shop_preloader_dot_2_color', array(
        'default' => '#222222',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'watch_store_shop_preloader_dot_2_color', array(
        'label' => esc_html__('Preloader Second Dot Color','watch-store-shop'),
        'section' => 'watch_store_shop_general_settings',
        'settings' => 'watch_store_shop_preloader_dot_2_color'
    )));

    $wp_customize->add_setting('watch_store_shop_scroll_hide', array(
        'default' => true,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_scroll_hide',array(
        'label'          => __( 'Show Theme Scroll To Top', 'watch-store-shop' ),
        'section'        => 'watch_store_shop_general_settings',
        'settings'       => 'watch_store_shop_scroll_hide',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('watch_store_shop_scroll_top_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices'
    ));
    $wp_customize->add_control('watch_store_shop_scroll_top_position',array(
        'type' => 'radio',
        'section' => 'watch_store_shop_general_settings',
        'choices' => array(
            'Right' => __('Right','watch-store-shop'),
            'Left' => __('Left','watch-store-shop'),
            'Center' => __('Center','watch-store-shop')
        ),
    ) );

    $wp_customize->add_setting( 'watch_store_shop_scroll_bg_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'watch_store_shop_scroll_bg_color', array(
        'label' => esc_html__('Scroll Top Background Color','watch-store-shop'),
        'section' => 'watch_store_shop_general_settings',
        'settings' => 'watch_store_shop_scroll_bg_color'
    )));

    $wp_customize->add_setting( 'watch_store_shop_scroll_color', array(
        'default' => '',
        'sanitize_callback' => 'sanitize_hex_color'
    ));
    $wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'watch_store_shop_scroll_color', array(
        'label' => esc_html__('Scroll Top Color','watch-store-shop'),
        'section' => 'watch_store_shop_general_settings',
        'settings' => 'watch_store_shop_scroll_color'
    )));

    $wp_customize->add_setting('watch_store_shop_scroll_font_size',array(
        'default'   => '16',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_scroll_font_size',array(
        'label' => __('Scroll Top Font Size','watch-store-shop'),
        'description' => __('Put in px','watch-store-shop'),
        'section'   => 'watch_store_shop_general_settings',
        'type'      => 'number'
    ));

    $wp_customize->add_setting('watch_store_shop_scroll_border_radius',array(
        'default'   => '0',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_scroll_border_radius',array(
        'label' => __('Scroll Top Border Radius','watch-store-shop'),
        'description' => __('Put in %','watch-store-shop'),
        'section'   => 'watch_store_shop_general_settings',
        'type'      => 'number'
    ));

    // Product Columns
    $wp_customize->add_setting( 'watch_store_shop_products_per_row' , array(
       'default'           => '3',
       'transport'         => 'refresh',
       'sanitize_callback' => 'watch_store_shop_sanitize_select',
    ) );

    $wp_customize->add_control('watch_store_shop_products_per_row', array(
       'label' => __( 'Product per row', 'watch-store-shop' ),
       'section'  => 'watch_store_shop_general_settings',
       'type'     => 'select',
       'choices'  => array(
           '2' => '2',
           '3' => '3',
           '4' => '4',
       ),
    ) );

    $wp_customize->add_setting('watch_store_shop_product_per_page',array(
        'default'   => '9',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_product_per_page',array(
        'label' => __('Product per page','watch-store-shop'),
        'section'   => 'watch_store_shop_general_settings',
        'type'      => 'number'
    ));

    // Product Columns
    $wp_customize->add_setting('custom_related_products_number_per_row',array(
        'default'           => '3',
        'transport'         => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('custom_related_products_number_per_row',array(
        'label'       => esc_html__('Related Products Column Count', 'watch-store-shop'),
        'section'     => 'watch_store_shop_general_settings',
        'type'        => 'number',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 1,
            'max'  => 4,
        ),
    ));

    // Product Columns
    $wp_customize->add_setting('custom_related_products_number',array(
        'default'           => '3',
        'transport'         => 'refresh',
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('custom_related_products_number',array(
        'label'       => esc_html__('Number of Related Products Per Page', 'watch-store-shop'),
        'section'     => 'watch_store_shop_general_settings',
        'type'        => 'number',
        'input_attrs' => array(
            'step' => 1,
            'min'  => 1,
            'max'  => 10,
        ),
    ));

    $wp_customize->add_setting('watch_store_shop_related_product_display_setting', array(
        'default' => true,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_related_product_display_setting',array(
        'label'          => __( 'Show Related Products', 'watch-store-shop' ),
        'section'        => 'watch_store_shop_general_settings',
        'settings'       => 'watch_store_shop_related_product_display_setting',
        'type'           => 'checkbox',
    )));

    //Woocommerce shop page Sidebar
    $wp_customize->add_setting('watch_store_shop_woocommerce_shop_page_sidebar', array(
        'default' => true,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_woocommerce_shop_page_sidebar',array(
        'label'          => __( 'Hide Shop Page Sidebar', 'watch-store-shop' ),
        'section'        => 'watch_store_shop_general_settings',
        'settings'       => 'watch_store_shop_woocommerce_shop_page_sidebar',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('watch_store_shop_shop_page_sidebar_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices'
    ));
    $wp_customize->add_control('watch_store_shop_shop_page_sidebar_layout',array(
        'type' => 'select',
        'label' => __('Woocommerce Shop Page Sidebar','watch-store-shop'),
        'section' => 'watch_store_shop_general_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','watch-store-shop'),
            'Right Sidebar' => __('Right Sidebar','watch-store-shop'),
        ),
    ) );

    //Woocommerce Single Product page Sidebar
    $wp_customize->add_setting('watch_store_shop_woocommerce_single_product_page_sidebar', array(
        'default' => true,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_woocommerce_single_product_page_sidebar',array(
        'label'          => __( 'Hide Single Product Page Sidebar', 'watch-store-shop' ),
        'section'        => 'watch_store_shop_general_settings',
        'settings'       => 'watch_store_shop_woocommerce_single_product_page_sidebar',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('watch_store_shop_single_product_sidebar_layout',array(
        'default' => 'Right Sidebar',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices'
    ));
    $wp_customize->add_control('watch_store_shop_single_product_sidebar_layout',array(
        'type' => 'select',
        'label' => __('Woocommerce Single Product Page Sidebar','watch-store-shop'),
        'section' => 'watch_store_shop_general_settings',
        'choices' => array(
            'Left Sidebar' => __('Left Sidebar','watch-store-shop'),
            'Right Sidebar' => __('Right Sidebar','watch-store-shop'),
        ),
    ) );

    //Top Header
    $wp_customize->add_section('watch_store_shop_top_header',array(
        'title' => esc_html__(' Header Option','watch-store-shop')
    ));

    $wp_customize->add_setting('watch_store_shop_header_sidebar_setting', array(
        'default' => false,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_header_sidebar_setting',array(
        'label'          => __( 'Show Header Sidebar', 'watch-store-shop' ),
        'section'        => 'watch_store_shop_top_header',
        'settings'       => 'watch_store_shop_header_sidebar_setting',
        'type'           => 'checkbox',
    )));


    //Banner
    $wp_customize->add_section('watch_store_shop_top_banner',array(
        'title' => esc_html__('Banner Settings','watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_banner_section_setting', array(
        'default' => false,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_banner_section_setting',array(
        'label'    => __( 'Show Banner', 'watch-store-shop' ),
        'section'  => 'watch_store_shop_top_banner',
        'settings' => 'watch_store_shop_banner_section_setting',
        'type'     => 'checkbox',
    )));

    $wp_customize->add_setting('watch_store_shop_banner_content',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_banner_content',array(
        'label' => esc_html__('Content','watch-store-shop'),
        'section' => 'watch_store_shop_top_banner',
        'setting' => 'watch_store_shop_banner_content',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('watch_store_shop_banner_main_image',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize,'watch_store_shop_banner_main_image',array(
        'label' => __('Banner Image','watch-store-shop'),
        'section' => 'watch_store_shop_top_banner',
        'settings' => 'watch_store_shop_banner_main_image',
    )));

    $wp_customize->add_setting('watch_store_shop_banner_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_banner_heading',array(
        'label' => esc_html__('Banner Heading','watch-store-shop'),
        'section' => 'watch_store_shop_top_banner',
        'setting' => 'watch_store_shop_banner_heading',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('watch_store_shop_banner_btn_text',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_banner_btn_text',array(
        'label' => esc_html__('Banner Button Text','watch-store-shop'),
        'section' => 'watch_store_shop_top_banner',
        'setting' => 'watch_store_shop_banner_btn_text',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('watch_store_shop_banner_btn_url',array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('watch_store_shop_banner_btn_url',array(
        'label' => esc_html__('Banner Button URL','watch-store-shop'),
        'section' => 'watch_store_shop_top_banner',
        'setting' => 'watch_store_shop_banner_btn_url',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('watch_store_shop_banner_service1',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_banner_service1',array(
        'label' => esc_html__('Service Text 1','watch-store-shop'),
        'section' => 'watch_store_shop_top_banner',
        'setting' => 'watch_store_shop_banner_service1',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('watch_store_shop_banner_service2',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_banner_service2',array(
        'label' => esc_html__('Service Text 2','watch-store-shop'),
        'section' => 'watch_store_shop_top_banner',
        'setting' => 'watch_store_shop_banner_service2',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('watch_store_shop_banner_service3',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_banner_service3',array(
        'label' => esc_html__('Service Text 3','watch-store-shop'),
        'section' => 'watch_store_shop_top_banner',
        'setting' => 'watch_store_shop_banner_service3',
        'type'  => 'text'
    ));


    // Products
    $wp_customize->add_section('watch_store_shop_services_section',array(
        'title' => esc_html__('Products Section','watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_activities_section_setting', array(
        'default' => false,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'watch_store_shop_activities_section_setting',array(
        'label'          => __( 'Show Products', 'watch-store-shop' ),
        'section'        => 'watch_store_shop_services_section',
        'settings'       => 'watch_store_shop_activities_section_setting',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting('watch_store_shop_services_sub_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_services_sub_heading',array(
        'label' => esc_html__('Sub Heading','watch-store-shop'),
        'section' => 'watch_store_shop_services_section',
        'setting' => 'watch_store_shop_services_sub_heading',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('watch_store_shop_services_heading',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_services_heading',array(
        'label' => esc_html__('Heading','watch-store-shop'),
        'section' => 'watch_store_shop_services_section',
        'setting' => 'watch_store_shop_services_heading',
        'type'  => 'text'
    ));

    $wp_customize->add_setting('watch_store_shop_services_one_word',array(
        'default' => '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('watch_store_shop_services_one_word',array(
        'label' => esc_html__('Background One Word','watch-store-shop'),
        'section' => 'watch_store_shop_services_section',
        'setting' => 'watch_store_shop_services_one_word',
        'type'  => 'text'
    ));
    
    $args = array(
       'type'                     => 'product',
        'child_of'                 => 0,
        'parent'                   => '',
        'orderby'                  => 'term_group',
        'order'                    => 'ASC',
        'hide_empty'               => false,
        'hierarchical'             => 1,
        'number'                   => '',
        'taxonomy'                 => 'product_cat',
        'pad_counts'               => false
    );
    $categories = get_categories($args);
    $cat_posts = array();
    $m = 0;
    $cat_posts[]='Select';
    foreach($categories as $product){
        if($m==0){
          $default = $product->slug;
          $m++;
        }
        $cat_posts[$product->slug] = $product->name;
    }

    $wp_customize->add_setting('watch_store_shop_product_category',array(
        'default' => 'select',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices',
    ));

    $wp_customize->add_control('watch_store_shop_product_category',array(
        'type'    => 'select',
        'choices' => $cat_posts,
        'label' => __('Select category to display products ','watch-store-shop'),
        'section' => 'watch_store_shop_services_section',
    ));


    // Post Settings
     $wp_customize->add_section('watch_store_shop_post_settings',array(
        'title' => esc_html__('Post Settings','watch-store-shop'),
        'priority'   =>40,
    ));

    $wp_customize->add_setting('watch_store_shop_post_page_title',array(
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('watch_store_shop_post_page_title',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Title', 'watch-store-shop'),
        'section'     => 'watch_store_shop_post_settings',
        'description' => esc_html__('Check this box to enable title on post page.', 'watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_post_page_meta',array(
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('watch_store_shop_post_page_meta',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Meta', 'watch-store-shop'),
        'section'     => 'watch_store_shop_post_settings',
        'description' => esc_html__('Check this box to enable meta on post page.', 'watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_post_page_thumb',array(
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('watch_store_shop_post_page_thumb',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Thumbnail', 'watch-store-shop'),
        'section'     => 'watch_store_shop_post_settings',
        'description' => esc_html__('Check this box to enable thumbnail on post page.', 'watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_post_page_content',array(
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('watch_store_shop_post_page_content',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Content', 'watch-store-shop'),
        'section'     => 'watch_store_shop_post_settings',
        'description' => esc_html__('Check this box to enable content on post page.', 'watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_post_page_excerpt_length',array(
        'sanitize_callback' => 'watch_store_shop_sanitize_number_range',
        'default'           => 30,
    ));
    $wp_customize->add_control('watch_store_shop_post_page_excerpt_length',array(
        'label'       => esc_html__('Post Page Excerpt Length', 'watch-store-shop'),
        'section'     => 'watch_store_shop_post_settings',
        'type'        => 'range',
        'input_attrs' => array(
            'step'             => 1,
            'min'              => 1,
            'max'              => 50,
        ),
    ));

    $wp_customize->add_setting('watch_store_shop_post_page_excerpt_suffix',array(
        'sanitize_callback' => 'sanitize_text_field',
        'default'           => '[...]',
    ));
    $wp_customize->add_control('watch_store_shop_post_page_excerpt_suffix',array(
        'type'        => 'text',
        'label'       => esc_html__('Post Page Excerpt Suffix', 'watch-store-shop'),
        'section'     => 'watch_store_shop_post_settings',
        'description' => esc_html__('For Ex. [...], etc', 'watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_post_page_pagination',array(
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('watch_store_shop_post_page_pagination',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Post Page Pagination', 'watch-store-shop'),
        'section'     => 'watch_store_shop_post_settings',
        'description' => esc_html__('Check this box to enable pagination on post page.', 'watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_single_post_page_content',array(
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox',
        'default'           => 1,
    ));
    $wp_customize->add_control('watch_store_shop_single_post_page_content',array(
        'type'        => 'checkbox',
        'label'       => esc_html__('Enable Single Post Page Content', 'watch-store-shop'),
        'section'     => 'watch_store_shop_post_settings',
        'description' => esc_html__('Check this box to enable content on single post page.', 'watch-store-shop'),
    ));
    
    // Footer
    $wp_customize->add_section('watch_store_shop_site_footer_section', array(
        'title' => esc_html__('Footer', 'watch-store-shop'),
    ));

    $wp_customize->add_setting('watch_store_shop_footer_widget_content_alignment',array(
        'default' => 'Left',
        'transport' => 'refresh',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices'
    ));
    $wp_customize->add_control('watch_store_shop_footer_widget_content_alignment',array(
        'type' => 'select',
        'label' => __('Footer Widget Content Alignment','watch-store-shop'),
        'section' => 'watch_store_shop_site_footer_section',
        'choices' => array(
            'Left' => __('Left','watch-store-shop'),
            'Center' => __('Center','watch-store-shop'),
            'Right' => __('Right','watch-store-shop')
        ),
    ) );

    $wp_customize->add_setting('watch_store_shop_show_hide_copyright',array(
        'default' => true,
        'sanitize_callback' => 'watch_store_shop_sanitize_checkbox'
    ));
    $wp_customize->add_control('watch_store_shop_show_hide_copyright',array(
        'type' => 'checkbox',
        'label' => __('Show / Hide Copyright','watch-store-shop'),
        'section' => 'watch_store_shop_site_footer_section',
    ));

    $wp_customize->add_setting('watch_store_shop_footer_text_setting', array(
        'sanitize_callback' => 'sanitize_text_field',
    ));
    $wp_customize->add_control('watch_store_shop_footer_text_setting', array(
        'label' => __('Replace the footer text', 'watch-store-shop'),
        'section' => 'watch_store_shop_site_footer_section',
        'type' => 'text',
    ));

    $wp_customize->add_setting('watch_store_shop_copyright_content_alignment',array(
        'default' => 'Center',
        'transport' => 'refresh',
        'sanitize_callback' => 'watch_store_shop_sanitize_choices'
    ));
    $wp_customize->add_control('watch_store_shop_copyright_content_alignment',array(
        'type' => 'select',
        'label' => __('Copyright Content Alignment','watch-store-shop'),
        'section' => 'watch_store_shop_site_footer_section',
        'choices' => array(
            'Left' => __('Left','watch-store-shop'),
            'Center' => __('Center','watch-store-shop'),
            'Right' => __('Right','watch-store-shop')
        ),
    ) );

    // Pro Version
    $wp_customize->add_setting( 'pro_version_footer_setting', array(
        'sanitize_callback' => 'watch_store_shop_sanitize_custom_control'
    ));
    $wp_customize->add_control( new Watch_Store_Shop_Customize_Pro_Version ( $wp_customize,'pro_version_footer_setting', array(
        'section'     => 'watch_store_shop_site_footer_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Customizer Options', 'watch-store-shop' ),
        'description' => esc_url( WATCH_STORE_SHOP_URL ),
        'priority'    => 100
    )));
}
add_action('customize_register', 'watch_store_shop_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function watch_store_shop_customize_partial_blogname(){
    bloginfo('name');
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function watch_store_shop_customize_partial_blogdescription(){
    bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function watch_store_shop_customize_preview_js(){
    wp_enqueue_script('watch-store-shop-customizer', esc_url(get_template_directory_uri()) . '/assets/js/customizer.js', array('customize-preview'), '20151215', true);
}
add_action('customize_preview_init', 'watch_store_shop_customize_preview_js');

/*
** Load dynamic logic for the customizer controls area.
*/
function watch_store_shop_panels_js() {
    wp_enqueue_style( 'watch-store-shop-customizer-layout-css', get_theme_file_uri( '/assets/css/customizer-layout.css' ) );
    wp_enqueue_script( 'watch-store-shop-customize-layout', get_theme_file_uri( '/assets/js/customize-layout.js' ), array(), '1.2', true );
}
add_action( 'customize_controls_enqueue_scripts', 'watch_store_shop_panels_js' );