<?php
/**
 * Watch Store Shop functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Watch Store Shop
 */

include get_theme_file_path( 'vendor/wptrt/autoload/src/Watch_Store_Shop_Loader.php' );

$Watch_Store_Shop_Loader = new \WPTRT\Autoload\Watch_Store_Shop_Loader();

$Watch_Store_Shop_Loader->watch_store_shop_add( 'WPTRT\\Customize\\Section', get_theme_file_path( 'vendor/wptrt/customize-section-button/src' ) );

$Watch_Store_Shop_Loader->watch_store_shop_register();

if ( ! function_exists( 'watch_store_shop_setup' ) ) :

	function watch_store_shop_setup() {

		/*
		 * Enable support for Post Formats.
		 *
		 * See: https://codex.wordpress.org/Post_Formats
		*/
		add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

		load_theme_textdomain( 'watch-store-shop', get_template_directory() . '/languages' );
		add_theme_support( 'woocommerce' );
		add_theme_support( "responsive-embeds" );
		add_theme_support( "align-wide" );
		add_theme_support( "wp-block-styles" );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
        add_image_size('watch-store-shop-featured-header-image', 2000, 660, true);

        register_nav_menus( array(
            'primary' => esc_html__( 'Primary','watch-store-shop' ),
        ) );

		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		add_theme_support( 'custom-background', apply_filters( 'watch_store_shop_custom_background_args', array(
			'default-color' => 'f7ebe5',
			'default-image' => '',
		) ) );

		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support( 'custom-logo', array(
			'height'      => 200,
			'width'       => 200,
			'flex-width'  => true,
		) );

		add_editor_style( array( '/editor-style.css' ) );
		add_action('wp_ajax_watch_store_shop_dismissable_notice', 'watch_store_shop_dismissable_notice');
		add_action( 'wp_ajax_tm-check-plugin-exists', 'tm_check_plugin_exists' );
		add_action( 'wp_ajax_tm_install_and_activate_plugin', 'tm_install_and_activate_plugin' );
	}
endif;
add_action( 'after_setup_theme', 'watch_store_shop_setup' );

function watch_store_shop_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'watch_store_shop_content_width', 1170 );
}
add_action( 'after_setup_theme', 'watch_store_shop_content_width', 0 );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function watch_store_shop_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'watch-store-shop' ),
		'id'            => 'sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'watch-store-shop' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar 1', 'watch-store-shop' ),
		'id'            => 'sidebar1',
		'description'   => esc_html__( 'Add widgets here.', 'watch-store-shop' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar 2', 'watch-store-shop' ),
		'id'            => 'sidebar2',
		'description'   => esc_html__( 'Add widgets here.', 'watch-store-shop' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Header Sidebar', 'watch-store-shop' ),
		'id'            => 'header-sidebar',
		'description'   => esc_html__( 'Add widgets here which can be seen on topbar toggle sidebar.', 'watch-store-shop' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 1', 'watch-store-shop' ),
		'id'            => 'watch-store-shop-footer1',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="footer-column-widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 2', 'watch-store-shop' ),
		'id'            => 'watch-store-shop-footer2',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="footer-column-widget-title">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 3', 'watch-store-shop' ),
		'id'            => 'watch-store-shop-footer3',
		'description'   => '',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5 class="footer-column-widget-title">',
		'after_title'   => '</h5>',
	) );
}
add_action( 'widgets_init', 'watch_store_shop_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function watch_store_shop_scripts() {

	wp_enqueue_style(
		'instrument-sans',
		watch_store_shop_wptt_get_webfont_url('https://fonts.googleapis.com/css2?family=Instrument+Sans:ital,wght@0,400..700;1,400..700&display=swap'),  //  font-family: "Instrument Sans", sans-serif;
		array(),
		'1.0'
	);

	wp_enqueue_style( 'watch-store-shop-block-editor-style', get_theme_file_uri('/assets/css/block-editor-style.css') );

	// load bootstrap css
    wp_enqueue_style( 'bootstrap-css', get_template_directory_uri() . '/assets/css/bootstrap.css');

	wp_enqueue_style( 'owl.carousel-css', get_template_directory_uri() . '/assets/css/owl.carousel.css');

	wp_enqueue_style( 'watch-store-shop-style', get_stylesheet_uri() );
	require get_parent_theme_file_path( '/custom-option.php' );
	wp_add_inline_style( 'watch-store-shop-style',$watch_store_shop_theme_css );

	// fontawesome
	wp_enqueue_style( 'fontawesome-style', get_template_directory_uri() .'/assets/css/fontawesome/css/all.css' );

    wp_enqueue_script('watch-store-shop-theme-js', get_template_directory_uri() . '/assets/js/theme-script.js', array('jquery'), '', true );

	wp_enqueue_script('owl.carousel-js', get_template_directory_uri() . '/assets/js/owl.carousel.js', array('jquery'), '', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'watch_store_shop_scripts' );

function tm_install_and_activate_plugin() {

	$post_plugin_details = $_POST['plugin_details'];
	$plugin_text_domain = $post_plugin_details['plugin_text_domain'];
	$plugin_main_file		=	$post_plugin_details['plugin_main_file'];
	$plugin_url					=	$post_plugin_details['plugin_url'];

	$plugin = array(
		'text_domain'	=> $plugin_text_domain,
		'path' 				=> $plugin_url,
		'install' 		=> $plugin_text_domain . '/' . $plugin_main_file
	);

	wp_cache_flush();

	$plugin_path = plugin_basename( trim( $plugin['install'] ) );


	$activate_plugin = activate_plugin( $plugin_path );

	if($activate_plugin) {

		echo $activate_plugin;

	} else {
		echo $activate_plugin;
	}

	$msg = 'installed';

	$response = array( 'status' => true, 'msg' => $msg );
	wp_send_json( $response );
	exit;
}

function tm_check_plugin_exists() {
		$plugin_text_domain = $_POST['plugin_text_domain'];
		$main_plugin_file 	= $_POST['main_plugin_file'];
		$plugin_path = $plugin_text_domain . '/' . $main_plugin_file;

		$get_plugins					= get_plugins();
		$is_plugin_installed	= false;
		$activation_status 		= false;
		if ( isset( $get_plugins[$plugin_path] ) ) {
		$is_plugin_installed = true;

		$activation_status = is_plugin_active( $plugin_path );
		}
		wp_send_json_success(
		array(
		'install_status'  =>	$is_plugin_installed,
			'active_status'		=>	$activation_status,
			'plugin_path'			=>	$plugin_path,
			'plugin_slug'			=>	$plugin_text_domain
		)
		);
}

function watch_store_shop_files_setup() {

	define( 'FREE_MNSSP_API_URL', 'https://license.themagnifico.net/api/general/' );

	if ( ! defined( 'WATCH_STORE_SHOP_CONTACT_SUPPORT' ) ) {
		define('WATCH_STORE_SHOP_CONTACT_SUPPORT',__('https://wordpress.org/support/theme/watch-store-shop/','watch-store-shop'));
	}
	if ( ! defined( 'WATCH_STORE_SHOP_REVIEW' ) ) {
		define('WATCH_STORE_SHOP_REVIEW',__('https://wordpress.org/support/theme/watch-store-shop/reviews/','watch-store-shop'));
	}
	if ( ! defined( 'WATCH_STORE_SHOP_LIVE_DEMO' ) ) {
		define('WATCH_STORE_SHOP_LIVE_DEMO',__('https://demo.themagnifico.net/watch-store-shop/','watch-store-shop'));
	}
	if ( ! defined( 'WATCH_STORE_SHOP_GET_PREMIUM_PRO' ) ) {
		define('WATCH_STORE_SHOP_GET_PREMIUM_PRO',__('https://www.themagnifico.net/products/watch-store-wordpress-theme','watch-store-shop'));
	}
	if ( ! defined( 'WATCH_STORE_SHOP_PRO_DOC' ) ) {
		define('WATCH_STORE_SHOP_PRO_DOC',__('https://demo.themagnifico.net/eard/wathiqa/watch-store-shop-pro-doc/','watch-store-shop'));
	}
	if ( ! defined( 'WATCH_STORE_SHOP_FREE_DOC' ) ) {
		define('WATCH_STORE_SHOP_FREE_DOC',__('https://demo.themagnifico.net/eard/wathiqa/watch-store-shop-free-doc/','watch-store-shop'));
	}
	if ( ! defined( 'WATCH_STORE_SHOP_BUNDLE_LINK' ) ) {
		define('WATCH_STORE_SHOP_BUNDLE_LINK',__('https://www.themagnifico.net/products/wordpress-theme-bundle','watch-store-shop'));
	}

}

add_action( 'after_setup_theme', 'watch_store_shop_files_setup' );

/**
 * Enqueue Preloader.
 */
function watch_store_shop_preloader() {

  $watch_store_shop_theme_color_css = '';
  $watch_store_shop_preloader_bg_color = get_theme_mod('watch_store_shop_preloader_bg_color');
  $watch_store_shop_preloader_dot_1_color = get_theme_mod('watch_store_shop_preloader_dot_1_color');
  $watch_store_shop_preloader_dot_2_color = get_theme_mod('watch_store_shop_preloader_dot_2_color');
  $watch_store_shop_preloader2_dot_color = get_theme_mod('watch_store_shop_preloader2_dot_color');
  $watch_store_shop_logo_max_height = get_theme_mod('watch_store_shop_logo_max_height');
  $watch_store_shop_scroll_bg_color = get_theme_mod('watch_store_shop_scroll_bg_color');
  $watch_store_shop_scroll_color = get_theme_mod('watch_store_shop_scroll_color');
  $watch_store_shop_scroll_font_size = get_theme_mod('watch_store_shop_scroll_font_size');
  $watch_store_shop_scroll_border_radius = get_theme_mod('watch_store_shop_scroll_border_radius');
  $watch_store_shop_related_product_display_setting = get_theme_mod('watch_store_shop_related_product_display_setting', true);

  	if(get_theme_mod('watch_store_shop_logo_max_height') == '') {
		$watch_store_shop_logo_max_height = '200';
	}

	if(get_theme_mod('watch_store_shop_preloader_bg_color') == '') {
		$watch_store_shop_preloader_bg_color = '#1CB098';
	}
	if(get_theme_mod('watch_store_shop_preloader_dot_1_color') == '') {
		$watch_store_shop_preloader_dot_1_color = '#ffffff';
	}
	if(get_theme_mod('watch_store_shop_preloader_dot_2_color') == '') {
		$watch_store_shop_preloader_dot_2_color = '#222222';
	}

	// Start CSS build
	$watch_store_shop_theme_color_css = '';

	
	if (!$watch_store_shop_related_product_display_setting) {
	    $watch_store_shop_theme_color_css .= '
	        .related.products,
	        .related h2 {
	            display: none !important;
	        }
	    ';
	}

	$watch_store_shop_theme_color_css .= '
		.custom-logo-link img{
			max-height: '.esc_attr($watch_store_shop_logo_max_height).'px;
	 	}
		.loading{
			background-color: '.esc_attr($watch_store_shop_preloader_bg_color).';
		 }
		 @keyframes loading {
		  0%,
		  100% {
		  	transform: translatey(-2.5rem);
		    background-color: '.esc_attr($watch_store_shop_preloader_dot_1_color).';
		  }
		  50% {
		  	transform: translatey(2.5rem);
		    background-color: '.esc_attr($watch_store_shop_preloader_dot_2_color).';
		  }
		}
		.load hr {
			background-color: '.esc_attr($watch_store_shop_preloader2_dot_color).';
		}
		a#button{
			background-color: '.esc_attr($watch_store_shop_scroll_bg_color).';
			color: '.esc_attr($watch_store_shop_scroll_color).' !important;
			font-size: '.esc_attr($watch_store_shop_scroll_font_size).'px;
			border-radius: '.esc_attr($watch_store_shop_scroll_border_radius).'%;
		}
	';
    wp_add_inline_style( 'watch-store-shop-style',$watch_store_shop_theme_color_css );

}
add_action( 'wp_enqueue_scripts', 'watch_store_shop_preloader' );

function watch_store_shop_sanitize_select( $input, $setting ){
    $input = sanitize_key($input);
    $choices = $setting->manager->get_control( $setting->id )->choices;
    return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
}

function watch_store_shop_sanitize_checkbox( $input ) {
  // Boolean check
  return ( ( isset( $input ) && true == $input ) ? true : false );
}

/*radio button sanitization*/
function watch_store_shop_sanitize_choices( $input, $setting ) {
    global $wp_customize;
    $control = $wp_customize->get_control( $setting->id );
    if ( array_key_exists( $input, $control->choices ) ) {
        return $input;
    } else {
        return $setting->default;
    }
}

function watch_store_shop_sanitize_number_range( $number, $setting ) {
	
	// Ensure input is an absolute integer.
	$number = absint( $number );
	
	// Get the input attributes associated with the setting.
	$atts = $setting->manager->get_control( $setting->id )->input_attrs;
	
	// Get minimum number in the range.
	$min = ( isset( $atts['min'] ) ? $atts['min'] : $number );
	
	// Get maximum number in the range.
	$max = ( isset( $atts['max'] ) ? $atts['max'] : $number );
	
	// Get step.
	$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );
	
	// If the number is within the valid range, return it; otherwise, return the default
	return ( $min <= $number && $number <= $max && is_int( $number / $step ) ? $number : $setting->default );
}

function watch_store_shop_sanitize_number_absint( $number, $setting ) {
	// Ensure $number is an absolute integer (whole number, zero or greater).
	$number = absint( $number );

	// If the input is an absolute integer, return it; otherwise, return the default
	return ( $number ? $number : $setting->default );
}

// Change number or products per row to 3
add_filter('loop_shop_columns', 'watch_store_shop_loop_columns');
if (!function_exists('watch_store_shop_loop_columns')) {
	function watch_store_shop_loop_columns() {
		$columns = get_theme_mod( 'watch_store_shop_products_per_row', 3 );
		return $columns; // 3 products per row
	}
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'watch_store_shop_shop_per_page', 9 );
function watch_store_shop_shop_per_page( $cols ) {
  	$cols = get_theme_mod( 'watch_store_shop_product_per_page', 9 );
	return $cols;
}

// Filter to change the number of related products displayed
add_filter( 'woocommerce_output_related_products_args', 'watch_store_shop_products_args' );
function watch_store_shop_products_args( $args ) {
    $args['posts_per_page'] = get_theme_mod( 'custom_related_products_number', 6 );
    $args['columns'] = get_theme_mod( 'custom_related_products_number_per_row', 3 );
    return $args;
}

function watch_store_shop_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'pro_version_footer_setting' );
    $wp_customize->remove_control( 'pro_version_footer_setting' );

}
add_action( 'customize_register', 'watch_store_shop_remove_customize_register', 11 );

if ( class_exists( 'WP_Customize_Control' ) ) {
	// Image Toggle Radio Buttpon
	class Watch_Store_Shop_Image_Radio_Control extends WP_Customize_Control {

	    public function render_content() {
	 
	        if (empty($this->choices))
	            return;
	 
	        $name = '_customize-radio-' . $this->id;
	        ?>
	        <span class="customize-control-title"><?php echo esc_html($this->label); ?></span>
	        <ul class="controls" id='watch-store-shop-img-container'>
	            <?php
	            foreach ($this->choices as $value => $label) :
	                $class = ($this->value() == $value) ? 'watch-store-shop-radio-img-selected watch-store-shop-radio-img-img' : 'watch-store-shop-radio-img-img';
	                ?>
	                <li style="display: inline;">
	                    <label>
	                        <input <?php $this->link(); ?>style = 'display:none' type="radio" value="<?php echo esc_attr($value); ?>" name="<?php echo esc_attr($name); ?>" <?php
	                          	$this->link();
	                          	checked($this->value(), $value);
	                          	?> />
	                        <img src='<?php echo esc_url($label); ?>' class='<?php echo esc_attr($class); ?>' />
	                    </label>
	                </li>
	                <?php
	            endforeach;
	            ?>
	        </ul>
	        <?php
	    } 
	}
}


require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Menu
 */

require get_template_directory() . '/inc/class-navigation-menu.php';

/**
 * TGM
 */

require get_template_directory() . '/inc/tgm.php';


// add_action( 'watch_store_shop_navigation_action','watch_store_shop_single_post_navigation',30 );
if( !function_exists('watch_store_shop_content_offcanvas') ):

    // Offcanvas Contents
    function watch_store_shop_content_offcanvas(){ ?>

        <div id="offcanvas-menu">
            <div class="offcanvas-wraper">
                <div class="close-offcanvas-menu">
                    <div class="offcanvas-close">
                        <a href="javascript:void(0)" class="skip-link-menu-start"></a>
                        <button type="button" class="button-offcanvas-close">
                            <span class="offcanvas-close-label">
                                <i class="fas fa-times"></i>
                            </span>
                        </button>
                    </div>
                </div>
                <div id="primary-nav-offcanvas" class="offcanvas-item offcanvas-main-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'watch-store-shop'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('primary')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'primary',
                                        'show_toggles' => true,
                                    )
                                );
                            }else{

                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'show_toggles' => true,
                                        'walker' => new watch_store_shop_Menu_Page(),
                                    )
                                );
                            }
                            ?>
                        </ul>
                    </nav><!-- .primary-menu-wrapper -->
                </div>
                <a href="javascript:void(0)" class="skip-link-menu-end"></a>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'watch_store_shop_before_footer_content_action','watch_store_shop_content_offcanvas',30 );


if ( ! function_exists( 'watch_store_shop_sub_menu_toggle_button' ) ) :

    function watch_store_shop_sub_menu_toggle_button( $args, $item, $depth ) {

        // Add sub menu toggles to the main menu with toggles
        if ( $args->theme_location == 'primary' && isset( $args->show_toggles ) ) {
            
            // Wrap the menu item link contents in a div, used for positioning
            $args->before = '<div class="submenu-wrapper">';
            $args->after  = '';

            // Add a toggle to items with children
            if ( in_array( 'menu-item-has-children', $item->classes ) ) {

                $toggle_target_string = '.menu-item.menu-item-' . $item->ID . ' > .sub-menu';

                // Add the sub menu toggle with Font Awesome icon
                $args->after .= '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . esc_attr( $toggle_target_string ) . '" data-toggle-type="slidetoggle" data-toggle-duration="250" aria-expanded="false"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . esc_html__( 'Show sub menu', 'watch-store-shop' ) . '</span><i class="fas fa-chevron-down"></i></span></button>';

            }

            // Close the wrapper
            $args->after .= '</div><!-- .submenu-wrapper -->';

        } elseif ( $args->theme_location == 'primary' ) {

            if ( in_array( 'menu-item-has-children', $item->classes ) ) {

                $args->before = '<div class="link-icon-wrapper">';
                $args->after  = '<i class="fas fa-chevron-down"></i></div>';

            } else {

                $args->before = '';
                $args->after  = '';

            }

        }

        return $args;

    }

endif;

add_filter( 'nav_menu_item_args', 'watch_store_shop_sub_menu_toggle_button', 10, 3 );

/**
 * Get CSS
 */

function watch_store_shop_getpage_css($hook) {
	wp_register_script( 'admin-notice-script', get_template_directory_uri() . '/inc/admin/js/admin-notice-script.js', array( 'jquery' ) );
    wp_localize_script('admin-notice-script','watch_store_shop',
		array('admin_ajax'	=>	admin_url('admin-ajax.php'),'wpnonce'  =>	wp_create_nonce('watch_store_shop_dismissed_notice_nonce')
		)
	);
	wp_enqueue_script('admin-notice-script');

    wp_localize_script( 'admin-notice-script', 'watch_store_shop_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
	if ( 'appearance_page_watch_store_shop-info' != $hook ) {
		return;
	}
	
}
add_action( 'admin_enqueue_scripts', 'watch_store_shop_getpage_css' );

//Admin Notice For Getstart
function watch_store_shop_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function watch_store_shop_deprecated_hook_admin_notice() {

     // Check if the notice has been dismissed by the user
    $dismissed = get_user_meta(get_current_user_id(), 'watch_store_shop_dismissable_notice', true);

    // Exclude the notice from being shown on the "Theme Importer" page
    $current_screen = get_current_screen();
    if ($current_screen && $current_screen->id === 'appearance_page_theme-importer') {
        return; // Don't show the notice on this page
    }

    if (!$dismissed) {  
    	?>
        <div class="updated notice notice-success is-dismissible notice-get-started-class" data-notice="get_started" style="background: #f7f9f9; padding: 20px 10px; display: flex;">
	    	<div class="tm-admin-image">
	    		<img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;border: 2px solid #ddd;border-radius: 4px;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
	    	</div>
	    	<div class="tm-admin-content" style="padding-left: 30px; align-self: center">
	    		<h2 style="font-weight: 600;line-height: 1.3; margin: 0px;"><?php esc_html_e('Thank You For Choosing ', 'watch-store-shop'); ?><?php echo wp_get_theme(); ?><h2>
	    		<p style="color: #3c434a; font-weight: 400; margin-bottom: 30px;"><?php _e('Get Started With Theme By Clicking On Getting Started.', 'watch-store-shop'); ?><p>
	    		<a class="admin-notice-btn button button-primary button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=watch-store-shop-info.php' )); ?>"><?php esc_html_e( 'Get started', 'watch-store-shop' ) ?></a>
	        	<a class="admin-notice-btn button button-primary button-hero notice-pro-btn" target="_blank" href="<?php echo esc_url( WATCH_STORE_SHOP_GET_PREMIUM_PRO ); ?>"><?php esc_html_e( 'Get Premium ', 'watch-store-shop' ) ?></a>
	        	<a class="admin-notice-btn button button-primary button-hero notice-bundle-btn" target="_blank" href="<?php echo esc_url( WATCH_STORE_SHOP_BUNDLE_LINK ); ?>"><?php esc_html_e( 'Buy All Themes - 120+ Templates', 'watch-store-shop' ) ?></a>
	        	<span style="padding-top: 15px; display: inline-block; padding-left: 8px;">
	        	<span class="dashicons dashicons-admin-links"></span>
	        	<a class="admin-notice-btn"	 target="_blank" href="<?php echo esc_url( WATCH_STORE_SHOP_LIVE_DEMO ); ?>"><?php esc_html_e( 'View Demo', 'watch-store-shop' ) ?></a>
	        	</span>
	    	</div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'watch_store_shop_deprecated_hook_admin_notice' );

function watch_store_shop_switch_theme() {
    delete_user_meta(get_current_user_id(), 'watch_store_shop_dismissable_notice');
}
add_action('after_switch_theme', 'watch_store_shop_switch_theme');
function watch_store_shop_dismissable_notice() {
    update_user_meta(get_current_user_id(), 'watch_store_shop_dismissable_notice', true);
    die();
}

// Demo Content Code

// Ensure WordPress is loaded
if (!defined('ABSPATH')) {
    exit;
}

// Add the AJAX action to trigger theme mods import
add_action('wp_ajax_import_theme_mods', 'watch_store_shop_demo_importer_ajax_handler');

// Handle the AJAX request
function watch_store_shop_demo_importer_ajax_handler() {
    // Sample data to import
    $theme_mods_data = array(
        'header_textcolor' => '000000',  // Example: change header text color
        'background_color' => 'ffffff',  // Example: change background color
        'custom_logo'      => 123,       // Example: set a custom logo by attachment ID
        'footer_text'      => 'Custom Footer Text', // Example: custom footer text
    );

    // Call the function to import theme mods
    if (watch_store_shop_demo_theme_importer($theme_mods_data)) {
        // After importing theme mods, create the menu
        watch_store_shop_create_demo_menu();
        wp_send_json_success(array(
        	'msg' => 'Theme mods imported successfully.',
        	'redirect' => home_url()
        ));
    } else {
        wp_send_json_error('Failed to import theme mods.');
    }

    wp_die();
}

// Function to set theme mods
function watch_store_shop_demo_theme_importer($import_data) {
    if (is_array($import_data)) {
        foreach ($import_data as $mod_name => $mod_value) {
            set_theme_mod($mod_name, $mod_value);
        }
        return true;
    } else {
        return false;
    }
}

// Function to create demo menu
function watch_store_shop_create_demo_menu() {

    // Page import process
    $pages_to_create = array(
        array(
            'title'    => 'Home',
            'slug'     => 'home',
            'template' => 'page-template/home-template.php',
        ),
        array(
            'title'    => 'Search',
            'slug'     => 'search',
            'template' => '',
        ),
        array(
            'title'    => 'Collection',
            'slug'     => 'collection',
            'template' => '',
        ),
    );

    // Loop through each page data to create pages
    foreach ($pages_to_create as $page_data) {
        $page_check = get_page_by_title($page_data['title']);
        
        // Check if the page doesn't exist already
        if (!$page_check) {
            $page = array(
                'post_type'    => 'page',
                'post_title'   => $page_data['title'],
                'post_status'  => 'publish',
                'post_author'  => 1,
                'post_slug'    => $page_data['slug'],
            );
            
            // Insert the page and get the inserted page ID
            $page_id = wp_insert_post($page);
            
            // Set the page template
            if ($page_id) {
                add_post_meta($page_id, '_wp_page_template', $page_data['template']);
            }
        }
    }

    // Set 'Home' as the front page
    $home_page = get_page_by_title('Home');
    if ($home_page) {
        update_option('page_on_front', $home_page->ID);
        update_option('show_on_front', 'page');
    }

    // Set 'Blog' as the posts page
    $blog_page = get_page_by_title('Blog');
    if ($blog_page) {
        update_option('page_for_posts', $blog_page->ID);
    }
    // ------- Create Main Menu --------
    $menuname =  'Primary Menu';
    $bpmenulocation = 'primary';
    $menu_exists = wp_get_nav_menu_object($menuname);
    
    if (!$menu_exists) {
        $menu_id = wp_create_nav_menu($menuname);
        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('Home','watch-store-shop'),
            'menu-item-classes' => 'home',
            'menu-item-url' => home_url( '/' ),
            'menu-item-status' => 'publish'));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' => __('Search','watch-store-shop'),
            'menu-item-classes' => 'search',
            'menu-item-url' => home_url( '/search' ),
            'menu-item-status' => 'publish',
        ));

        wp_update_nav_menu_item($menu_id, 0, array(
            'menu-item-title' =>  __('Collection','watch-store-shop'),
            'menu-item-classes' => 'collection',
            'menu-item-url' => home_url( '/collection' ),
            'menu-item-status' => 'publish'
        ));

        // Assign the menu to the location
        if (!has_nav_menu($bpmenulocation)) {
            $locations = get_theme_mod('nav_menu_locations');
            $locations[$bpmenulocation] = $menu_id;
            set_theme_mod('nav_menu_locations', $locations);
        }
    }
    
    //Top Header
    set_theme_mod( 'watch_store_shop_header_sidebar_setting', true );

    //Slider
    set_theme_mod( 'watch_store_shop_banner_section_setting', true );

    set_theme_mod( 'watch_store_shop_banner_content', 'DISCOVER TIMEPIECES THAT BLEND TIMELESS ELEGANCE WITH MODERN PRECISION. EACH WATCH IS CRAFTED TO REFLECT SOPHISTICATION, DURABILITY, AND STYLE, MAKING IT THE PERFECT COMPANION FOR EVERY OCCASION. ELEVATE YOUR LOOK WITH WATCHES DESIGNED FOR THOSE WHO VALUE BOTH HERITAGE AND INNOVATION.' );
    set_theme_mod( 'watch_store_shop_banner_heading', 'RICHARD MILLE' );

    set_theme_mod( 'watch_store_shop_banner_btn_text', 'EXPLORE MORE' );
    set_theme_mod( 'watch_store_shop_banner_btn_url', '#' );

    set_theme_mod( 'watch_store_shop_banner_service1', 'PREMIUM QUALITY MATERIALS' );
    set_theme_mod( 'watch_store_shop_banner_service2', 'SECURE PAYMENT OPTIONS' );
    set_theme_mod( 'watch_store_shop_banner_service3', 'THE EXCLUSIVE COLLECTION' );

    //Product Section

    set_theme_mod( 'watch_store_shop_activities_section_setting', true );
    set_theme_mod( 'watch_store_shop_services_sub_heading', 'CHRONOLUX' );
    set_theme_mod( 'watch_store_shop_services_heading', 'The Exclusive Collection' );
    set_theme_mod( 'watch_store_shop_services_one_word', '2025' );
    set_theme_mod( 'watch_store_shop_product_category', 'Featured' );

    //Kids Product
	$product_category= array(
		'Featured' => array(
			'PATEK PHILIPPE PINK',
			'PATEK PHILIPPE PINK',
			'PATEK PHILIPPE PINK',
			'PATEK PHILIPPE PINK',
		),
	);
	$k = 1;
	foreach ( $product_category as $product_cats => $products_name ) {
		// Insert porduct cats Start
		$content = 'This is sample product category';
		$parent_category = wp_insert_term(
							$product_cats, // the term
							 'product_cat', // the taxonomy
							array(
								'description'=> $content,
								'slug' => str_replace( ' ', '-', $product_cats)
							) );

		// -------------- create subcategory START ---------------
		$review_text = array(
			'Nice product',
			'Good Quality Product',
			'Nice Product. Must buy It.',
			'I like this Product',
			'Nice Product',
		);
		// -------------- create subcategory END -----------------
		// create Product START
		foreach ( $products_name as $key => $product_title ) {
			$content = 'Lorem Ipsum has been the industrys standard dummy text ever since the 1500 when an unknown printer took a galley of type and scrambled it to make a type specimen book when an unknown printer took a galley of type and scrambled it to make a type specimen book.';
			// Create post object
			$my_post = array(
				'post_title'    => wp_strip_all_tags( $product_title ),
				'post_content'  => $content,
				'post_status'   => 'publish',
				'post_type'     => 'product',
				'post_category' => [$parent_category['term_id']]
			);
			// Insert the post into the database
			$post_id    = wp_insert_post($my_post);
			wp_set_object_terms( $post_id, str_replace( ' ', '-', $product_cats), 'product_cat', true );

			update_post_meta( $post_id, '_regular_price', "$500.00" );
			update_post_meta( $post_id, '_sale_price', "$450.00" );
			update_post_meta( $post_id, '_price', "$450.00" );

			// -------------- rating START -------------------------
			for ( $c=0; $c <= 4; $c++ ) {
				$comment_id = wp_insert_comment( array(
					'comment_post_ID'      => $post_id,
					'comment_author'       => get_the_author_meta( 'display_name' ),
					'comment_author_email' => get_the_author_meta( 'user_email' ),
					'comment_content'      => $review_text[$c],
					'comment_parent'       => 0,
					'user_id'              => get_current_user_id(), // <== Important
					'comment_date'         => date('Y-m-d H:i:s'),
					'comment_approved'     => 1,
				) );
				update_comment_meta( $comment_id, 'rating', 3 );
			}
			// ------------- rating END -------------------------
			
			// Now replace meta w/ new updated value array
			$image_url = get_template_directory_uri().'/assets/img/watch' . $k .'.png';
			//  $image_url = get_template_directory_uri().'/assets/images/product/'.$product_cats.'/'.$product_title.'.png';
			$image_name  = 'watch'.$k.'.png';
			$upload_dir = wp_upload_dir();
			// Set upload folder
			$image_data = file_get_contents(esc_url($image_url));
			// Get image data
			$unique_file_name = wp_unique_filename($upload_dir['path'], $image_name);
			// Generate unique name
			$filename = basename($unique_file_name);
			// Create image file name
			// Check folder permission and define file location
			if (wp_mkdir_p($upload_dir['path'])) {
				$file = $upload_dir['path'].'/'.$filename;
			}
			// Create the image  file on the server
			file_put_contents($file, $image_data);
			// Check image file type
			$wp_filetype = wp_check_filetype($filename, null);
			// Set attachment data
			$attachment = array(
				'post_mime_type' => $wp_filetype['type'],
				'post_title'     => sanitize_file_name($filename),
				'post_type'      => 'product',
				'post_status'    => 'inherit',
			);
			// Create the attachment
			$attach_id = wp_insert_attachment($attachment, $file, $post_id);
			// Include image.php
			require_once (ABSPATH.'wp-admin/includes/image.php');
			// Define attachment metadata
			$attach_data = wp_generate_attachment_metadata($attach_id, $file);
			// Assign metadata to attachment
			wp_update_attachment_metadata($attach_id, $attach_data);
			// And finally assign featured image to post
			set_post_thumbnail($post_id, $attach_id);
		}
		// Create product END
		wp_update_post($post_id);
		$k++;
	}

}
// Enqueue necessary scripts
add_action('admin_enqueue_scripts', 'watch_store_shop_demo_importer_enqueue_scripts');

function watch_store_shop_demo_importer_enqueue_scripts() {
    wp_enqueue_script(
        'demo-theme-importer',
        get_template_directory_uri() . '/assets/js/theme-importer.js', // Path to your JS file
        array('jquery'),
        null,
        true
    );

    wp_enqueue_style('demo-importer-style', get_template_directory_uri() . '/assets/css/importer.css', array(), '');

    // Localize script to pass AJAX URL to JS
    wp_localize_script(
        'demo-theme-importer',
        'demoImporter',
        array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce'    => wp_create_nonce('theme_importer_nonce')
        )
    );
}


/**
 * Theme Info.
 */
function watch_store_shop_theme_info_load() {
	require get_theme_file_path( '/inc/theme-installation/theme-installation.php' );
}
add_action( 'init', 'watch_store_shop_theme_info_load' );

// add_action( 'watch_store_shop_navigation_action','watch_store_shop_single_post_navigation',30 );
if( !function_exists('watch_store_shop_content_offcanvas') ):

    // Offcanvas Contents
    function watch_store_shop_content_offcanvas(){ ?>

        <div id="offcanvas-menu">
            <div class="offcanvas-wraper">
                <div class="close-offcanvas-menu">
                    <div class="offcanvas-close">
                        <a href="javascript:void(0)" class="skip-link-menu-start"></a>
                        <button type="button" class="button-offcanvas-close">
                            <span class="offcanvas-close-label">
                                <i class="fas fa-times"></i>
                            </span>
                        </button>
                    </div>
                </div>
                <div id="primary-nav-offcanvas" class="offcanvas-item offcanvas-main-navigation">
                    <nav class="primary-menu-wrapper" aria-label="<?php esc_attr_e('Horizontal', 'watch-store-shop'); ?>" role="navigation">
                        <ul class="primary-menu theme-menu">
                            <?php
                            if (has_nav_menu('primary')) {
                                wp_nav_menu(
                                    array(
                                        'container' => '',
                                        'items_wrap' => '%3$s',
                                        'theme_location' => 'primary',
                                        'show_toggles' => true,
                                    )
                                );
                            }else{

                                wp_list_pages(
                                    array(
                                        'match_menu_classes' => true,
                                        'show_sub_menu_icons' => true,
                                        'title_li' => false,
                                        'show_toggles' => true,
                                        'walker' => new Watch_Store_Shop_Menu_Page(),
                                    )
                                );
                            }
                            ?>
                        </ul>
                    </nav><!-- .primary-menu-wrapper -->
                </div>
                <a href="javascript:void(0)" class="skip-link-menu-end"></a>
            </div>
        </div>

    <?php
    }

endif;

add_action( 'watch_store_shop_before_footer_content_action','watch_store_shop_content_offcanvas',30 );


if ( ! function_exists( 'watch_store_shop_sub_menu_toggle_button' ) ) :

    function watch_store_shop_sub_menu_toggle_button( $args, $item, $depth ) {

        // Add sub menu toggles to the main menu with toggles
        if ( $args->theme_location == 'primary' && isset( $args->show_toggles ) ) {
            
            // Wrap the menu item link contents in a div, used for positioning
            $args->before = '<div class="submenu-wrapper">';
            $args->after  = '';

            // Add a toggle to items with children
            if ( in_array( 'menu-item-has-children', $item->classes ) ) {

                $toggle_target_string = '.menu-item.menu-item-' . $item->ID . ' > .sub-menu';

                // Add the sub menu toggle with Font Awesome icon
                $args->after .= '<button type="button" class="theme-aria-button submenu-toggle" data-toggle-target="' . esc_attr( $toggle_target_string ) . '" data-toggle-type="slidetoggle" data-toggle-duration="250" aria-expanded="false"><span class="btn__content" tabindex="-1"><span class="screen-reader-text">' . esc_html__( 'Show sub menu', 'watch-store-shop' ) . '</span><i class="fas fa-chevron-down"></i></span></button>';

            }

            // Close the wrapper
            $args->after .= '</div><!-- .submenu-wrapper -->';

        } elseif ( $args->theme_location == 'primary' ) {

            if ( in_array( 'menu-item-has-children', $item->classes ) ) {

                $args->before = '<div class="link-icon-wrapper">';
                $args->after  = '<i class="fas fa-chevron-down"></i></div>';

            } else {

                $args->before = '';
                $args->after  = '';

            }

        }

        return $args;

    }

endif;

add_filter( 'nav_menu_item_args', 'watch_store_shop_sub_menu_toggle_button', 10, 3 );

add_action('wp_ajax_import_theme_mods', 'watch_store_shop_import_function');

function watch_store_shop_import_function() {
    check_ajax_referer('your-nonce-key', '_ajax_nonce');
    wp_send_json_success([
        'msg' => 'Demo imported successfully',
        'redirect' => admin_url('themes.php?page=theme-options')
    ]);
}
add_filter( 'woocommerce_prevent_automatic_wizard_redirect', '__return_true' );


// Getstart Function


function free_mnssp_get_filtered_products($cursor = '', $search = '', $collection = 'pro') {
    $endpoint_url = FREE_MNSSP_API_URL . 'getFilteredProducts';

    $remote_post_data = array(
        'collectionHandle' => $collection,
        'productHandle' => $search,
        'paginationParams' => array(
            "first" => 12,
            "afterCursor" => $cursor,
            "beforeCursor" => "",
            "reverse" => true
        )
    );

    $body = wp_json_encode($remote_post_data);

    $options = [
        'body' => $body,
        'headers' => [
            'Content-Type' => 'application/json'
        ]
    ];
    $response = wp_remote_post($endpoint_url, $options);

    if (!is_wp_error($response)) {
        $response_body = wp_remote_retrieve_body($response);
        $response_body = json_decode($response_body);

        if (isset($response_body->data) && !empty($response_body->data)) {
            if (isset($response_body->data->products) && !empty($response_body->data->products)) {
                return  array(
                    'products' => $response_body->data->products,
                    'pagination' => $response_body->data->pageInfo
                );
            }
        }
        return [];
    }
    
    return [];
}

function free_mnssp_get_filtered_products_ajax() {
    $cursor = isset($_POST['cursor']) ? sanitize_text_field(wp_unslash($_POST['cursor'])) : '';
    $search = isset($_POST['search']) ? sanitize_text_field(wp_unslash($_POST['search'])) : '';
    $collection = isset($_POST['collection']) ? sanitize_text_field(wp_unslash($_POST['collection'])) : 'pro';

    check_ajax_referer('free_mnssp_create_pagination_nonce_action', 'mnssp_pagination_nonce');

    $get_filtered_products = free_mnssp_get_filtered_products($cursor, $search, $collection);
    ob_start();
    if (isset($get_filtered_products['products']) && !empty($get_filtered_products['products'])) {
        foreach ( $get_filtered_products['products'] as $product ) {

            $product_obj = $product->node;
            
            if (isset($product_obj->inCollection) && !$product_obj->inCollection) {
                continue;
            }

            $product_obj = $product->node;

            $demo_url = isset($product->node->metafield->value) ? $product->node->metafield->value : '';
            $product_url = isset($product->node->onlineStoreUrl) ? $product->node->onlineStoreUrl : '';
            $image_src = isset($product->node->images->edges[0]->node->src) ? $product->node->images->edges[0]->node->src : '';
            $price = isset($product->node->variants->edges[0]->node->price) ? '$' . $product->node->variants->edges[0]->node->price : ''; ?>

            <div class="mnssp-grid-item">
                <div class="mnssp-image-wrap">
                    <img src="<?php echo esc_url($image_src); ?>" alt="<?php echo esc_attr($product_obj->title); ?>">
                    <div class="mnssp-image-overlay">
                        <a class="mnssp-demo-url mnssp-btn" href="<?php echo esc_attr($demo_url); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html('Demo'); ?></a>
                        <a class="mnssp-buy-now mnssp-btn" href="<?php echo esc_attr($product_url); ?>" target="_blank" rel="noopener noreferrer"><?php echo esc_html('Buy Now'); ?></a>
                    </div>
                </div>
                <footer>
                    <h3><?php echo esc_html($product_obj->title); ?></h3>
                </footer>
                <div class="mnssp-grid-item-price">Price: <?php echo esc_html($price); ?></div>
            </div>
        <?php }
    }
    $output = ob_get_clean();

    $pagination = isset($get_filtered_products['pagination']) ?  $get_filtered_products['pagination'] : [];
    wp_send_json(array(
        'content' => $output,
        'pagination' => $pagination
    ));
}

add_action('wp_ajax_free_mnssp_get_filtered_products', 'free_mnssp_get_filtered_products_ajax');
add_action('wp_ajax_nopriv_free_mnssp_get_filtered_products', 'free_mnssp_get_filtered_products_ajax');

function free_mnssp_get_collections() {
    
    $endpoint_url = FREE_MNSSP_API_URL . 'getCollections';

    $options = [
        'body' => [],
        'headers' => [
            'Content-Type' => 'application/json'
        ]
    ];
    $response = wp_remote_post($endpoint_url, $options);

    if (!is_wp_error($response)) {
        $response_body = wp_remote_retrieve_body($response);
        $response_body = json_decode($response_body);

        if (isset($response_body->data) && !empty($response_body->data)) {
           return  $response_body->data;
        }
        return  [];
    }

    return  [];
}