<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Watch Store Shop
 */
do_action('watch_store_shop_before_footer_content_action');

?>

<footer id="colophon" class="site-footer border-top">
    <div class="container">
    	<div class="footer-column">
	      	<div class="row">
		        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
		          	<?php if (is_active_sidebar('watch-store-shop-footer1')) : ?>
                        <?php dynamic_sidebar('watch-store-shop-footer1'); ?>
                    <?php else : ?>
                        <aside id="search" class="widget" role="complementary" aria-label="<?php esc_attr_e( 'firstsidebar', 'watch-store-shop' ); ?>">
                            <h5 class="widget-title"><?php esc_html_e( 'About Us', 'watch-store-shop' ); ?></h5>
                            <div class="textwidget">
                            	<p><?php esc_html_e( 'Nam malesuada nulla nisi, ut faucibus magna congue nec. Ut libero tortor, tempus at auctor in, molestie at nisi. In enim ligula, consequat eu feugiat a.', 'watch-store-shop' ); ?></p>
                            </div>
                        </aside>
                    <?php endif; ?>
		        </div>
		        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
		            <?php if (is_active_sidebar('watch-store-shop-footer2')) : ?>
                        <?php dynamic_sidebar('watch-store-shop-footer2'); ?>
                    <?php else : ?>
                        <aside id="pages" class="widget">
                            <h5 class="widget-title"><?php esc_html_e( 'Useful Links', 'watch-store-shop' ); ?></h5>
                            <ul class="mt-4">
                            	<li><a href="#"><?php esc_html_e( 'Home', 'watch-store-shop' ); ?></a></li>
                            	<li><a href="#"><?php esc_html_e( 'Tournaments', 'watch-store-shop' ); ?></a></li>
                            	<li><a href="#"><?php esc_html_e( 'Reviews', 'watch-store-shop' ); ?></a></li>
                            	<li><a href="#"><?php esc_html_e( 'About Us', 'watch-store-shop' ); ?></a></li>
                            </ul>
                        </aside>
                    <?php endif; ?>
		        </div>
		        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
		            <?php if (is_active_sidebar('watch-store-shop-footer3')) : ?>
                        <?php dynamic_sidebar('watch-store-shop-footer3'); ?>
                    <?php else : ?>
                        <aside id="pages" class="widget">
                            <h5 class="widget-title"><?php esc_html_e( 'Information', 'watch-store-shop' ); ?></h5>
                            <ul class="mt-4">
                            	<li><?php esc_html_e( 'FAQ', 'watch-store-shop' ); ?></li>
                            	<li><?php esc_html_e( 'Site Maps', 'watch-store-shop' ); ?></li>
                            	<li><?php esc_html_e( 'Privacy Policy', 'watch-store-shop' ); ?></li>
                            	<li><?php esc_html_e( 'Contact Us', 'watch-store-shop' ); ?></li>
                            </ul>
                        </aside>
                    <?php endif; ?>
		        </div>
		        <div class="col-lg-3 col-md-6 col-sm-6 col-12">
		            <?php if (is_active_sidebar('watch-store-shop-footer4')) : ?>
                        <?php dynamic_sidebar('watch-store-shop-footer4'); ?>
                    <?php else : ?>
                        <aside id="pages" class="widget">
                            <h5 class="widget-title"><?php esc_html_e( 'Get In Touch', 'watch-store-shop' ); ?></h5>
                            <ul class="mt-4">
                            	<li><?php esc_html_e( 'Via Carlo Montù 78', 'watch-store-shop' ); ?><br><?php esc_html_e( '22021 Bellagio CO, Italy', 'watch-store-shop' ); ?></li>
                            	<li><?php esc_html_e( '+11 6254 7855', 'watch-store-shop' ); ?></li>
                            	<li><?php esc_html_e( 'support@example.com', 'watch-store-shop' ); ?></li>
                            </ul>
                        </aside>
                    <?php endif; ?>
		        </div>
	      	</div>
		</div>
    	<?php if (get_theme_mod('watch_store_shop_show_hide_copyright', true)) {?>
	        <div class="site-info">
	            <div class="footer-menu-left text-center">
	            	<?php  if( ! get_theme_mod('watch_store_shop_footer_text_setting') ){ ?>
					    <a target="_blank" href="<?php echo esc_url('https://wordpress.org/'); ?>">
							<?php
							/* translators: %s: CMS name, i.e. WordPress. */
							printf( esc_html__( 'Proudly powered by %s', 'watch-store-shop' ), 'WordPress' );
							?>
					    </a>
					    <span class="sep mr-1"> | </span>

							    <span>
		                            <a href="https://www.themagnifico.net/products/watch-store-shop" target="_blank">
		    			              	<?php
		    			                /* translators: 1: Theme name,  */
		    			                printf( esc_html__( ' %1$s ', 'watch-store-shop' ),'Watch Store Shop Theme' );
		    			              	?>
	    			              	</a>
						          	<?php
						              /* translators: 1: Theme author. */
						              printf( esc_html__( 'by %1$s.', 'watch-store-shop' ),'TheMagnifico'  );
						            ?>

			        			</span>
					<?php }?>
					<?php echo esc_html(get_theme_mod('watch_store_shop_footer_text_setting')); ?>
	            </div>
	        </div>
		<?php } ?>
	    <?php if(get_theme_mod('watch_store_shop_scroll_hide',true)){ ?>
	    	<a id="button"><?php esc_html_e('TOP','watch-store-shop'); ?></a>
	    <?php } ?>
    </div>
</footer>
</div>

<?php wp_footer(); ?>

</body>
</html>