( function( window, document ) {

  function watch_store_shop_keepFocusInSidebar() {
    document.addEventListener( 'keydown', function( e ) {
      const watch_store_shop_nav = document.querySelector( '.header-widgets' );

      if ( ! watch_store_shop_nav || ! watch_store_shop_nav.classList.contains( 'show' ) ) {
        return;
      }
      const elements = [...watch_store_shop_nav.querySelectorAll( 'input, a, button' )],
        watch_store_shop_lastEl = elements[ elements.length - 1 ],
        watch_store_shop_firstEl = elements[0],
        watch_store_shop_activeEl = document.activeElement,
        tabKey = e.keyCode === 9,
        shiftKey = e.shiftKey;

      if ( ! shiftKey && tabKey && watch_store_shop_lastEl === watch_store_shop_activeEl ) {
        e.preventDefault();
        watch_store_shop_firstEl.focus();
      }

      if ( shiftKey && tabKey && watch_store_shop_firstEl === watch_store_shop_activeEl ) {
        e.preventDefault();
        watch_store_shop_lastEl.focus();
      }
    } );
  }

  watch_store_shop_keepFocusInSidebar();
} )( window, document );

function watch_store_shop_openSidebar() {
  jQuery(".header-widgets").addClass('show');
}
function watch_store_shop_closeSidebar() {
  jQuery(".header-widgets").removeClass('show');
}

function watch_store_shop_openNav() {
  jQuery(".sidenav").addClass('show');
}
function watch_store_shop_closeNav() {
  jQuery(".sidenav").removeClass('show');
}

var watch_store_shop_btn = jQuery('#button');

jQuery(window).scroll(function() {
  if (jQuery(window).scrollTop() > 300) {
    watch_store_shop_btn.addClass('show');
  } else {
    watch_store_shop_btn.removeClass('show');
  }
});

watch_store_shop_btn.on('click', function(e) {
  e.preventDefault();
  jQuery('html, body').animate({scrollTop:0}, '300');
});

window.addEventListener('load', (event) => {
  jQuery(".loading").delay(2000).fadeOut("slow");
});

jQuery(document).ready(function ($) {
// Menu Js
    $('.submenu-toggle').click(function () {
        $(this).toggleClass('button-toggle-active');
        var currentClass = $(this).attr('data-toggle-target');
        $(currentClass).toggleClass('submenu-toggle-active');
    });
    $('.skip-link-menu-start').focus(function () {
        if (!$("#offcanvas-menu #primary-nav-offcanvas").length == 0) {
            $("#offcanvas-menu #primary-nav-offcanvas ul li:last-child a").focus();
        }
    });
    // Menu Toggle Js
    $('.navbar-control-offcanvas').click(function () {
        $(this).addClass('active');
        $('body').addClass('body-scroll-locked');
        $('#offcanvas-menu').toggleClass('offcanvas-menu-active');
        $('.button-offcanvas-close').focus();
    });
    $('.offcanvas-close .button-offcanvas-close').click(function () {
        $('#offcanvas-menu').removeClass('offcanvas-menu-active');
        $('.navbar-control-offcanvas').removeClass('active');
        $('body').removeClass('body-scroll-locked');
        setTimeout(function () {
            $('.navbar-control-offcanvas').focus();
        }, 300);
    });
    $('#offcanvas-menu').click(function () {
        $('#offcanvas-menu').removeClass('offcanvas-menu-active');
        $('.navbar-control-offcanvas').removeClass('active');
        $('body').removeClass('body-scroll-locked');
    });
    $(".offcanvas-wraper").click(function (e) {
        e.stopPropagation(); //stops click event from reaching document
    });
    $('.skip-link-menu-end').on('focus', function () {
        $('.button-offcanvas-close').focus();
    });
});

jQuery('.header-search-wrapper .search-main').click(function(){
  jQuery('.search-form-main').toggleClass('active-search');
  jQuery('.search-form-main .search-field').focus();
});

jQuery(document).ready(function() {
    var owl = jQuery('.featured .owl-carousel');
    owl.owlCarousel({
    margin: 30,
    nav:false,
    autoplay : true,
    lazyLoad: true,
    autoplayTimeout: 5000,
    loop: true,
    dots: false,
    navText : ['<i class="fas fa-arrow-left" aria-hidden="true"></i>','<i class="fas fa-arrow-right" aria-hidden="true"></i>'],
    responsive: {
      0: {
        items: 1
      },
      576: {
        items: 1
      },
      768: {
        items: 2
      },
      1000: {
        items: 3
      },
      1200: {
        items: 4
      }
    },
    autoplayHoverPause : false,
    mouseDrag: true
  });
})