<?php

/**
 * Template part for displaying front page introduction.
 *
 * @package Warm Blog
 */

// Banner Section.
$banner_section = get_theme_mod( 'warm_blog_banner_section_enable', false );

if ( false === $banner_section ) {
	return;
}

$banner_posts_content_ids     = $banner_featured_content_ids = array();
$banner_posts_content_type    = get_theme_mod( 'warm_blog_banner_posts_content_type', 'post' );
$banner_featured_content_type = get_theme_mod( 'warm_blog_banner_featured_posts_content_type', 'post' );

if ( $banner_posts_content_type === 'post' ) {

	for ( $i = 1; $i <= 3; $i++ ) {
		$banner_posts_content_ids[] = get_theme_mod( 'warm_blog_banner_post_' . $i );
	}

	$banner_posts_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 3 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $banner_posts_content_ids ) ) ) {
		$banner_posts_args['post__in'] = array_filter( $banner_posts_content_ids );
		$banner_posts_args['orderby']  = 'post__in';
	} else {
		$banner_posts_args['orderby'] = 'date';
	}

} else {
	$cat_content_id = get_theme_mod( 'warm_blog_banner_category' );
	$banner_posts_args           = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 3 ),
	);
}

if ( $banner_featured_content_type === 'post' ) {

	for ( $i = 1; $i <= 5; $i++ ) {
		$banner_featured_content_ids[] = get_theme_mod( 'warm_blog_banner_featured_post_' . $i );
	}

	$banner_featured_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 5 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $banner_featured_content_ids ) ) ) {
		$banner_featured_args['post__in'] = array_filter( $banner_featured_content_ids );
		$banner_featured_args['orderby']  = 'post__in';
	} else {
		$banner_featured_args['orderby'] = 'date';
	}

} else {
	$cat_content_id = get_theme_mod( 'warm_blog_banner_featured_category' );
	$banner_featured_args           = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 5 ),
	);
}

?>

<div id="warm_blog_banner_section" class="frontpage banner-section style-1">
	<div class="theme-wrapper">

		<div class="banner-style-1-wrapper">
			
			<div class="banner-slider-part">
				<?php require get_template_directory() . '/inc/frontpage-sections/banner-sections/banner-posts.php'; ?>
			</div>

			<?php require get_template_directory() . '/inc/frontpage-sections/banner-sections/banner-featured.php'; ?>

		</div>

	</div>
</div>