<div class="banner-post-wrapper adore-navigation">
	<?php
	$banner_posts_query = new WP_Query( $banner_posts_args );
	if ( $banner_posts_query->have_posts() ) {
		while ( $banner_posts_query->have_posts() ) :
			$banner_posts_query->the_post();
			?>
			<div class="banner-carousel">
				<div class="post-item overlay-post" style="background-image: url('<?php echo esc_url( get_the_post_thumbnail_url( get_the_ID(), 'post-thumbnail' ) ); ?>');">
					<div class="post-overlay">
						<div class="post-item-content">
							<div class="entry-cat overlay-cat">
								<?php the_category( '', '', get_the_ID() ); ?>
							</div>
							<h2 class="entry-title">
								<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
							</h2>
							<ul class="entry-meta">
								<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="far fa-user"></i><?php echo esc_html( get_the_author() ); ?></a></li>
								<li class="post-date"><i class="far fa-calendar-alt"></i></span><?php echo esc_html( get_the_date() ); ?></li>
								<li class="reading-time"><i class="far fa-clock"></i>
									<?php
									echo warm_blog_time_interval( get_the_content() );
									echo esc_html__( ' min read', 'warm-blog' );
									?>
								</li>
							</ul>
						</div>   
					</div>
				</div>
			</div>
			<?php
		endwhile;
		wp_reset_postdata();
	}
	?>
</div>
