<?php 
$section_title = get_theme_mod( 'warm_blog_banner_featured_title', __( 'Featured Posts', 'warm-blog' ) );
?>
<div class="banner-trending-part">
	<div class="banner-trending-wrapper">
		<div class="section-head">
			<div class="section-header">
				<h3 class="section-title"><?php echo esc_html( $section_title ); ?></h3>
			</div>
			<div class="banner-trending-arrows adore-navigation"></div>
		</div>
		<div class="trending-body">
			<?php
			$banner_featured_query = new WP_Query( $banner_featured_args );
			if ( $banner_featured_query->have_posts() ) {
				while ( $banner_featured_query->have_posts() ) :
					$banner_featured_query->the_post();
					?>
					<div class="banner-carousel">
						<div class="post-item post-list card-hover">
							<?php if ( has_post_thumbnail() ) { ?>
								<div class="post-item-image">
									<a href="<?php the_permalink(); ?>">
										<?php the_post_thumbnail( 'post-thumbnail' ); ?>
									</a>
								</div>
							<?php } ?>
							<div class="post-item-content">
								<h3 class="entry-title">
									<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
								</h3>  
								<ul class="entry-meta">
									<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="far fa-user"></i><?php echo esc_html( get_the_author() ); ?></a></li>
									<li class="post-date"><i class="far fa-calendar-alt"></i></span><?php echo esc_html( get_the_date() ); ?></li>
								</ul>
							</div>
						</div>
					</div>
					<?php
				endwhile;
				wp_reset_postdata();
			}
			?>
		</div>
	</div>
</div>