<?php
/**
 * Single Post Options
 */

$wp_customize->add_section(
	'warm_blog_single_page_options',
	array(
		'title' => esc_html__( 'Single Post Options', 'warm-blog' ),
		'panel' => 'warm_blog_theme_options_panel',
	)
);

// Enable single post category setting.
$wp_customize->add_setting(
	'warm_blog_enable_single_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_enable_single_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'warm-blog' ),
			'settings' => 'warm_blog_enable_single_category',
			'section'  => 'warm_blog_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post author setting.
$wp_customize->add_setting(
	'warm_blog_enable_single_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_enable_single_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'warm-blog' ),
			'settings' => 'warm_blog_enable_single_author',
			'section'  => 'warm_blog_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post date setting.
$wp_customize->add_setting(
	'warm_blog_enable_single_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_enable_single_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'warm-blog' ),
			'settings' => 'warm_blog_enable_single_date',
			'section'  => 'warm_blog_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable single post tag setting.
$wp_customize->add_setting(
	'warm_blog_enable_single_tag',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_enable_single_tag',
		array(
			'label'    => esc_html__( 'Enable Post Tag', 'warm-blog' ),
			'settings' => 'warm_blog_enable_single_tag',
			'section'  => 'warm_blog_single_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Single post related Posts title label.
$wp_customize->add_setting(
	'warm_blog_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'warm-blog' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'warm_blog_related_posts_title',
	array(
		'label'    => esc_html__( 'Related Posts Title', 'warm-blog' ),
		'section'  => 'warm_blog_single_page_options',
		'settings' => 'warm_blog_related_posts_title',
	)
);
