<?php
/**
 * Sidebar settings
 */

$wp_customize->add_section(
	'warm_blog_sidebar_option',
	array(
		'title' => esc_html__( 'Sidebar Options', 'warm-blog' ),
		'panel' => 'warm_blog_theme_options_panel',
	)
);

// Sidebar Option - Global Sidebar Position.
$wp_customize->add_setting(
	'warm_blog_sidebar_position',
	array(
		'sanitize_callback' => 'warm_blog_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'warm_blog_sidebar_position',
	array(
		'label'   => esc_html__( 'Global Sidebar Position', 'warm-blog' ),
		'section' => 'warm_blog_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'warm-blog' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'warm-blog' ),
		),
	)
);

// Sidebar Option - Post Sidebar Position.
$wp_customize->add_setting(
	'warm_blog_post_sidebar_position',
	array(
		'sanitize_callback' => 'warm_blog_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'warm_blog_post_sidebar_position',
	array(
		'label'   => esc_html__( 'Post Sidebar Position', 'warm-blog' ),
		'section' => 'warm_blog_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'warm-blog' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'warm-blog' ),
		),
	)
);

// Sidebar Option - Page Sidebar Position.
$wp_customize->add_setting(
	'warm_blog_page_sidebar_position',
	array(
		'sanitize_callback' => 'warm_blog_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'warm_blog_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Page Sidebar Position', 'warm-blog' ),
		'section' => 'warm_blog_sidebar_option',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'warm-blog' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'warm-blog' ),
		),
	)
);
