<?php
/**
 * Pagination setting
 */

// Pagination setting.
$wp_customize->add_section(
	'warm_blog_pagination',
	array(
		'title' => esc_html__( 'Pagination', 'warm-blog' ),
		'panel' => 'warm_blog_theme_options_panel',
	)
);

// Pagination enable setting.
$wp_customize->add_setting(
	'warm_blog_pagination_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_pagination_enable',
		array(
			'label'    => esc_html__( 'Enable Pagination.', 'warm-blog' ),
			'settings' => 'warm_blog_pagination_enable',
			'section'  => 'warm_blog_pagination',
			'type'     => 'checkbox',
		)
	)
);

// Pagination - Pagination Style.
$wp_customize->add_setting(
	'warm_blog_pagination_type',
	array(
		'default'           => 'numeric',
		'sanitize_callback' => 'warm_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'warm_blog_pagination_type',
	array(
		'label'           => esc_html__( 'Pagination Style', 'warm-blog' ),
		'section'         => 'warm_blog_pagination',
		'type'            => 'select',
		'choices'         => array(
			'default' => __( 'Default (Older/Newer)', 'warm-blog' ),
			'numeric' => __( 'Numeric', 'warm-blog' ),
		),
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'warm_blog_pagination_enable' )->value() );
		},
	)
);
