<?php
/**
 * Breadcrumb settings
 */

$wp_customize->add_section(
	'warm_blog_breadcrumb_section',
	array(
		'title' => esc_html__( 'Breadcrumb Options', 'warm-blog' ),
		'panel' => 'warm_blog_theme_options_panel',
	)
);

// Breadcrumb enable setting.
$wp_customize->add_setting(
	'warm_blog_breadcrumb_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);
$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_breadcrumb_enable',
		array(
			'label'    => esc_html__( 'Enable breadcrumb.', 'warm-blog' ),
			'type'     => 'checkbox',
			'settings' => 'warm_blog_breadcrumb_enable',
			'section'  => 'warm_blog_breadcrumb_section',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'warm_blog_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'warm_blog_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'warm-blog' ),
		'section'         => 'warm_blog_breadcrumb_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'warm_blog_breadcrumb_enable' )->value() );
		},
	)
);
