<?php
/**
 * Blog / Archive Options
 */

$wp_customize->add_section(
	'warm_blog_archive_page_options',
	array(
		'title' => esc_html__( 'Blog / Archive Pages Options', 'warm-blog' ),
		'panel' => 'warm_blog_theme_options_panel',
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'warm_blog_excerpt_length',
	array(
		'default'           => 30,
		'sanitize_callback' => 'warm_blog_sanitize_number_range',
	)
);

$wp_customize->add_control(
	'warm_blog_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'warm-blog' ),
		'section'     => 'warm_blog_archive_page_options',
		'settings'    => 'warm_blog_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 5,
			'max'  => 200,
			'step' => 1,
		),
	)
);

// Grid Column layout options.
$wp_customize->add_setting(
	'warm_blog_archive_grid_column_layout',
	array(
		'default'           => 'grid-column-2',
		'sanitize_callback' => 'warm_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'warm_blog_archive_grid_column_layout',
	array(
		'label'   => esc_html__( 'Grid Column Layout', 'warm-blog' ),
		'section' => 'warm_blog_archive_page_options',
		'type'    => 'select',
		'choices' => array(
			'grid-column-2' => __( 'Column 2', 'warm-blog' ),
			'grid-column-3' => __( 'Column 3', 'warm-blog' ),
		),
	)
);

// Enable archive page category setting.
$wp_customize->add_setting(
	'warm_blog_enable_archive_category',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_enable_archive_category',
		array(
			'label'    => esc_html__( 'Enable Category', 'warm-blog' ),
			'settings' => 'warm_blog_enable_archive_category',
			'section'  => 'warm_blog_archive_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable archive page author setting.
$wp_customize->add_setting(
	'warm_blog_enable_archive_author',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_enable_archive_author',
		array(
			'label'    => esc_html__( 'Enable Author', 'warm-blog' ),
			'settings' => 'warm_blog_enable_archive_author',
			'section'  => 'warm_blog_archive_page_options',
			'type'     => 'checkbox',
		)
	)
);

// Enable archive page date setting.
$wp_customize->add_setting(
	'warm_blog_enable_archive_date',
	array(
		'default'           => true,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_enable_archive_date',
		array(
			'label'    => esc_html__( 'Enable Date', 'warm-blog' ),
			'settings' => 'warm_blog_enable_archive_date',
			'section'  => 'warm_blog_archive_page_options',
			'type'     => 'checkbox',
		)
	)
);
