<?php
/**
 * Adore Themes Customizer
 *
 * @package Warm Blog
 *
 * Banner Section
 */

$wp_customize->add_section(
	'warm_blog_banner_section',
	array(
		'title' => esc_html__( 'Banner Section', 'warm-blog' ),
		'panel' => 'warm_blog_frontpage_panel',
	)
);

// Banner enable setting.
$wp_customize->add_setting(
	'warm_blog_banner_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'warm_blog_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'warm_blog_banner_section_enable',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'warm-blog' ),
			'type'     => 'checkbox',
			'settings' => 'warm_blog_banner_section_enable',
			'section'  => 'warm_blog_banner_section',
		)
	)
);

// Banner Posts Sub Heading.
$wp_customize->add_setting(
	'warm_blog_banner_posts_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'warm_blog_banner_posts_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Posts Section', 'warm-blog' ),
			'settings'        => 'warm_blog_banner_posts_sub_heading',
			'section'         => 'warm_blog_banner_section',
			'active_callback' => 'warm_blog_if_banner_enabled',
		)
	)
);

// posts carousel content type settings.
$wp_customize->add_setting(
	'warm_blog_banner_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'warm_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'warm_blog_banner_posts_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'warm-blog' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'warm-blog' ),
		'section'         => 'warm_blog_banner_section',
		'type'            => 'select',
		'active_callback' => 'warm_blog_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'warm-blog' ),
			'category' => esc_html__( 'Category', 'warm-blog' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// posts carousel post setting.
	$wp_customize->add_setting(
		'warm_blog_banner_post_' . $i,
		array(
			'sanitize_callback' => 'warm_blog_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'warm_blog_banner_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'warm-blog' ), $i ),
			'section'         => 'warm_blog_banner_section',
			'type'            => 'select',
			'choices'         => warm_blog_get_post_choices(),
			'active_callback' => 'warm_blog_banner_section_content_type_post_enabled',
		)
	);

}

// posts carousel category setting.
$wp_customize->add_setting(
	'warm_blog_banner_category',
	array(
		'sanitize_callback' => 'warm_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'warm_blog_banner_category',
	array(
		'label'           => esc_html__( 'Category', 'warm-blog' ),
		'section'         => 'warm_blog_banner_section',
		'type'            => 'select',
		'choices'         => warm_blog_get_post_cat_choices(),
		'active_callback' => 'warm_blog_banner_section_content_type_category_enabled',
	)
);

// Featured Posts Sub Heading.
$wp_customize->add_setting(
	'warm_blog_banner_featured_posts_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Warm_Blog_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'warm_blog_banner_featured_posts_sub_heading',
		array(
			'label'           => esc_html__( 'Featured Posts Section', 'warm-blog' ),
			'settings'        => 'warm_blog_banner_featured_posts_sub_heading',
			'section'         => 'warm_blog_banner_section',
			'active_callback' => 'warm_blog_if_banner_enabled',
		)
	)
);

// Banner Featured title settings.
$wp_customize->add_setting(
	'warm_blog_banner_featured_title',
	array(
		'default'           => __( 'Featured Posts', 'warm-blog' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'warm_blog_banner_featured_title',
	array(
		'label'           => esc_html__( 'Section Title', 'warm-blog' ),
		'section'         => 'warm_blog_banner_section',
		'active_callback' => 'warm_blog_if_banner_enabled',
	)
);

// Banner Featured Posts content type settings.
$wp_customize->add_setting(
	'warm_blog_banner_featured_posts_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'warm_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'warm_blog_banner_featured_posts_content_type',
	array(
		'label'           => esc_html__( 'Content type:', 'warm-blog' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'warm-blog' ),
		'section'         => 'warm_blog_banner_section',
		'type'            => 'select',
		'active_callback' => 'warm_blog_if_banner_enabled',
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'warm-blog' ),
			'category' => esc_html__( 'Category', 'warm-blog' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Banner Featured post setting.
	$wp_customize->add_setting(
		'warm_blog_banner_featured_post_' . $i,
		array(
			'sanitize_callback' => 'warm_blog_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'warm_blog_banner_featured_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'warm-blog' ), $i ),
			'section'         => 'warm_blog_banner_section',
			'type'            => 'select',
			'choices'         => warm_blog_get_post_choices(),
			'active_callback' => 'warm_blog_banner_featured_posts_content_type_post_enabled',
		)
	);

}

// posts carousel category setting.
$wp_customize->add_setting(
	'warm_blog_banner_featured_category',
	array(
		'sanitize_callback' => 'warm_blog_sanitize_select',
	)
);

$wp_customize->add_control(
	'warm_blog_banner_featured_category',
	array(
		'label'           => esc_html__( 'Category', 'warm-blog' ),
		'section'         => 'warm_blog_banner_section',
		'type'            => 'select',
		'choices'         => warm_blog_get_post_cat_choices(),
		'active_callback' => 'warm_blog_banner_featured_content_type_category_enabled',
	)
);

/*========================Active Callback==============================*/
function warm_blog_if_banner_enabled( $control ) {
	return $control->manager->get_setting( 'warm_blog_banner_section_enable' )->value();
}
function warm_blog_banner_section_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'warm_blog_banner_posts_content_type' )->value();
	return warm_blog_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function warm_blog_banner_section_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'warm_blog_banner_posts_content_type' )->value();
	return warm_blog_if_banner_enabled( $control ) && ( 'category' === $content_type );
}

function warm_blog_banner_featured_posts_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'warm_blog_banner_featured_posts_content_type' )->value();
	return warm_blog_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function warm_blog_banner_featured_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'warm_blog_banner_featured_posts_content_type' )->value();
	return warm_blog_if_banner_enabled( $control ) && ( 'category' === $content_type );
}