<?php
/**
 * The Template for displaying single post
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

get_header();

global $w3construct_option;

$post_layout = w3construct_set( $w3construct_option, 'post_layout' );
$post_layout = ! empty( $post_layout ) ? $post_layout : 'standard';

/* Manage post views count */
$meta_views_count = get_post_meta( get_the_id(), '_views_count', true ); /* count meta views */
update_post_meta( get_the_id(), '_views_count', ++$meta_views_count );
/* End manage post views count */

w3construct_get_post_banner();

/* Showing the post template for frontend */
get_template_part( 'dz-inc/elements/post_template/post-standard' );

wp_reset_postdata();
get_footer();
