<?php
/**
 * The Template for displaying default search form
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

$search_value = '';
if ( isset( $_GET['search_form_nonce'] ) && wp_verify_nonce( sanitize_title( wp_unslash( $_GET['search_form_nonce'] ) ), 'search_form_action' ) ) {
	$search_value = ( ! empty( $_GET['s'] ) ) ? sanitize_title( wp_unslash( $_GET['s'] ) ) : '';
}
?>
<!-- Search -->
<div class="search-bx">
	<form method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php wp_nonce_field( 'search_form_action', 'search_form_nonce' ); ?>
		<div class="input-group">
			<input type="search" name="s" class="form-control" value="<?php echo esc_attr( $search_value ); ?>"
				placeholder="<?php esc_attr_e( 'Search Here', 'w3construct' ); ?>" required>
			<span class="input-group-append search-btn">
				<button type="submit" class="btn btn-primary sharp radius-no">
					<i class="la la-search scale3"></i>
				</button>
			</span>
		</div>
	</form>
</div>
