<?php
/**
 * The Template for displaying default search
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

get_header();

global $w3construct_option;

$show_sidebar            = w3construct_set( $w3construct_option, 'show_sidebar' );
$layout                  = w3construct_set( $w3construct_option, 'layout' );
$sidebar                 = w3construct_set( $w3construct_option, 'sidebar' );
$page_title              = w3construct_set( $w3construct_option, 'page_title' );
$disable_ajax_pagination = w3construct_set( $w3construct_option, 'disable_ajax_pagination' );
$queried_object_data     = $wp_query;
$total_post_count        = $queried_object_data->found_posts;
$layout                  = ( ! $show_sidebar ) ? 'full' : $layout;

$page_title = ( ! empty( $queried_object_data->query_vars['s'] ) ) ? $page_title . '<span>' . $queried_object_data->query_vars['s'] . '</span>' : $page_title;

if ( 'full' === $layout || ! is_active_sidebar( $sidebar ) || ! w3construct_is_theme_sidebar_active() ) {
	$layout_class = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12';
} else {
	$layout_class = 'col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12';
}

set_query_var( 'queried_object_data', $queried_object_data );

w3construct_get_banner();

?>
<div class="section-full bg-white content-inner">
	<div class="container">
		<div class="row">
			<?php if ( $show_sidebar && 'left' === $layout && is_active_sidebar( $sidebar ) && w3construct_is_theme_sidebar_active() ) { ?>
				<div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
					<div class="side-bar p-r30 sticky-top">
						<?php dynamic_sidebar( $sidebar ); ?>
					</div>
				</div>
			<?php } ?>

			<div class="<?php echo esc_attr( $layout_class ); ?>">
				<div class="row">
					<div class="col-lg-12 wow fadeInUp" data-wow-duration="2s" data-wow-delay="0.4s">
						<div class="search-bx m-b50">
							<?php get_search_form(); ?>
							<p>
								<?php esc_html_e( 'If you are not happy with the results, please do another search', 'w3construct' ); ?>
							</p>
						</div>
					</div>
				</div>
				<?php
				if ( have_posts() ) {
					if ( $disable_ajax_pagination ) {
						get_template_part( 'dz-inc/elements/searches-pages-ajax-posts-element' );
					} else {
						get_template_part( 'dz-inc/elements/searches-pages-pagination-posts-element' );
					}
				} else {
					get_template_part( 'dz-inc/elements/no-record-found-element' );
				}
				?>
			</div>
			<?php if ( $show_sidebar && 'right' === $layout && is_active_sidebar( $sidebar ) && w3construct_is_theme_sidebar_active() ) { ?>
				<div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
					<div class="side-bar p-l30 sticky-top">
						<?php dynamic_sidebar( $sidebar ); ?>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
<?php
wp_reset_postdata();
get_footer();
