<?php
/**
 * The Template for displaying w3construct page php
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

get_header();
global $w3construct_option;

$show_sidebar = w3construct_set( $w3construct_option, 'show_sidebar' );
$layout       = w3construct_set( $w3construct_option, 'layout' );
$sidebar      = w3construct_set( $w3construct_option, 'sidebar' );
$layout       = ( ! $show_sidebar ) ? 'full' : $layout;

if ( 'full' === $layout || ! is_active_sidebar( $sidebar ) ) {
	$classes       = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12';
	$content_class = '';
} else {
	$classes       = 'col-lg-8 col-md-12 m-b10 ';
	$content_class = 'sidebar';
}

w3construct_get_banner();

?>
<div class="section-full bg-white content-inner">
	<div class="container">
		<div class="row">
			<!-- Left sidebar area -->
			<?php if ( 'left' === $layout && is_active_sidebar( $sidebar ) && w3construct_is_theme_sidebar_active() ) { ?>
				<div class="col-xl-4 col-lg-4 m-b30">
					<div class="side-bar sticky-top">
						<?php dynamic_sidebar( $sidebar ); ?>
					</div>
				</div>
			<?php } ?>

			<div class="<?php echo esc_attr( $classes ); ?>">
				<?php
				while ( have_posts() ) {
					the_post();
					?>
					<div class="dz-page-text <?php echo esc_attr( $content_class ); ?>">
						<?php the_content(); ?>
						<div class="clearfix"></div>
					</div>
					<?php
				}
				comments_template();
				wp_link_pages(
					array(
						'before'      => '<div class="paginate-links">' . esc_html__( 'Pages: ', 'w3construct' ),
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
					)
				);
				?>
			</div>

			<!-- Right sidebar area -->
			<?php if ( 'right' === $layout && is_active_sidebar( $sidebar ) ) { ?>
				<div class="col-xl-4 col-lg-4 m-b30">
					<div class="side-bar sticky-top">
						<?php dynamic_sidebar( $sidebar ); ?>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
<?php
get_footer();
