<?php
/**
 * The Template for displaying w3construct index page
 * Default Page Settings managed by Theme Option
 *
 * @package   W3Construct
 * @author    W3ITEXPERTS
 * @copyright Copyright (c) 2023, W3Construct
 * @link      http://w3construct-wordpress.wprdx.come/demo/
 * @since     W3Construct 1.0.1
 */

get_header();
global $w3construct_option;
$website_status          = w3construct_set( $w3construct_option, 'website_status' );
$show_sidebar            = w3construct_set( $w3construct_option, 'show_sidebar' );
$layout                  = w3construct_set( $w3construct_option, 'layout' );
$sidebar                 = w3construct_set( $w3construct_option, 'sidebar' );
$disable_ajax_pagination = w3construct_set( $w3construct_option, 'disable_ajax_pagination' );

if ( is_website_ready_for_visitor( $website_status ) ) {

	$layout = ( ! $show_sidebar ) ? 'full' : $layout;

	if ( 'full' === $layout || ! is_active_sidebar( $sidebar ) || ! w3construct_is_theme_sidebar_active() ) {
		$layout_class = 'col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12';
	} else {
		$layout_class = 'col-xl-8 col-lg-8 col-md-12 col-sm-12 col-12';
	}

	w3construct_get_banner();
	?>
<div class="section-full bg-white content-inner">
	<div class="container">
		<div class="row">
			<?php if ( $show_sidebar && 'left' === $layout && is_active_sidebar( $sidebar ) && w3construct_is_theme_sidebar_active() ) { ?>
				<!-- Left sidebar area -->
				<div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
					<div class="side-bar sticky-top">
						<?php dynamic_sidebar( $sidebar ); ?>
						<div class="clearfix"></div>
					</div>
				</div>
			<?php } ?>

			<!--Content Side-->
			<div class="<?php echo esc_attr( $layout_class ); ?>">
				<?php
				if ( have_posts() ) {
					if ( 'load_more' === $disable_ajax_pagination ) {
						get_template_part( 'dz-inc/elements/index-page-ajax-posts-element' );
					} else {
						get_template_part( 'dz-inc/elements/index-page-pagination-posts-element' );

						/* Pagination start */
						w3construct_the_pagination();
						/* Pagination END */
					}
				} else {
					get_template_part( 'dz-inc/elements/no-record-found-element' );
				}
				?>
			</div>
			<!-- End Content Side-->

			<!-- Right sidebar area -->
			<?php if ( $show_sidebar && 'right' === $layout && is_active_sidebar( $sidebar ) && w3construct_is_theme_sidebar_active() ) { ?>
				<div class="col-xl-4 col-lg-4 col-md-12 col-sm-12 col-12">
					<div class="side-bar sticky-top">
						<?php dynamic_sidebar( $sidebar ); ?>
						<div class="clearfix"></div>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</div>
	<?php
}
get_footer();
