<?php
/**
 * Used the header for all page
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

w3construct_bunch_global_variable();

global $w3construct_option;

$site_favicon   = w3construct_set( $w3construct_option, 'site_favicon' );
$website_status = w3construct_set( $w3construct_option, 'website_status' );
$header_style   = w3construct_set( $w3construct_option, 'header_style' );

?>
<!DOCTYPE html>
<html
	<?php
		language_attributes();
		theme_direction();
	?>
>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) { ?>
		<link rel="Site Icon" href="<?php echo esc_url( $site_favicon ); ?>" type="image/x-icon">
	<?php } ?>
	<!-- Responsive -->
	<meta http-equiv="X-UA-Compatible" content="IE=edge">

	<!-- MOBILE SPECIFIC -->
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

	<?php wp_head(); ?>
</head>
<body id="bg" 
	<?php
		body_class();
		w3construct_body_layout_style();
	?>
>
	<?php
	wp_body_open();

	do_action( 'w3construct_subscription' );
	?>
	<a class="skip-link screen-reader-text" href="#content">
	<?php echo esc_html__( 'Skip to content', 'w3construct' ); ?></a>
	<div class="page-wraper" id="page">
		<?php
		if ( is_website_ready_for_visitor( $website_status ) ) {
			/* Pre-loader */
			w3construct_get_loader();
			/* Pre-loader END */
			if ( ! empty( $header_style ) ) {
				get_template_part( 'dz-inc/elements/header/' . $header_style );
			}
		}
		?>
		<div class="page-content" id="content">
			<?php
			do_action( 'w3construct_website_status' );
