<?php
/**
 * W3construct functions and definitions
 *
 * @link http://w3construct-wordpress.wprdx.come/demo/
 * @author      W3ITEXPERTS
 * @copyright   Copyright ( c ) 2023, W3Construct
 * @package W3construct
 * @since 1.0.3
 */

add_action( 'after_setup_theme', 'w3construct_bunch_theme_setup' );

/**
 * Sets up the theme and initializes theme-specific functionality.
 */
function w3construct_bunch_theme_setup() {
	global $wp_version_w3;
	$theme = wp_get_theme();
	if ( ! defined( 'W3CONSTRUCT_VERSION' ) ) {
		define( 'W3CONSTRUCT_VERSION', '1.0' );
	}
	if ( ! defined( 'W3CONSTRUCT_ROOT' ) ) {
		define( 'W3CONSTRUCT_ROOT', get_template_directory() . '/' );
	}
	if ( ! defined( 'W3CONSTRUCT_URL' ) ) {
		define( 'W3CONSTRUCT_URL', get_template_directory_uri() . '/' );
	}
	if ( ! defined( 'W3CONSTRUCT_COMINGSOON' ) ) {
		define( 'W3CONSTRUCT_COMINGSOON', get_template_directory_uri() . '/assets/images/bg1.jpg' );
	}
	if ( ! defined( 'W3CONSTRUCT_MAINTENANCE' ) ) {
		define( 'W3CONSTRUCT_MAINTENANCE', get_template_directory_uri() . '/assets/images/bg2.jpg' );
	}
	if ( ! defined( 'W3CONSTRUCT_MAINTENANCE_VLC' ) ) {
		define( 'W3CONSTRUCT_MAINTENANCE_VLC', get_template_directory_uri() . '/assets/images/vlc.png' );
	}
	if ( ! defined( 'W3CONSTRUCT_DEFAULT_LOGO' ) ) {
		define( 'W3CONSTRUCT_DEFAULT_LOGO', get_template_directory_uri() . '/assets/images/logo.png' );
	}
	if ( ! defined( 'W3CONSTRUCT_DEFAULT_WHITE_LOGO' ) ) {
		define( 'W3CONSTRUCT_DEFAULT_WHITE_LOGO', get_template_directory_uri() . '/assets/images/logo.png' );
	}
	if ( ! defined( 'W3CONSTRUCT_DEFAULT_TEXT_LOGO' ) ) {
		define( 'W3CONSTRUCT_DEFAULT_TEXT_LOGO', $theme->get( 'Name' ) );
	}
	if ( ! defined( 'W3CONSTRUCT_DEFAULT_TAG' ) ) {
		define( 'W3CONSTRUCT_DEFAULT_TAG', esc_html__( 'Personal Blog', 'w3construct' ) );
	}
	if ( ! defined( 'W3CONSTRUCT_BANNER' ) ) {
		define( 'W3CONSTRUCT_BANNER', get_template_directory_uri() . '/assets/images/bnr4.jpg' );
	}
	if ( ! defined( 'W3CONSTRUCT_COPYWRITE_TEXT' ) ) {
		define( 'W3CONSTRUCT_COPYWRITE_TEXT', esc_html__( '© 2024 All Rights Reserved . ', 'w3construct' ) );
	}
	if ( ! defined( 'W3CONSTRUCT_FAVICON' ) ) {
		define( 'W3CONSTRUCT_FAVICON', get_template_directory_uri() . '/assets/images/favicon.png' );
	}

	include_once get_template_directory() . '/dz-inc/loader.php';

	load_theme_textdomain( 'w3construct', get_template_directory() . '/languages' );

	/* custom logo pass arge  */
	$logo_settings = array(
		'flex-width'  => true,
		'flex-height' => true,
		'height'      => 50,
		'width'       => 200,
	);

	/*	ADD THUMBNAIL SUPPORT	*/
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'automatic-feed-links' ); /* Enables post and comment RSS feed links to head. */
	add_theme_support( 'widgets' ); /* Add widgets and sidebar support */
	add_theme_support( 'custom-header' );
	add_theme_support( 'custom-logo' );
	add_theme_support( 'custom-background' );
	add_theme_support( 'wp-block-styles' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'editor-styles' );
	add_theme_support( 'responsive-embeds' );
	add_theme_support( 'woocommerce' ); /* Enable woo-commerce page template */
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'register_block_pattern' );
	add_theme_support( 'register_block_style' );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		)
	);

	/** Register wp_nav_menus */
	if ( function_exists( 'register_nav_menu' ) ) {
		register_nav_menus(
			array(
				/** Register Main Menu location header */
				'main_menu'     => esc_html__( 'Main Menu', 'w3construct' ),
				'one_page_menu' => esc_html__( 'One Page Menu', 'w3construct' ),
				'footer_menu'   => esc_html__( 'Footer Menu', 'w3construct' ),
			)
		);
	}
	if ( ! isset( $content_width ) ) {
		$content_width = 960;
	}
		/** Image Size Setting For W3Construct */

		/*** Post Images */
		add_image_size( 'w3construct_1800x700', 1800, 700, true ); /* Project */
		add_image_size( 'w3construct_555x400', 555, 400, true ); /* Blog Grid, List */

		/* Change default image thumbnail sizes in WordPress */

		/* Thumbnail */
		update_option( 'thumbnail_size_w', 200 ); /* Testimonial, Recent Post */
		update_option( 'thumbnail_size_h', 200 );
		update_option( 'thumbnail_crop', 1 );

		/* Medium */
		update_option( 'medium_size_w', 500 ); /* Team */
		update_option( 'medium_size_h', 700 );
		update_option( 'medium_crop', 1 );

		/* Large */
		update_option( 'large_size_w', 1000 ); /* Blog */
		update_option( 'large_size_h', 600 );
		update_option( 'large_crop', 1 );
		/** Image Size Setting For W3Construct END */
}

/**
 *
 * Register theme sidebar blog, footer and dynamic
 * "substitute-class" using for replace required class dynamically.
 */
function w3construct_sidebar() {
	global $wp_registered_sidebars;

	register_sidebar(
		array(
			'name'          => esc_html__( 'Blog Sidebar', 'w3construct' ),
			'id'            => 'dz_blog_sidebar',
			'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side . ', 'w3construct' ),
			'before_widget' => '<div id="%1$s" class="widget sidebar-widget %2$s substitute-class">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-title"><h4 class="title">',
			'after_title'   => '</h4><div class="dz-separator style-1 text-primary mb-0"></div></div>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Sidebar', 'w3construct' ),
			'id'            => 'dz_footer_sidebar',
			'description'   => esc_html__( 'Widgets in this area will be shown in Footer Area . ', 'w3construct' ),
			'before_widget' => '<div id="%1$s" class="widget col-lg-3 col-md-6  %2$s substitute-class footer-sidebar-1">',
			'after_widget'  => '</div>',
			'before_title'  => '<div class="widget-title"><h4 class = "title">',
			'after_title'   => '</h4><div class="dz-separator style-1 text-primary mb-0"></div></div>',
		)
	);
	if ( class_exists( 'ReduxFramework' ) ) {

		$sidebar_input_arr = w3construct_get_opt( 'new_sidebar_input' );

		if ( ! empty( $sidebar_input_arr[0] ) ) {
			foreach ( $sidebar_input_arr as $sidebar_input ) {
				$sidebar_id = str_replace( ' ', '_', $sidebar_input );

				register_sidebar(
					array(
						'name'          => ucfirst( $sidebar_input ),
						'id'            => sanitize_title( 'dz_' . $sidebar_id ),
						'description'   => esc_html__( 'Widgets in this area will be shown on the right-hand side . ', 'w3construct' ),
						'before_widget' => '<div id="%1$s" class="widget ext-sidebar-menu sidebar-widget %2$s substitute-class">',
						'after_widget'  => '</div>',
						'before_title'  => '<h4 class="title">',
						'after_title'   => '</h4>',
					)
				);
			}
		}
	}

	update_option( 'wp_registered_sidebars', $wp_registered_sidebars );
}
add_action( 'widgets_init', 'w3construct_sidebar' );


/**
 * Add google map and google recaptcha script on page.
 */
function w3construct_load_head_scripts() {
	$options = w3construct_dzbase()->option();
	if ( ! is_admin() ) {
		$protocol    = is_ssl() ? 'https: //' : 'http: //';
		$map_api_key = w3construct_set( $options, 'map_api_key' );

		if ( ! empty( $map_api_key ) ) {
			$map_path = '?key=' . w3construct_set( $options, 'map_api_key' );
			wp_enqueue_script( 'w3construct-map-api', $protocol . 'maps.google.com/maps/api/js' . $map_path, array(), wp_version(), false );
			wp_enqueue_script( 'w3construct-recaptcha-api ', $protocol . 'google.com/recaptcha/api.js', array(), wp_version(), false );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'w3construct_load_head_scripts' );


/**
 * Enqueue Scripts on plugin
 */
add_action( 'admin_enqueue_scripts', 'w3construct_admin_script' );

/**
 * Function register admin on plugin
 */
function w3construct_admin_script() {
	if ( is_admin() ) {
		wp_enqueue_style( 'admin-style', get_template_directory_uri() . '/dz-inc/admin/css/admin.css', array(), '1.0.0' );
		wp_enqueue_style( 'admin-font-awesome', get_template_directory_uri() . '/dz-inc/admin/css/font-awesome-min.css', array(), '4.7.0' );
	}
}

/**
 * Check if a WordPress plugin is active.
 *
 * This function checks if a specific plugin is active in WordPress by comparing its folder/file name
 * to the list of active plugins.
 *
 * @param string $plugin The folder/file name of the plugin (e.g., 'my-plugin/my-plugin.php').
 *
 * @return bool True if the plugin is active, false otherwise.
 */
function w3construct_plugin_active( $plugin ) {
	$active_plugins = apply_filters( 'active_plugins', get_option( 'active_plugins' ) );
	if ( ! empty( $plugin ) && ! empty( $active_plugins ) && in_array( $plugin, $active_plugins, true ) ) {
		return true;
	} else {
		return false;
	}
}

/**
 * Add theme global variables
 */
function w3construct_bunch_global_variable() {
	global $w3construct_option;

	if ( w3construct_plugin_active( 'redux-framework/redux-framework.php' ) ) {
		$options = w3construct_dzbase()->option();
	} else {
		$options = array();
	}

	$dz_res = array();

	$dz_res['allowed_html_tags']    = wp_kses_allowed_html( 'post' );
	$dz_res['website_status']       = w3construct_set( $options, 'website_status', 'live_mode' );
	$dz_res['website_status']       = w3construct_set( $options, 'website_status', 'live_mode' );
	$dz_res['theme_corner']         = w3construct_set( $options, 'theme_corner', 'rounded' );
	$dz_res['theme_corner_rounded'] = w3construct_set( $options, 'theme_corner_rounded', 'rounded' );
	$dz_res['site_logo_icon']       = ! empty( $dz_res['site_logo_icon']['url'] ) ? $dz_res['site_logo_icon']['url'] : get_template_directory_uri() . '/assets/images/logo-icon.png';
	$dz_res['theme_date_format']    = ! empty( $options['theme_date_format'] ) ? $options['theme_date_format'] : '';

	if ( function_exists( 'w3construct_get_ws_data' ) ) {
		$extra_ws_data = w3construct_get_ws_data( $options );
		$dz_res        = array_merge( $dz_res, $extra_ws_data );
	}

	/* stuff : header.php  */
	$dz_res['site_favicon'] = isset( $options['favicon'] ) ? w3construct_set( $options['favicon'], 'url', W3CONSTRUCT_FAVICON ) : W3CONSTRUCT_FAVICON;

	/* preloading image */
	$dz_res['page_loading_on']      = w3construct_set( $options, 'page_loading_on' );
	$dz_res['theme_corner']         = w3construct_set( $options, 'theme_corner', 'rounded' );
	$dz_res['theme_corner_rounded'] = w3construct_set( $options, 'theme_corner_rounded', 'rounded' );
	$dz_res['page_loader_type']     = w3construct_set( $options, 'page_loader_type' );

	if ( '1' === $dz_res['page_loading_on'] ) {
		if ( 'loading_image' === $dz_res['page_loader_type'] ) {
			if ( ! empty( $options['custom_page_loader_image']['url'] ) ) {
				$dz_res['preloader'] = $options['custom_page_loader_image']['url'];
			} else {
				$page_loader_image   = w3construct_set( $options, 'page_loader_image', '' );
				$dz_res['preloader'] = get_template_directory_uri() . '/dz-inc/assets/images/loading-images/' . $page_loader_image . '.svg';
			}
		} elseif ( 'advanced_loader' === $dz_res['page_loader_type'] ) {
			$dz_res['preloader']                  = w3construct_set( $options, 'advanced_page_loader_image', '' );
			$dz_res['advanced_page_loader_title'] = w3construct_set( $options, 'advanced_page_loader_title', '' );

		}
	}
	/* Get header & footer settings */
	$dz_res['header_style']  = w3construct_set( $options, 'header_style', 'header-1' );
	$dz_res['footer_style']  = w3construct_set( $options, 'footer_style', 'footer_template_2' );
	$dz_res['footer_on']     = w3construct_set( $options, 'footer_on', true );
	$header_setting_meta_key = '';
	$footer_setting_meta_key = '';
	/* Get Header & Footer: According to CPT */
	if ( is_page() ) {
		$header_setting_meta_key = 'page_header_setting';
		$header_style_meta_key   = 'page_header_style';

		$footer_setting_meta_key = 'page_footer_setting';
		$footer_style_meta_key   = 'page_footer_style';
		$footer_on_meta_key      = 'page_footer_on';
	} elseif ( is_singular( 'dz_service' ) ) {
		$header_setting_meta_key = 'service_page_header_setting';
		$header_style_meta_key   = 'service_page_header_style';

		$footer_setting_meta_key = 'service_page_footer_setting';
		$footer_style_meta_key   = 'service_page_footer_style';
		$footer_on_meta_key      = 'service_page_footer_on';
	} elseif ( is_singular( 'dz_portfolio' ) ) {
		$header_setting_meta_key = 'portfolio_page_header_setting';
		$header_style_meta_key   = 'portfolio_page_header_style';

		$footer_setting_meta_key = 'portfolio_page_footer_setting';
		$footer_style_meta_key   = 'portfolio_page_footer_style';
		$footer_on_meta_key      = 'portfolio_page_footer_on';
	} elseif ( is_single() ) {
		$header_setting_meta_key = 'post_header_setting';
		$header_style_meta_key   = 'post_header_style';

		$footer_setting_meta_key = 'post_footer_setting';
		$footer_style_meta_key   = 'post_footer_style';
		$footer_on_meta_key      = 'post_footer_on';
	}

	$header_setting = w3construct_dzbase()->get_meta( $header_setting_meta_key );
	$header_setting = ! empty( $header_setting ) ? $header_setting : 'theme_default';
	if ( 'custom' === $header_setting ) {
		$header_style           = w3construct_dzbase()->get_meta( $header_style_meta_key );
		$dz_res['header_style'] = ! empty( $header_style ) ? $header_style : $dz_res['header_style'];
	}

	$footer_setting = w3construct_dzbase()->get_meta( $footer_setting_meta_key );
	$footer_setting = ! empty( $footer_setting ) ? $footer_setting : 'theme_default';
	if ( 'custom' === $footer_setting ) {
		$footer_style           = w3construct_dzbase()->get_meta( $footer_style_meta_key );
		$dz_res['footer_on']    = w3construct_dzbase()->get_meta( $footer_on_meta_key );
		$dz_res['footer_style'] = ! empty( $footer_style ) ? $footer_style : $dz_res['footer_style'];
	}

	/* Get Header & Footer: According to CPT END */

	$dz_res['header_style_class']      = ( 'header_3' === $dz_res['header_style'] ) ? 'header-transparent' : '';
	$dz_res['header_login_on']         = w3construct_set( $options, 'header_login_on' );
	$dz_res['header_register_on']      = w3construct_set( $options, 'header_register_on' );
	$dz_res['header_sticky_on']        = w3construct_set( $options, 'header_sticky_on' );
	$dz_res['show_website_search']     = w3construct_set( $options, 'show_website_search', true );
	$dz_res['show_login_registration'] = w3construct_set( $options, 'show_login_registration' );
	$dz_res['show_social_icon']        = w3construct_set( $options, 'show_social_icon' );
	$dz_res['header_sticky_class']     = ( $dz_res['header_sticky_on'] ) ? 'sticky-header' : '';

	$dz_res['header_location_on'] = w3construct_set( $options, $dz_res['header_style'] . '_location_on', true );
	$dz_res['site_phone_number']  = w3construct_set( $options, 'site_phone_number' );
	$dz_res['site_address']       = w3construct_set( $options, 'site_address' );
	$dz_res['site_skype']         = w3construct_set( $options, 'site_skype' );
	$dz_res['site_email']         = w3construct_set( $options, 'site_email' );

	$dz_res['header_search_on']           = w3construct_set( $options, $dz_res['header_style'] . '_search_on', true );
	$dz_res['header_search_button_title'] = w3construct_set( $options, $dz_res['header_style'] . '_search_button_title', esc_html__( 'Search', 'w3construct' ) );
	$dz_res['header_social_link_on']      = w3construct_set( $options, $dz_res['header_style'] . '_social_link_on' );
	$dz_res['header_social_links']        = w3construct_set( $options, $dz_res['header_style'] . '_social_links' );
	$dz_res['header_top_bar_on']          = w3construct_set( $options, $dz_res['header_style'] . '_top_bar_on' );
	$dz_res['header_author_banner_on']    = w3construct_set( $options, $dz_res['header_style'] . '_author_banner_on' );
	$dz_res['header_theme']               = w3construct_set( $options, $dz_res['header_style'] . '_header_theme' );
	$dz_res['header_banner_bg_image']     = w3construct_set( $options, $dz_res['header_style'] . '_banner_bg_image' );
	$dz_res['header_banner_bg_image']     = ! empty( $dz_res['header_banner_bg_image']['url'] ) ? $dz_res['header_banner_bg_image']['url'] : '';

	/* Manage header Subscription Form */
	$dz_res['header_subscribe_on'] = w3construct_set( $options, 'header_subscribe_on' );

	/* End Manage Subscription Form */

	/* Manage Sidebar About */
	$dz_res['header_about_on']    = w3construct_set( $options, 'header_about_on' );
	$dz_res['header_about_title'] = w3construct_set( $options, 'header_about_title' );
	$dz_res['header_about_url']   = w3construct_set( $options, 'header_about_url', '' );
	$dz_res['header_about_desc']  = w3construct_set( $options, 'header_about_desc' );
	/* Manage Sidebar About */

	$header_style_options = w3construct_header_style_options();
	foreach ( $header_style_options as $header ) {
		$call_to_action_button = w3construct_set( $header['param'], 'call_to_action_button', 0 );

		if ( $call_to_action_button > 0 ) {
			for ( $i = 1; $i <= $call_to_action_button; $i++ ) {
				$dz_res[ 'header_button_' . $i . '_text' ]   = w3construct_set( $options, $dz_res['header_style'] . '_button_' . $i . '_text', '' );
				$dz_res[ 'header_button_' . $i . '_url' ]    = w3construct_set( $options, $dz_res['header_style'] . '_button_' . $i . '_url', '' );
				$dz_res[ 'header_button_' . $i . '_target' ] = w3construct_set( $options, $dz_res['header_style'] . '_button_' . $i . '_target', '' );
			}
		}
	}

	$dz_res['mobile_header_login_on']       = w3construct_set( $options, 'mobile_header_login_on', '' );
	$dz_res['mobile_header_register_on']    = w3construct_set( $options, 'mobile_header_register_on', '' );
	$dz_res['mobile_header_social_link_on'] = w3construct_set( $options, $dz_res['header_style'] . '_mobile_social_link_on', '' );
	$dz_res['mobile_search_on']             = w3construct_set( $options, $dz_res['header_style'] . '_mobile_search_on', '' );

	$dz_res['social_link_target'] = w3construct_set( $options, 'social_link_target', '' );
	/* header settings END */

	/* Footer Settings Starts */
	$dz_res['footer_subscribe_on'] = w3construct_set( $options, 'footer_subscribe_on', false );

	$dz_res['footer_subscription_section'] = w3construct_set( $options, 'footer_subscription_section', false );
	$dz_res['subscription_section_image']  = w3construct_set( $options, 'subscription_section_image' );
	$dz_res['subscription_section_desc']   = w3construct_set( $options, 'subscription_section_desc', esc_html__( 'Sed laoreet orci id pretium sodales. Nunc ac est dolor. Donec placerat dolor et mi elementum, in suscipit libero tincidunt. Ut at tempor ex, vel auctor tortor. Sed finibus vitae mi et imperdiet . ', 'w3construct' ) );
	$dz_res['subscription_section_email']  = w3construct_set( $options, 'subscription_section_email', esc_html__( 'info@w3itexperts.COM', 'w3construct' ) );

	$dz_res['footer_top'] = w3construct_set( $options, 'footer_top', false );

	$dz_res['footer_bg_image']       = w3construct_set( $options, $dz_res['footer_style'] . '_bg_image' );
	$dz_res['footer_social_on']      = w3construct_set( $options, $dz_res['footer_style'] . '_social_on' );
	$dz_res['footer_copyright_text'] = isset( $options['footer_copyright_text'] ) ? w3construct_set( $options, 'footer_copyright_text', W3CONSTRUCT_COPYWRITE_TEXT ) : W3CONSTRUCT_COPYWRITE_TEXT;

	/* Footer Params Actions */
	$footer_style_options = w3construct_footer_style_options();
	foreach ( $footer_style_options as $footer ) {
		$call_to_action_button = w3construct_set( $footer['param'], 'call_to_action_button', 0 );
		$bg_image              = w3construct_set( $footer['param'], 'bg_image', 0 );

		if ( $call_to_action_button > 0 ) {
			for ( $i = 1; $i <= $call_to_action_button; $i++ ) {
				$dz_res[ 'footer_button_' . $i . '_text' ]   = w3construct_set( $options, $dz_res['footer_style'] . '_button_' . $i . '_text', '' );
				$dz_res[ 'footer_button_' . $i . '_url' ]    = w3construct_set( $options, $dz_res['footer_style'] . '_button_' . $i . '_url', '' );
				$dz_res[ 'footer_button_' . $i . '_target' ] = w3construct_set( $options, $dz_res['footer_style'] . '_button_' . $i . '_target', '' );
			}
		}
	}
	/* Footer Params Actions END */

	/* Footer Instagram Settings */
	$dz_res['footer_top_feeds'] = w3construct_set( $options, 'footer_top_feeds', 'normal_feeds' );
	if ( 'instagram_feeds' === $dz_res['footer_top_feeds'] ) {
		$dz_res['instagram_shortcode']       = w3construct_set( $options, 'instagram_shortcode' );
		$dz_res['footer_instagram_title']    = w3construct_set( $options, 'footer_instagram_title' );
		$dz_res['footer_instagram_link']     = w3construct_set( $options, 'footer_instagram_link' );
		$dz_res['footer_instagram_btn_text'] = w3construct_set( $options, 'footer_instagram_btn_text' );
	}
	$dz_res['scroll_menu_pages']        = w3construct_set( $options, 'scroll_menu_pages' );
	$dz_res['center_scroll_menu_pages'] = w3construct_set( $options, 'center_scroll_menu_pages' );
	/* Footer Instagram Settings END */

	/* Footer Settings Starts END */

	/* logo setting, adition logo settings for 'site_other_logo' for w3construct theme */
	$dz_res['logo_type']  = w3construct_set( $options, 'logo_type', 'text_logo' );
	$dz_res['logo_title'] = w3construct_set( $options, 'logo_title', W3CONSTRUCT_DEFAULT_TEXT_LOGO );
	$dz_res['tag_line']   = w3construct_set( $options, 'tag_line', W3CONSTRUCT_DEFAULT_TAG );

	$dz_res['logo_alt'] = w3construct_set( $options, 'logo_alt', W3CONSTRUCT_DEFAULT_TEXT_LOGO );

	if ( isset( $options['logo_type'] ) && 'image_logo' === $options['logo_type'] ) {
		$dz_res['logo'] = ( 'header_2' === $dz_res['header_style'] ) ? w3construct_set( $options['site_other_logo'], 'url', W3CONSTRUCT_DEFAULT_WHITE_LOGO ) : w3construct_set( $options['site_logo'], 'url', W3CONSTRUCT_DEFAULT_LOGO );
	} elseif ( isset( $options['logo_type'] ) && 'text_logo' === $options['logo_type'] ) {
		$dz_res['logo_text']  = w3construct_set( $dz_res, 'logo_text', W3CONSTRUCT_DEFAULT_TEXT_LOGO );
		$dz_res['logo_title'] = w3construct_set( $options, 'logo_title', W3CONSTRUCT_DEFAULT_TEXT_LOGO );
	} else {
		$dz_res['logo'] = W3CONSTRUCT_DEFAULT_LOGO;
	}

	$dz_res['site_logo'] = isset( $options['site_logo'] ) ? w3construct_set( $options['site_logo'], 'url', W3CONSTRUCT_DEFAULT_LOGO ) : W3CONSTRUCT_DEFAULT_LOGO;

	$dz_res['site_other_logo'] = isset( $options['site_other_logo'] ) ? w3construct_set( $options['site_other_logo'], 'url', W3CONSTRUCT_DEFAULT_WHITE_LOGO ) : W3CONSTRUCT_DEFAULT_WHITE_LOGO;

	$dz_res['ratina_logo']        = isset( $options['ratina_logo'] ) ? w3construct_set( $options['ratina_logo'], 'url', '' ) : '';
	$dz_res['mobile_logo']        = isset( $options['mobile_logo'] ) ? w3construct_set( $options['mobile_logo'], 'url', '' ) : '';
	$dz_res['ratina_mobile logo'] = isset( $options['ratina_mobile_logo'] ) ? w3construct_set( $options['ratina_mobile_logo'], 'url', '' ) : '';
	/* End logo setting  */

	/** Assigning values for better variable readability */
	$dz_res['show_search_button']       = $dz_res['header_search_on'];
	$dz_res['search_button_title']      = $dz_res['header_search_button_title'];
	$dz_res['hide_social_icons_mobile'] = $dz_res['mobile_header_social_link_on'];

	/* Post general setting */
	$dz_res['post_layout']      = w3construct_set( $options, 'post_general_layout', 'standard' );
	$dz_res['post_view_on']     = w3construct_set( $options, 'post_view_on' );
	$dz_res['post_start_view']  = w3construct_set( $options, 'post_start_view', 1 );
	$dz_res['pre_next_post_on'] = w3construct_set( $options, 'pre_next_post_on' );
	$dz_res['comment_view_on']  = w3construct_set( $options, 'comment_view_on' );
	$dz_res['featured_img_on']  = w3construct_set( $options, 'featured_img_on' );
	$dz_res['featured_img_on']  = w3construct_set( $options, 'featured_img_on' );
	/* Post general setting end */

	/* Page banner setting */
	$dz_res['show_banner']          = isset( $options['page_general_banner_on'] ) ? $options['page_general_banner_on'] : true;
	$dz_res['banner_type']          = 'image';
	$dz_res['banner_height']        = w3construct_set( $options, 'page_general_banner_height', 'page_banner_big' );
	$dz_res['banner_custom_height'] = w3construct_set( $options, 'page_general_banner_custom_height', '100' );
	$dz_res['banner_image']         = isset( $options['page_general_banner'] ) ? w3construct_set( $options['page_general_banner'], 'url', W3CONSTRUCT_BANNER ) : W3CONSTRUCT_BANNER;
	/* End Page banner setting */

	/* Sidebar and there layout */
	$dz_res['layout']       = 'right';
	$dz_res['sidebar']      = 'dz_blog_sidebar';
	$dz_res['show_sidebar'] = w3construct_set( $options, 'page_general_show_sidebar', true );
	if ( $dz_res['show_sidebar'] ) {
		$dz_res['layout']  = w3construct_set( $options, 'page_general_sidebar_layout', 'right' );
		$dz_res['sidebar'] = w3construct_set( $options, 'page_general_sidebar', 'dz_blog_sidebar' );
	}
	/* End Sidebar and there layout */

	$pagination                        = w3construct_set( $options, 'page_general_paging', 'default' );
	$dz_res['disable_ajax_pagination'] = ( 'load_more' === $pagination ) ? $pagination : '';
	/** Assigning values for better variable readability end */

	$home_pagetemp = $dz_res;

	/*
	*
	* get page option in theme
	* page.php
	*
	*/
	if ( is_page() ) {

		$page_level_keys = array(
			'page_header_setting',
			'page_header_style',
			'page_header_theme',
			'page_banner_height',
			'page_banner_on',
			'page_banner_hide',
			'page_banner',
			'banner_image',
			'page_show_sidebar',
			'page_sidebar_layout',
			'page_sidebar',
			'page_footer_setting',
			'page_footer_style',
		);

		foreach ( $page_level_keys as $value ) {
			$page_settings[ $value ] = w3construct_dzbase( $page_level_keys )->get_meta( $value );
		}

		/* Header & Logo Setting */
		$dz_res['header_top_bar_on'] = w3construct_set( $options, $dz_res['header_style'] . '_top_bar_on' );
		$dz_res['header_search_on']  = w3construct_set( $options, $dz_res['header_style'] . '_search_on', true );
		/* End Header & Logo Setting */

		$page_header_setting = ! empty( $page_settings['page_header_setting'] ) ? $page_settings['page_header_setting'] : 'theme_default';
		if ( 'custom' === $page_header_setting ) {
			$dz_res['header_theme'] = isset( $page_settings['page_header_theme'] ) ? $page_settings['page_header_theme'] : $dz_res['header_theme'];
		}

		/* Page banner setting */
			$dz_res['show_banner'] = isset( $page_settings['page_banner_on'] ) ? $page_settings['page_banner_on'] : $dz_res['show_banner'];

			$dz_res['banner_height'] = ! empty( $page_settings['page_banner_height'] ) ? $page_settings['page_banner_height'] : $dz_res['banner_height'];

			$dz_res['banner_custom_height'] = ! empty( $page_settings['page_banner_custom_height'] ) ? $page_settings['page_banner_custom_height'] : $dz_res['banner_custom_height'];

			$dz_res['dont_use_banner_image'] = w3construct_set( $page_settings, 'page_banner_hide', 0 );

		if ( 0 === $dz_res['dont_use_banner_image'] ) {
			$dz_res['banner_image'] = isset( $page_settings['page_general_banner'] ) ? w3construct_set( $page_settings['page_general_banner'], 'url', $dz_res['banner_image'] ) : $dz_res['banner_image'];
		} else {
			$dz_res['banner_image'] = '';
		}
		/* End page banner setting */

		/* Sidebar and there layout */
		$dz_res['show_sidebar'] = isset( $page_settings['page_show_sidebar'] ) ? $page_settings['page_show_sidebar'] : $dz_res['show_sidebar'];
		if ( $dz_res['show_sidebar'] ) {
			$dz_res['layout']  = w3construct_set( $page_settings, 'page_sidebar_layout', $dz_res['layout'] );
			$dz_res['sidebar'] = w3construct_set( $page_settings, 'page_sidebar', $dz_res['sidebar'] );
		}
		/* End Sidebar and there layout */

	}

	/*
	*
	* get post option in theme
	* single.php
	*
	*/
	if ( is_single() ) {

		$page_level_keys = array(
			'featured_post',
			'post_layout',
			'post_type_gallery1',
			'post_type_gallery2',
			'post_type_link',
			'post_type_video',
			'post_type_audio',
			'post_show_sidebar',
			'post_sidebar_layout',
			'post_header_setting',
			'post_header_theme',
			'post_header_style',
			'post_footer_setting',
			'post_footer_style',
			'post_sidebar',
		);
		foreach ( $page_level_keys as $value ) {
			$page_settings[ $value ] = w3construct_dzbase( $page_level_keys )->get_meta( $value );
		}

		$post_header_setting = ! empty( $page_settings['post_header_setting'] ) ? $page_settings['post_header_setting'] : 'theme_default';
		if ( 'custom' === $post_header_setting ) {
			$dz_res['header_theme'] = isset( $page_settings['post_header_theme'] ) ? $page_settings['post_header_theme'] : $dz_res['header_theme'];
		}

		$dz_res['is_featured_post'] = w3construct_dzbase()->get_meta( 'featured_post' );
		$post_layout                = w3construct_dzbase()->get_meta( 'post_layout' );
		$dz_res['post_layout']      = ( isset( $post_layout ) ) ? $post_layout : $dz_res['post_layout'];

		if ( 'slider_post_1' === $dz_res['post_layout'] ) {
			$dz_res['post_gallary_setting'] = w3construct_dzbase()->get_meta( 'post_type_gallery1' );
		}
		if ( 'slider_post_2' === $dz_res['post_layout'] ) {
			$dz_res['post_gallary_setting'] = w3construct_dzbase()->get_meta( 'post_type_gallery2' );
		}
		$dz_res['external_link'] = w3construct_dzbase()->get_meta( 'post_type_link' );
		$dz_res['youtube_link']  = w3construct_dzbase()->get_meta( 'post_type_video' );
		$dz_res['audio_link']    = w3construct_dzbase()->get_meta( 'post_type_audio' );

		/* Single post sidebar settings from post level. */
		if ( 'gutenberg' === $dz_res['post_layout'] ) {
			$dz_res['sidebar'] = '';
			$dz_res['layout']  = 'full';
		} else {
			/* Sidebar and there layout */
			$dz_res['show_sidebar'] = w3construct_set( $page_settings, 'post_show_sidebar', $dz_res['show_sidebar'] );
			if ( true === $dz_res['show_sidebar'] ) {
				$dz_res['layout']  = w3construct_set( $page_settings, 'post_sidebar_layout', $dz_res['layout'] );
				$dz_res['sidebar'] = w3construct_set( $page_settings, 'post_sidebar', $dz_res['sidebar'] );
			}
			/* End Sidebar and there layout */
		}
		/* Single post sidebar settings from post level end. */
		$dz_res['related_post_title'] = w3construct_set( $options, 'related_post_title', '' );
		$dz_res['layout_class']       = ( ! is_active_sidebar( $dz_res['sidebar'] ) || 'full' === $dz_res['layout'] || true !== $dz_res['show_sidebar'] || ! w3construct_is_theme_sidebar_active() ) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';
	}

	/*
	*
	*archive.php
	*
	*/
	if ( is_archive() ) {

		$options['archive_page_banner'] = '';
		$dz_res['page_title']           = w3construct_set( $options, 'archive_page_title', esc_html__( 'Archive : ', 'w3construct' ) );

		/* Page banner setting */
		$dz_res['show_banner']           = isset( $options['archive_page_banner_on'] ) ? $options['archive_page_banner_on'] : $dz_res['show_banner'];
		$dz_res['banner_height']         = w3construct_set( $options, 'archive_page_banner_height', $dz_res['banner_height'] );
		$dz_res['dont_use_banner_image'] = w3construct_set( $options, 'archive_page_banner_hide', '0' );

		$dz_res['banner_custom_height'] = w3construct_set( $options, 'archive_page_banner_custom_height', $dz_res['banner_custom_height'] );

		if ( 0 === $dz_res['dont_use_banner_image'] ) {
			$dz_res['banner_image'] = isset( $options['archive_page_banner'] ) ? w3construct_set( $options['archive_page_banner'], 'url', $dz_res['banner_image'] ) : $dz_res['banner_image'];
		} else {
			$dz_res['banner_image'] = '';
		}
		/* End Page banner setting */

		/* Sidebar and there layout */
		$dz_res['show_sidebar'] = isset( $options['archive_page_show_sidebar'] ) ? $options['archive_page_show_sidebar'] : true;
		if ( $dz_res['show_sidebar'] ) {
			$dz_res['layout']  = w3construct_set( $options, 'archive_page_sidebar_layout', $dz_res['layout'] );
			$dz_res['sidebar'] = w3construct_set( $options, 'archive_page_sidebar', $dz_res['sidebar'] );
		}
		/* End Sidebar and there layout */

		$pagination                        = w3construct_set( $options, 'archive_page_paging', $dz_res['disable_ajax_pagination'] );
		$dz_res['disable_ajax_pagination'] = ( 'load_more' === $pagination ) ? $pagination : '';
	}

	/*
	*
	* tag.php
	*
	*/
	if ( is_tag() ) {
		$options['tag_page_banner'] = '';
		$dz_res['page_title']       = w3construct_set( $options, 'tag_page_title', esc_html__( 'Tag : ', 'w3construct' ) );

		/* Tag banner setting */
		$dz_res['show_banner']           = isset( $options['tag_page_banner_on'] ) ? $options['tag_page_banner_on'] : $dz_res['show_banner'];
		$dz_res['banner_height']         = w3construct_set( $options, 'tag_page_banner_height', $dz_res['banner_height'] );
		$dz_res['dont_use_banner_image'] = w3construct_set( $options, 'tag_page_banner_hide', '0' );

		$dz_res['banner_custom_height'] = w3construct_set( $options, 'tag_page_banner_custom_height', $dz_res['banner_custom_height'] );

		if ( 0 === $dz_res['dont_use_banner_image'] ) {
			$dz_res['banner_image'] = isset( $options['tag_page_banner'] ) ? w3construct_set( $options['tag_page_banner'], 'url', $dz_res['banner_image'] ) : $dz_res['banner_image'];
		} else {
			$dz_res['banner_image'] = '';
		}
		/* End Tag banner setting */

		/* Sidebar and there layout */
		$dz_res['show_sidebar'] = isset( $options['tag_page_show_sidebar'] ) ? $options['tag_page_show_sidebar'] : true;
		if ( $dz_res['show_sidebar'] ) {
			$dz_res['layout']  = w3construct_set( $options, 'tag_page_sidebar_layout', $dz_res['layout'] );
			$dz_res['sidebar'] = w3construct_set( $options, 'tag_page_sidebar', $dz_res['sidebar'] );
		}
		/* End Sidebar and there layout */

		/* Enable and Disable Ajax Pagination */
		$pagination                        = w3construct_set( $options, 'tag_page_paging', $dz_res['disable_ajax_pagination'] );
		$dz_res['disable_ajax_pagination'] = ( 'load_more' === $pagination ) ? $pagination : '';
	}

	/*
	*
	* Get Author option
	* author.php
	*
	*/
	if ( is_author() ) {

		$options['author_page_banner'] = '';
		$dz_res['page_title']          = w3construct_set( $options, 'author_page_title', esc_html__( 'Author : ', 'w3construct' ) );
		$dz_res['page_title']          = $dz_res['page_title'] . get_the_author_meta( 'display_name' );

		/* Tag banner setting */

		$dz_res['show_banner'] = isset( $options['author_page_banner_on'] ) ? $options['author_page_banner_on'] : $dz_res['show_banner'];

		$dz_res['banner_height']         = w3construct_set( $options, 'author_page_banner_height', $dz_res['banner_height'] );
		$dz_res['dont_use_banner_image'] = w3construct_set( $options, 'author_page_banner_hide', '0' );

		$dz_res['banner_custom_height'] = w3construct_set( $options, 'author_page_banner_custom_height', $dz_res['banner_custom_height'] );

		if ( 0 === $dz_res['dont_use_banner_image'] ) {
			$dz_res['banner_image'] = isset( $options['author_page_banner'] ) ? w3construct_set( $options['author_page_banner'], 'url', $dz_res['banner_image'] ) : $dz_res['banner_image'];
		} else {
			$dz_res['banner_image'] = '';
		}
		/* End Tag banner setting */

		$dz_res['show_banner'] = w3construct_set( $options, 'author_page_banner_on', $dz_res['show_banner'] );
		if ( true === $dz_res['show_banner'] ) {
			$dz_res['banner_height']         = w3construct_set( $options, 'author_page_banner_height', $dz_res['banner_height'] );
			$dz_res['banner_image']          = w3construct_set( $options['author_page_banner'], 'url', $dz_res['banner_image'] );
			$dz_res['dont_use_banner_image'] = w3construct_set( $options, 'author_page_banner_hide', '0' );
		}

		/* Sidebar and there layout */
		$dz_res['show_sidebar'] = isset( $options['author_page_show_sidebar'] ) ? $options['author_page_show_sidebar'] : true;
		if ( $dz_res['show_sidebar'] ) {
			$dz_res['layout']  = w3construct_set( $options, 'author_page_sidebar_layout', $dz_res['layout'] );
			$dz_res['sidebar'] = w3construct_set( $options, 'author_page_sidebar', $dz_res['sidebar'] );
		}
		/* End Sidebar and there layout */

		$pagination                        = w3construct_set( $options, 'author_page_paging', $dz_res['disable_ajax_pagination'] );
		$dz_res['disable_ajax_pagination'] = ( 'load_more' === $pagination ) ? $pagination : '';
	}

	/*
	*
	* Get page Title
	* index.php
	*
	*/
	if ( is_home() ) {
		$dz_res['page_title'] = w3construct_set( $options, 'blog_page_title', esc_html__( 'W3Construct Personal Blog', 'w3construct' ) );
	}

	/*
	*
	* Get Search option
	* search.php
	*
	*/
	if ( is_search() ) {

		$options['search_page_banner'] = '';
		$dz_res['page_title']          = w3construct_set( $options, 'search_page_title', esc_html__( 'Search : ', 'w3construct' ) );

		/* Search banner setting */
		$dz_res['show_banner']           = isset( $options['search_page_banner_on'] ) ? $options['search_page_banner_on'] : $dz_res['show_banner'];
		$dz_res['banner_height']         = w3construct_set( $options, 'search_page_banner_height', $dz_res['banner_height'] );
		$dz_res['dont_use_banner_image'] = w3construct_set( $options, 'search_page_banner_hide', '0' );

		$dz_res['banner_custom_height'] = w3construct_set( $options, 'search_page_banner_custom_height', $dz_res['banner_custom_height'] );

		if ( 0 === $dz_res['dont_use_banner_image'] ) {
			$dz_res['banner_image'] = isset( $options['search_page_banner'] ) ? w3construct_set( $options['search_page_banner'], 'url', $dz_res['banner_image'] ) : $dz_res['banner_image'];
		} else {
			$dz_res['banner_image'] = '';
		}
		/* End Search banner setting */

		/* Sidebar and there layout */
		$dz_res['show_sidebar'] = isset( $options['search_page_show_sidebar'] ) ? $options['search_page_show_sidebar'] : true;
		if ( $dz_res['show_sidebar'] ) {
			$dz_res['layout']  = w3construct_set( $options, 'search_page_sidebar_layout', $dz_res['layout'] );
			$dz_res['sidebar'] = w3construct_set( $options, 'search_page_sidebar', $dz_res['sidebar'] );
		}
		/* End Sidebar and there layout */

		$pagination                        = w3construct_set( $options, 'search_page_paging', $dz_res['disable_ajax_pagination'] );
		$dz_res['disable_ajax_pagination'] = ( 'load_more' === $pagination ) ? $pagination : '';
	}

	/*
	*
	* Get multiple variable for All files
	*
	*/

	if ( is_page() || is_archive() || is_tag() || is_author() || is_home() || is_search() || is_404() ) {

		$dz_res['banner_class'] = '';
		if ( 'header_2' === $dz_res['header_style'] ) {
			$dz_res['banner_class'] .= ' tp-banner';
		}

		if ( isset( $dz_res['banner_height'] ) && 'page_banner_big' === $dz_res['banner_height'] ) {
			$dz_res['banner_class'] .= 'dlab-bnr-inr-md';
		} elseif ( isset( $dz_res['banner_height'] ) && 'page_banner_medium' === $dz_res['banner_height'] ) {
			$dz_res['banner_class'] .= 'dlab-bnr-inr-sm';
		}

		$dz_res['page_banner_style_attr'] = ! empty( $dz_res['banner_image'] ) ? 'background-image :url( ' . esc_url( $dz_res['banner_image'] ) . ' )' : '';

		$dz_res['container_class'] = ( ! is_active_sidebar( $dz_res['sidebar'] ) || 'full' === $dz_res['layout'] || true !== $dz_res['show_sidebar'] ) ? 'min-container' : 'container';
		$dz_res['layout_class']    = ( ! is_active_sidebar( $dz_res['sidebar'] ) || 'full' === $dz_res['layout'] || true !== $dz_res['show_sidebar'] || ! w3construct_is_theme_sidebar_active() ) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';

	}

	/*
	*
	* Get category option
	* category.php
	*
	*/
	if ( is_category() ) {

		$dz_res['banner_height']         = '';
		$dz_res['dont_use_banner_image'] = 0;
		$dz_res['page_title']            = w3construct_set( $options, 'category_page_title', esc_html__( 'Category : ', 'w3construct' ) );

		/* Search banner setting */
		$dz_res['show_banner']           = isset( $options['category_page_banner_on'] ) ? $options['category_page_banner_on'] : $dz_res['show_banner'];
		$dz_res['banner_height']         = w3construct_set( $options, 'category_page_banner_height', $dz_res['banner_height'] );
		$dz_res['dont_use_banner_image'] = w3construct_set( $options, 'category_page_banner_hide', '0' );

		$dz_res['banner_custom_height'] = w3construct_set( $options, 'category_page_banner_custom_height', $dz_res['banner_custom_height'] );

		if ( 0 === $dz_res['dont_use_banner_image'] ) {
			$dz_res['banner_image'] = isset( $options['category_page_banner'] ) ? w3construct_set( $options['category_page_banner'], 'url', $dz_res['banner_image'] ) : $dz_res['banner_image'];
		} else {
			$dz_res['banner_image'] = '';
		}
		/* End Search banner setting */

		/* Sidebar and there layout */
		$dz_res['show_sidebar'] = isset( $options['category_page_show_sidebar'] ) ? $options['category_page_show_sidebar'] : true;
		if ( $dz_res['show_sidebar'] ) {
			$dz_res['layout']  = w3construct_set( $options, 'category_page_sidebar_layout', $dz_res['layout'] );
			$dz_res['sidebar'] = w3construct_set( $options, 'category_page_sidebar', $dz_res['sidebar'] );
		}
		/* End Sidebar and there layout */

		/* To manage Category Page banner and layout settings */
		$dz_res['banner_class'] = '';
		if ( 'header_2' === $dz_res['header_style'] ) {
			$dz_res['banner_class'] .= ' tp-banner';
		}

		if ( isset( $dz_res['banner_height'] ) && 'page_banner_big' === $dz_res['banner_height'] ) {
			$dz_res['banner_class'] .= 'dlab-bnr-inr-md';
		} elseif ( isset( $dz_res['banner_height'] ) && 'page_banner_medium' === $dz_res['banner_height'] ) {
			$dz_res['banner_class'] .= 'dlab-bnr-inr-sm';
		}

		$dz_res['page_banner_style_attr'] = ! empty( $dz_res['banner_image'] ) ? 'background-image :url( ' . esc_url( $dz_res['banner_image'] ) . ' )' : '';

		$dz_res['container_class'] = ( ! is_active_sidebar( $dz_res['sidebar'] ) || 'full' === $dz_res['layout'] || true !== $dz_res['show_sidebar'] ) ? 'min-container' : 'container';
		$dz_res['layout_class']    = ( ! is_active_sidebar( $dz_res['sidebar'] ) || 'full' === $dz_res['layout'] || true !== $dz_res['show_sidebar'] || ! w3construct_is_theme_sidebar_active() ) ? ' col-lg-12 col-md-12 ' : ' col-lg-8 col-md-7 sidebar ';
		/* End To manage Category Page banner and layout settings */

		$pagination                        = w3construct_set( $options, 'category_page_paging', $dz_res['disable_ajax_pagination'] );
		$dz_res['disable_ajax_pagination'] = ( 'load_more' === $pagination ) ? $pagination : '';
		/* all other variable will manage on category page from db. */
	}

	/*
	*
	* 404.php
	*
	*/
	if ( is_404() ) {
		$dz_res['error_404_bg']           = w3construct_set( $options, 'error_404_bg' );
		$dz_res['error_404_bg']           = ! empty( $dz_res['error_404_bg']['url'] ) ? $dz_res['error_404_bg']['url'] : get_template_directory_uri() . '/assets/images/background/bg2.png';
		$dz_res['error_page_title']       = w3construct_set( $options, 'error_page_title', esc_html__( '404', 'w3construct' ) );
		$dz_res['error_page_subtitle']    = w3construct_set( $options, 'error_page_subtitle', esc_html__( 'Something went wrong !', 'w3construct' ) );
		$dz_res['error_page_search_on']   = w3construct_set( $options, 'error_page_search_on' );
		$dz_res['error_page_text']        = w3construct_set( $options, 'error_page_text', esc_html__( 'We are sorry. But the page you are looking for cannot be found . ', 'w3construct' ) );
		$dz_res['error_page_text2']       = w3construct_set( $options, 'error_page_text2', esc_html__( 'You can go back to the Main Page by clicking the button . ', 'w3construct' ) );
		$dz_res['error_page_button_text'] = w3construct_set( $options, 'error_page_button_text', esc_html__( 'Back to Home', 'w3construct' ) );
	}


	/* Set All Option Values to Global Variable */
	$w3construct_option = $dz_res;

	if ( 'live_mode' !== $w3construct_option['website_status'] && ! is_home() && ! is_front_page() && ! is_user_logged_in() ) {
		wp_safe_redirect( home_url( '/' ) );
	}

}

/**
 * Add theme CSS, JS enqueue scripts
 */
function w3construct_enqueue_scripts() {

	$options = w3construct_dzbase()->option();

	$skin               = w3construct_set( $options, 'predefined_color_skin', 'red' );
	$color_skin_setting = w3construct_set( $options, 'color_skin_setting', 'predefined_color_skin' );

	/* style */
	wp_enqueue_style( 'fontawesome', get_template_directory_uri() . '/assets/css/all-min.css', array(), '5.15.1' );
	wp_enqueue_style( 'themify-icons', get_template_directory_uri() . '/assets/css/themify-icons.css', array(), '1.0' );
	wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/assets/css/magnific-popup-min.css', array(), '1.0' );
	wp_enqueue_style( 'lightgallery', get_template_directory_uri() . '/assets/css/lightgallery-min.css', array(), '1.0' );
	wp_enqueue_style( 'line-awesome', get_template_directory_uri() . '/assets/css/line-awesome-min.css', array(), '1.0' );
	wp_enqueue_style( 'aos', get_template_directory_uri() . '/assets/css/aos.css', array(), '1.0' );
	wp_enqueue_style( 'swiper', get_template_directory_uri() . '/assets/css/swiper-bundle-min.css', array(), '6.5.0' );

	if ( is_child_theme() ) {
		wp_enqueue_style( 'w3construct-parent-style', get_template_directory_uri() . '/style.css', array(), '1.0' );
		wp_enqueue_style( 'w3construct-main-style', get_stylesheet_uri(), array(), '1.0' );
	} else {
		wp_enqueue_style( 'w3construct-main-style', get_stylesheet_uri(), array(), '1.0' );
	}

	wp_enqueue_style( 'w3construct-main', get_template_directory_uri() . '/assets/css/main.css', array(), '1.0' );
	wp_enqueue_style( 'w3construct-custom', get_template_directory_uri() . '/assets/css/custom.css', array(), '1.0' );
	/* scripts */
	wp_enqueue_script( 'jquery-ui-core' );
	wp_enqueue_script( 'bootstrap-bundle', get_template_directory_uri() . '/assets/js/bootstrap-bundle-min.js', array( 'jquery' ), '5.0.0', true );
	wp_enqueue_script( 'magnific-popup', get_template_directory_uri() . '/assets/js/magnific-popup-min.js', array( 'jquery' ), '1.1.0', true );
	wp_enqueue_script( 'counterup', get_template_directory_uri() . '/assets/js/counterup-min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'imagesloaded', '', array(), time(), true ); /* Pre-packaged Library */
	wp_enqueue_script( 'masonry', '', array(), time(), true ); /* Pre-packaged Library */
	wp_enqueue_script( 'masonry-multiple', get_template_directory_uri() . '/assets/js/masonry-filter-multiple.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'light-gallery', get_template_directory_uri() . '/assets/js/lightgallery-all-min.js', array( 'jquery' ), '1.6.12', true );
	wp_enqueue_script( 'light-gallery-rebuild', get_template_directory_uri() . '/assets/js/rebuildLightGallery.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'countdown', get_template_directory_uri() . '/assets/js/jquery-countdown.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'waypoint', get_template_directory_uri() . '/assets/js/waypoints-min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'swiper', get_template_directory_uri() . '/assets/js/swiper-bundle-min.js', array( 'jquery' ), '6.5.0', true );
	wp_enqueue_script( 'aos', get_template_directory_uri() . '/assets/js/aos-min.js', array(), time(), true );
	wp_enqueue_script( 'w3construct-main-script', get_template_directory_uri() . '/assets/js/custom.js', array(), '1.0', true );
	wp_enqueue_script( 'w3construct-wp-script', get_template_directory_uri() . '/assets/js/wp-script.js', array(), '1.0', true );
	wp_enqueue_script( 'w3construct-dz-carousel', get_template_directory_uri() . '/assets/js/dz-carousel.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'w3construct-lazyload', get_template_directory_uri() . '/assets/js/lazyload-min.js', array( 'jquery' ), '1.7.9', true );

	if ( is_singular() ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'w3construct_enqueue_scripts' );

/**
 * Add theme font URL
 */
function w3construct_theme_slug_fonts_url() {
	$fonts_url = '';

	/** Translators: If there are characters in your language that are not
	 * supported by Lora, translate this to 'off'. Do not translate
	 * into your own language.
	 */

	$montserrat = _x( 'on', 'Montserrat font: on or off', 'w3construct' );
	$oswald     = _x( 'on', 'Oswald font: on or off', 'w3construct' );

	$font_families = array();

	if ( 'off' !== $montserrat ) {
		$font_families[] = 'Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900';
	}

	if ( 'off' !== $oswald ) {
		$font_families[] = '&family=Oswald:wght@200;300;400;500;600;700';
	}

	$font_families   = array_unique( $font_families );
	$font_url_string = '';
	foreach ( $font_families as $font_family ) {
		$font_url_string .= $font_family;
	}

	$query_args = array(
		'family'  => $font_url_string,
		'display' => 'swap',
	);

	$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css2' );
	return esc_url_raw( $fonts_url );
}

/**
 * Get font URL
 * Add font CSS
 */
function w3construct_theme_slug_scripts_styles() {
	wp_enqueue_style( 'w3construct-theme-slug-fonts', w3construct_theme_slug_fonts_url(), array(), time(), null );

}
add_action( 'wp_enqueue_scripts', 'w3construct_theme_slug_scripts_styles' );

/**
 * Add default editor css
 */
function w3construct_add_editor_styles() {
	add_editor_style( 'custom-editor-style.css' );
}
add_action( 'admin_init', 'w3construct_add_editor_styles' );

/**
* Add custom icon css
*/
add_action( 'init', 'w3construct_custom_icon' );

/**
 * Registers custom icons for KingComposer sections.
 *
 * This function checks if the 'kc_add_icon' function exists, which is typically
 * provided by a page builder like KingComposer. If available, it adds custom icons
 * from a specified CSS file. These icons can be used to enhance the visual representation
 * of sections created with KingComposer.
 *
 * @since 1.0.3
 */
function w3construct_custom_icon() {
	if ( function_exists( 'kc_add_icon' ) ) {
		kc_add_icon( get_template_directory_uri() . '/assets/css/kc-custom.css' ); /*added to show custom icons/ images for kc sections */
	}
}

/**
 * Add theme support
 */
function w3construct_setup_theme_supported_features() {
	add_theme_support(
		'editor-color-palette',
		array(
			array(
				'name'  => esc_html__( 'strong magenta', 'w3construct' ),
				'slug'  => 'strong-magenta',
				'color' => '#a156b4',
			),
			array(
				'name'  => esc_html__( 'light grayish magenta', 'w3construct' ),
				'slug'  => 'light-grayish-magenta',
				'color' => '#d0a5db',
			),
			array(
				'name'  => esc_html__( 'very light gray', 'w3construct' ),
				'slug'  => 'very-light-gray',
				'color' => '#eee',
			),
			array(
				'name'  => esc_html__( 'very dark gray', 'w3construct' ),
				'slug'  => 'very-dark-gray',
				'color' => '#444',
			),
		)
	);
}

add_action( 'after_setup_theme', 'w3construct_setup_theme_supported_features' );

/**
 * Js Template Path
 * Pass js file variable
 */
function w3construct_set_js_var() {

	global $w3construct_option;

	$theme_options = w3construct_get_theme_option();

	$mobile_header_social_link_on = w3construct_set( $w3construct_option, 'mobile_header_social_link_on' );

	$mobile_header_login_on    = w3construct_set( $theme_options, 'mobile_header_login_on' );
	$mobile_header_register_on = w3construct_set( $theme_options, 'mobile_header_register_on' );

	$mobile_header_login_on       = ( $mobile_header_login_on ) ? 'Yes' : 'No';
	$mobile_header_register_on    = ( $mobile_header_register_on ) ? 'Yes' : 'No';
	$mobile_header_social_link_on = ( $mobile_header_social_link_on ) ? 'Yes' : 'No';

	$header_style       = '';
	$footer_style       = '';
	$page_banner_layout = '';
	$skin               = '';

	$js_data_array = array(
		'template_directory_uri'       => get_template_directory_uri(),
		'admin_ajax_url'               => admin_url( 'admin-ajax.php' ),
		'ajax_security_nonce'          => wp_create_nonce( 'ajax_security_key' ),
		'login_on_mobile'              => $mobile_header_login_on,
		'register_on_mobile'           => $mobile_header_register_on,
		'header_social_link_on_mobile' => $mobile_header_social_link_on,
		'header_style'                 => $header_style,
		'footer_style'                 => $footer_style,
		'page_banner_layout'           => $page_banner_layout,
		'skin'                         => $skin,
	);

	wp_localize_script( 'jquery', 'w3construct_js_data', $js_data_array );
}
	add_action( 'wp_enqueue_scripts', 'w3construct_set_js_var' );


/**
 * Load admin js and css
 */
function w3construct_load_admin_things() {
	wp_enqueue_script( 'media-upload' );
	wp_enqueue_script( 'thickbox' );
	wp_enqueue_style( 'thickbox' );
}
add_action( 'admin_enqueue_scripts', 'w3construct_load_admin_things' );

/**
 * Retrieve image attributes for a given attachment.
 *
 * @param int $attachment_id The ID of the attachment.
 * @return array Associative array containing image attributes.
 */
function w3construct_get_attachment( $attachment_id ) {
	$attachment = get_post( $attachment_id );
	return array(
		'alt'         => get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true ),
		'caption'     => $attachment->post_excerpt,
		'description' => $attachment->post_content,
		'href'        => get_permalink( $attachment->ID ),
		'src'         => $attachment->guid,
		'title'       => $attachment->post_title,
	);
}


/**
 *  Get website status for frontend
 */
function w3construct_website_status() {
	global $w3construct_option;
	$website_status = w3construct_set( $w3construct_option, 'website_status' );
	if ( 'comingsoon_mode' === $website_status && ! is_user_logged_in() ) {
		get_template_part( 'dz-inc/elements/comingsoon/comingsoon-1' );
	} elseif ( 'maintenance_mode' === $website_status && ! is_user_logged_in() ) {
		get_template_part( 'dz-inc/elements/maintinance/maintinance-1' );
	}
}

add_action( 'w3construct_website_status', 'w3construct_website_status' );



/** Remove Paragraph from contact form 7 plugin fields */
add_filter( 'wpcf7_autop_or_not', '__return_false' );


/**
 * Return Current Page ID
 */
function w3construct_get_current_page_id() {
	$current_page = -1;

	if ( is_front_page() && is_home() ) {
		$page_for_posts = get_option( 'page_for_posts' );
		if ( ! empty( $page_for_posts ) && -1 !== $page_for_posts ) {
			$current_page = $page_for_posts;
		}
	} elseif ( is_front_page() ) {
		$page_id = get_option( 'page_on_front' );
		if ( ! empty( $page_id ) && -1 !== $page_id ) {
			$current_page = $page_id;
		}
	} elseif ( is_home() ) {
		/* Blog page */
		$page_for_posts = get_option( 'page_for_posts' );
		if ( ! empty( $page_for_posts ) && -1 !== $page_for_posts ) {
			$current_page = $page_for_posts;
		}
	} elseif ( ( function_exists( 'is_projects_archive' ) && is_projects_archive() ) || ( function_exists( 'is_project_category' ) && is_project_category() ) ) {
		$projects_page_id = projects_get_page_id( 'projects' );
		if ( ! empty( $projects_page_id ) && -1 !== $projects_page_id ) {
			$current_page = projects_get_page_id( 'projects' );
		}
	} elseif ( is_post_type_archive( 'team-member' ) ) {
		$team_member = -1;
	} elseif ( function_exists( 'is_shop' ) && is_shop() ) {
		$current_page = get_option( 'woocommerce_shop_page_id' );
	} elseif ( function_exists( 'is_product_category' ) && is_product_category() ) {
		$current_page = get_option( 'woocommerce_shop_page_id' );
	} elseif ( function_exists( 'is_product_tag' ) && is_product_tag() ) {
		$current_page = get_option( 'woocommerce_shop_page_id' );
	} elseif ( function_exists( 'is_project' ) && is_project() ) {
		$current_page = get_the_ID();
	} elseif ( is_404() ) {
		$current_page = -2;
	} elseif ( is_page() ) {
		$current_page = get_the_ID();
	} elseif ( is_post_type_archive( 'post' ) ) {
		$page_for_posts = get_option( 'page_for_posts' );
		if ( ! empty( $page_for_posts ) && -1 !== $page_for_posts ) {
			$current_page = $page_for_posts;
		}
	}

	return $current_page;
}
