<?php
/**
 * W3Construct_DZ_Newsletter widget class
 *
 * @package W3Construct
 * @subpackage Widgets
 * @since 1.0.3
 */

if ( ! class_exists( 'W3Construct_DZ_Newsletter' ) ) {
	/** Newsletter */
	class W3Construct_DZ_Newsletter extends WP_Widget {

		/** Constructor */
		public function __construct() {
			parent::__construct( /* Base ID */'W3Construct_DZ_Newsletter', /* Name */esc_html__( 'W3Construct Footer Newsletter 1', 'w3construct' ), array( 'description' => esc_html__( 'Show the Newsletter', 'w3construct' ) ) );
		}

		/**
		 * Widget Function: widget
		 *
		 * This function is part of a custom WordPress widget and is responsible for rendering the widget's content on the frontend.
		 *
		 * @param array $args      An array of widget arguments, such as 'before_widget', 'after_widget', etc.
		 * @param array $instance  The settings for the widget instance.
		 * @return void
		 *
		 * @since 1.0.3
		 */
		public function widget( $args, $instance ) {
			$before_widget     = $args['before_widget'];
			$after_widget      = $args['after_widget'];
			$before_title      = $args['before_title'];
			$after_title       = $args['after_title'];
			$show_social_icon  = w3construct_get_opt( 'show_social_icon' );
			$allowed_html_tags = w3construct_allowed_html_tag();
			$title             = apply_filters( 'widget_title', $instance['title'] );
			echo wp_kses( $before_widget, $allowed_html_tags );

			/**
			 *
			 * Showing the HTML code for frontend
			 */
			?>
			<div>
				<?php echo wp_kses( $before_title . $title . $after_title, $allowed_html_tags ); ?>
				<p class="text m-b20">
					<?php echo wp_kses( $instance['content'], $allowed_html_tags ); ?>
				</p>
				<div class="ft-subscribe">
					<form class="dzSubscribe dz-subscription" action="#" method="post">
						<div class="dzSubscribeMsg dz-subscription-msg"></div>
						<div class="input-group">
							<input name="dzEmail" required="required" class="form-control"
								placeholder="<?php echo esc_attr__( 'Email Address', 'w3construct' ); ?>" type="email">
							<button name="submit" value="Submit" type="submit" class="btn btn-primary"><i
									class="fas fa-arrow-right"></i></button>
						</div>
					</form>
				</div>
			</div>
			<?php

			echo wp_kses( $after_widget, $allowed_html_tags );
		}


		/**
		 * Widget Function: update
		 *
		 * This function is part of a custom WordPress widget and is responsible for updating the widget's settings when saved by the user.
		 *
		 * @param array $new_instance  New settings for the widget.
		 * @param array $old_instance  Old settings for the widget.
		 * @return array              Updated settings for the widget.
		 *
		 * @since 1.0.3
		 */
		public function update( $new_instance, $old_instance ) {
			$instance            = $old_instance;
			$instance['title']   = wp_strip_all_tags( $new_instance['title'] );
			$instance['content'] = $new_instance['content'];
			return $instance;
		}

		/**
		 * Widget Function: form
		 *
		 * This function is part of a custom WordPress widget and is responsible for rendering the widget settings form in the admin area.
		 *
		 * @param array $instance  The current settings for the widget.
		 * @return void
		 *
		 * @since 1.0.3
		 */
		public function form( $instance ) {

			/**
			 * Resets properties to default values
			 *
			 * @return void
			 */
			$title   = ( $instance ) ? esc_attr( $instance['title'] ) : esc_html__( 'Our Newsletter', 'w3construct' );
			$content = ( $instance ) ? esc_attr( $instance['content'] ) : esc_html__( 'Nullam vel massa hendrerit libero auctor volutpat', 'w3construct' );
			?>

			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
					<?php esc_html_e( 'Title:', 'w3construct' ); ?>
				</label>
				<input placeholder="<?php esc_attr_e( 'Subscribe To Our Newsletter', 'w3construct' ); ?>" class="widefat"
					id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
					value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>">
					<?php esc_html_e( 'Contents:', 'w3construct' ); ?>
				</label>
				<textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>"><?php echo wp_kses_post( $content ); ?></textarea>
			</p>


			<?php
		}
	}
}
