<?php
/**
 * W3Construct_DZ_Contact_Us widget class
 *
 * @package W3Construct
 * @subpackage Widgets
 * @since 1.0.3
 */

if ( ! class_exists( 'W3Construct_DZ_Contact_Us' ) ) {
	/** Contact Us */
	class W3Construct_DZ_Contact_Us extends WP_Widget {
		/** Constructor */
		public function __construct() {
			parent::__construct( /* Base ID */'W3Construct_DZ_Contact_Us', /* Name */esc_html__( 'W3Construct Contact Us', 'w3construct' ), array( 'description' => esc_html__( 'Show the information about Contact', 'w3construct' ) ) );
		}

		/**
		 * Widget Function: widget
		 *
		 * This function is part of a custom WordPress widget that displays contact information such as phone number,
		 * email address, and office address. It renders the widget's content on the front end of the website.
		 *
		 * @param array $args     The arguments for rendering the widget (HTML tags and titles).
		 * @param array $instance The widget's instance settings, including the contact information.
		 *
		 * @since 1.0.3
		 */
		public function widget( $args, $instance ) {
			$before_widget = $args['before_widget'];
			$after_widget  = $args['after_widget'];
			$before_title  = $args['before_title'];
			$after_title   = $args['after_title'];
			$title         = apply_filters( 'widget_title', $instance['title'] );

			if ( strpos( $before_widget, 'footer-sidebar-1' ) ) {
				$before_widget = str_replace( 'col-lg-2', 'col-lg-4', $before_widget );
			}
			$before_widget = str_replace( 'substitute-class', 'widget_getintuch', $before_widget );

			$allowed_html_tags = w3construct_allowed_html_tag();

			echo wp_kses( $before_widget, $allowed_html_tags );

			/**
			 *
			 * Showing the HTML code for frontend
			 */
			?>

			<?php echo wp_kses( $before_title . $title . $after_title, $allowed_html_tags ); ?>
			<ul>

				<?php if ( ! empty( $instance['phone'] ) ) { ?>
					<li><i class="las la-phone"></i>
						<h5>
							<?php echo esc_html__( 'Phone Number', 'w3construct' ); ?>
						</h5>
						<?php echo wp_kses( $instance['phone'], 'string' ); ?>
					</li>

					<?php
				}
				if ( ! empty( $instance['email'] ) ) {
					?>
					<li><i class="las la-envelope"></i>
						<h5>
							<?php echo esc_html__( 'Email Address', 'w3construct' ); ?>
						</h5>
						<?php echo wp_kses( $instance['email'], 'string' ); ?>
					</li>

					<?php
				}
				if ( ! empty( $instance['address'] ) ) {
					?>
					<li><i class="las la-map-marker-alt"></i>
						<h5>
							<?php echo esc_html__( 'Office Address', 'w3construct' ); ?>
						</h5>
						<?php echo wp_kses( $instance['address'], 'string' ); ?>
					</li>

				<?php } ?>

			</ul>

			<?php
			echo wp_kses( $after_widget, $allowed_html_tags );
		}

		/**
		 * Update Function: update
		 *
		 * This function is part of a custom WordPress widget and is responsible for updating the widget's settings
		 * when changes are made in the WordPress admin interface. It sanitizes and validates the new instance settings,
		 * including the title, address, phone, and email, and returns the updated instance to be saved.
		 *
		 * @param array $new_instance The new widget settings provided by the user.
		 * @param array $old_instance The previous widget settings.
		 * @return array The updated and sanitized widget instance settings.
		 *
		 * @since 1.0.3
		 */
		public function update( $new_instance, $old_instance ) {
			$instance            = $old_instance;
			$instance['title']   = wp_strip_all_tags( $new_instance['title'] );
			$instance['address'] = $new_instance['address'];
			$instance['phone']   = $new_instance['phone'];
			$instance['email']   = $new_instance['email'];

			return $instance;
		}

		/**
		 * Form Function: form
		 *
		 * This function is part of a custom WordPress widget and is responsible for rendering the widget's settings form
		 * in the WordPress admin interface. It displays input fields for the widget's title, address, phone number, and email.
		 *
		 * @param array $instance The current widget instance settings.
		 * @return void
		 *
		 * @since 1.0.3
		 */
		public function form( $instance ) {
			/**
			 * Resets properties to default values
			 *
			 * @return void
			 */

			$title   = ( $instance ) ? esc_attr( $instance['title'] ) : esc_html__( 'CONTACT US', 'w3construct' );
			$address = ! empty( $instance['address'] ) ? $instance['address'] : '';
			$phone   = ! empty( $instance['phone'] ) ? $instance['phone'] : '';
			$email   = ! empty( $instance['email'] ) ? $instance['email'] : '';

			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
					<?php esc_html_e( 'Contact Us:', 'w3construct' ); ?>
				</label>
				<input placeholder="<?php esc_attr_e( 'Contact us', 'w3construct' ); ?>" class="widefat"
					id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
					value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>">
					<?php esc_html_e( 'Address Here:', 'w3construct' ); ?>
				</label>
				<textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'address' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'address' ) ); ?>"><?php echo wp_kses( $address, 'string' ); ?></textarea>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>">
					<?php esc_html_e( 'Phone Number Here:', 'w3construct' ); ?>
				</label>
				<input placeholder="<?php esc_attr_e( 'Enter number', 'w3construct' ); ?>" class="widefat"
					id="<?php echo esc_attr( $this->get_field_id( 'phone' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'phone' ) ); ?>" type="text"
					value="<?php echo esc_attr( $phone ); ?>" />
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>">
					<?php esc_html_e( 'Email Here:', 'w3construct' ); ?>
				</label>
				<input placeholder="<?php esc_attr_e( 'Enter email', 'w3construct' ); ?>" class="widefat"
					id="<?php echo esc_attr( $this->get_field_id( 'email' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'email' ) ); ?>" type="text"
					value="<?php echo esc_attr( $email ); ?>" />
			</p>

			<?php
		}
	}
}
