<?php
/**
 * W3Construct_DZ_About_Us widget class
 *
 * @package W3Construct
 * @subpackage Widgets
 * @since 1.0.3
 */

if ( ! class_exists( 'W3Construct_DZ_About_Us' ) ) {
	/** About Us */
	class W3Construct_DZ_About_Us extends WP_Widget {
		/** Constructor */
		public function __construct() {
			parent::__construct( /* Base ID */'W3Construct_DZ_About_Us', /* Name */esc_html__( 'W3Construct About Us', 'w3construct' ), array( 'description' => esc_html__( 'Show the information about company', 'w3construct' ) ) );
		}

		/**
		 * Widget Function: widget
		 *
		 * This function is part of a custom WordPress widget and is responsible for rendering the widget's content on the frontend.
		 * It displays the widget's title, content, and optional social icons.
		 *
		 * @param array $args      The widget arguments including before/after widget and title tags.
		 * @param array $instance  The current widget instance settings.
		 * @return void
		 *
		 * @since 1.0.3
		 */
		public function widget( $args, $instance ) {
			$before_widget     = $args['before_widget'];
			$after_widget      = $args['after_widget'];
			$before_title      = $args['before_title'];
			$after_title       = $args['after_title'];
			$allowed_html_tags = w3construct_allowed_html_tag();
			echo wp_kses( $before_widget, $allowed_html_tags );
			$show_social_icon = w3construct_get_opt( 'show_social_icon' );
			$title            = apply_filters( 'widget_title', $instance['title'] );

			/**
			 *
			 * Showing the HTML code for frontend
			 */
			?>
			<div class="widget widget_about">
				<?php echo wp_kses( $before_title . $title . $after_title, $allowed_html_tags ); ?>
				<p>
					<?php echo wp_kses( $instance['content'], 'string' ); ?>
				</p>
				<?php if ( $show_social_icon && $instance['social_icon'] ) { ?>
					<ul class="social-list style-2">
						<?php echo wp_kses( w3construct_get_social_icons(), w3construct_allowed_html_tag() ); ?>
					</ul>
				<?php } ?>
			</div>

			<?php
			echo wp_kses( $after_widget, $allowed_html_tags );
		}

		/**
		 * Widget Function: update
		 *
		 * This function is part of a custom WordPress widget and is responsible for updating the widget's settings when saved by the user.
		 *
		 * @param array $new_instance  New settings for the widget.
		 * @param array $old_instance  Old settings for the widget.
		 * @return array              Updated settings for the widget.
		 *
		 * @since 1.0.3
		 */
		public function update( $new_instance, $old_instance ) {
			$instance                = $old_instance;
			$instance['title']       = $new_instance['title'];
			$instance['content']     = $new_instance['content'];
			$instance['social_icon'] = $new_instance['social_icon'];

			return $instance;
		}

		/**
		 * Widget Function: form
		 *
		 * This function is part of a custom WordPress widget and is responsible for rendering the widget's admin form for setting widget options.
		 *
		 * @param array $instance  Current settings for the widget.
		 * @return void
		 *
		 * @since 1.0.3
		 */
		public function form( $instance ) {
			/**
			 * Resets properties to default values
			 *
			 * @return void
			 */

			$title       = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( 'About Us', 'w3construct' );
			$content     = ! empty( $instance['content'] ) ? $instance['content'] : esc_html__( 'We woke reasonably late following the feast and free flowing wine the night before. After gathering ourselves and our packs, we headed down to.', 'w3construct' );
			$social_icon = isset( $instance['social_icon'] ) ? esc_attr( $instance['social_icon'] ) : '';
			?>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>">
					<?php esc_html_e( 'Title :', 'w3construct' ); ?>
				</label>
				<input placeholder="<?php esc_attr_e( 'Title', 'w3construct' ); ?>" class="widefat"
					id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text"
					value="<?php echo esc_attr( $title ); ?>" />
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>">
					<?php esc_html_e( 'Content:', 'w3construct' ); ?>
				</label>
				<textarea class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'content' ) ); ?>"
					name="<?php echo esc_attr( $this->get_field_name( 'content' ) ); ?>"><?php echo wp_kses_post( $content ); ?></textarea>
			</p>
			<p>
				<label for="<?php echo esc_attr( $this->get_field_id( 'social_icon' ) ); ?>">
					<?php esc_html_e( 'Show Social Icons:', 'w3construct' ); ?>
				</label>
				<?php $selected = ( $social_icon ) ? ' checked="checked"' : ''; ?>
				<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'social_icon' ) ); ?>" <?php echo esc_attr( $selected ); ?> name="<?php echo esc_attr( $this->get_field_name( 'social_icon' ) ); ?>" type="checkbox"
					value="true" />
			</p>

			<?php
		}
	}
}
