<?php
/**
 *
 * Theme Information for W3Construct
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

/**
 * Custom WordPress navigation menu walker for generating a mega menu structure.
 *
 * The W3Construct_Mega_Menu_Walker extends the Walker_Nav_Menu class and is designed
 * to create a mega menu structure for your WordPress navigation menus. This class
 * enables you to build complex mega menus with multi-level submenus, custom styling,
 * and additional content.
 *
 * @link https://developer.wordpress.org/reference/classes/walker/
 *
 * @since 1.0.3
 */
class W3Construct_Mega_Menu_Walker extends Walker_Nav_Menu {
	/**
	 * Start element of the custom navigation menu walker.
	 *
	 * @param string   $output  (Required) The output buffer where the generated HTML is stored.
	 * @param WP_Post  $item     (Required) The menu item as a WordPress post object.
	 * @param int      $depth    (Optional) The depth of the current menu item (used for indentation).
	 * @param stdClass $args     (Optional) An object containing various arguments and settings.
	 * @param int      $id       (Optional) The unique ID of the current menu item.
	 */
	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		global $wp_query;
		$indent      = ( $depth ) ? str_repeat( "\t", $depth ) : '';
		$class_names = '';
		$value       = '';
		$classes     = empty( $item->classes ) ? array() : (array) $item->classes;
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
		$class_names = ' class="' . esc_attr( $class_names ) . '"';
		$output     .= $indent . '<li id="menu-item-' . esc_attr( $item->ID ) . '"' . esc_attr( $value ) . $class_names . '>';
		$attributes  = ! empty( $item->attr_title ) ? ' title="' . esc_attr( $item->attr_title ) . '"' : '';
		$attributes .= ! empty( $item->target ) ? ' target="' . esc_attr( $item->target ) . '"' : '';
		$attributes .= ! empty( $item->xfn ) ? ' rel="' . esc_attr( $item->xfn ) . '"' : '';
		$attributes .= ! empty( $item->url ) ? ' href="' . esc_attr( $item->url ) . '"' : '';
		$prepend     = '<strong>';
		$append      = '</strong>';
		$description = ! empty( $item->description ) ? '<span>' . esc_attr( $item->description ) . '</span>' : '';
		if ( 0 !== $depth ) {
			$description = '';
			$append      = '';
			$prepend     = '';
		}
		$item_output  = $args->before;
		$item_output .= '<a' . $attributes . '>';
		$item_output .= $args->link_before . $prepend . apply_filters( 'the_title', $item->title, $item->ID ) . $append;
		$item_output .= $description . $args->link_after;
		$item_output .= ' ' . $item->subtitle . '</a>';
		$item_output .= $args->after;

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}
}
