<?php
/**
 *
 * W3Construct_Custom_Mega_Menu
 *
 * @package     W3Construct
 * @author      W3ITEXPERTS
 * @copyright   Copyright (c) 2023, W3Construct
 * @link        http://w3construct-wordpress.wprdx.come/demo/
 * @since       W3Construct 1.0.1
 */

/**
 * Class Name: W3Construct_Custom_Mega_Menu
 * Description: Use for mega menu functionality
 */
class W3Construct_Custom_Mega_Menu {
	/**
	 * Initializes the plugin by setting localization, filters, and administration functions.
	 */
	public function __construct() {
		/* add custom menu fields to menu */
		add_filter( 'wp_setup_nav_menu_item', array( $this, 'mega_menu_add_custom_nav_fields' ) );
		/* save menu custom fields */
		add_action( 'wp_update_nav_menu_item', array( $this, 'mega_menu_update_custom_nav_fields' ), 10, 3 );
		/* edit menu walker */
		add_filter( 'wp_edit_nav_menu_walker', array( $this, 'mega_menu_edit_walker' ), 10, 2 );
	}
	/**
	 * Add custom fields to the menu item for custom menu walker.
	 *
	 * @param WP_Post $menu_item The menu item object.
	 * @since 1.0
	 */
	public function mega_menu_add_custom_nav_fields( $menu_item ) {
		$menu_item->mega_menu_cat = get_post_meta( $menu_item->ID, 'mega_menu_cat', true );
		return $menu_item;
	}
	/**
	 * Save custom menu fields for the mega menu.
	 *
	 * @param int   $menu_id        The menu ID.
	 * @param int   $menu_item_db_id The menu item database ID.
	 * @param array $args           An array of menu item arguments.
	 * @since 1.0
	 */
	public function mega_menu_update_custom_nav_fields( $menu_id, $menu_item_db_id, $args ) {
		if ( isset( $_REQUEST[ 'mega_menu_cat_' . $menu_item_db_id ] ) && check_admin_referer( 'my_nonce_action', 'my_nonce_field' ) ) {
			if ( is_array( $_REQUEST[ 'mega_menu_cat_' . $menu_item_db_id ] ) ) {
				$mega_menu_cat_array   = array_filter( array_map( 'sanitize_text_field', wp_unslash( $_REQUEST[ 'mega_menu_cat_' . $menu_item_db_id ] ) ) );
				$mega_menu_no_of_post  = isset( $_REQUEST[ 'mega_menu_no_of_post_' . $menu_item_db_id ] ) ? sanitize_text_field( wp_unslash( $_REQUEST[ 'mega_menu_no_of_post_' . $menu_item_db_id ] ) ) : ' ';
				$mega_menu_images_only = isset( $_REQUEST[ 'mega_menu_images_only_' . $menu_item_db_id ] ) ? sanitize_text_field( wp_unslash( $_REQUEST[ 'mega_menu_images_only_' . $menu_item_db_id ] ) ) : 'no';
				if ( count( $mega_menu_cat_array ) > 0 ) {
					$mega_menu_cat_value   = implode( ',', $mega_menu_cat_array );
					$mega_menu_cat_value   = wp_kses( $mega_menu_cat_value, 'string' );
					$mega_menu_no_of_post  = wp_kses( $mega_menu_no_of_post, 'string' );
					$mega_menu_images_only = wp_kses( $mega_menu_images_only, 'string' );
					update_post_meta( $menu_item_db_id, 'mega_menu_cat', $mega_menu_cat_value );
					update_post_meta( $menu_item_db_id, 'mega_menu_no_of_post', $mega_menu_no_of_post );
					update_post_meta( $menu_item_db_id, 'mega_menu_images_only', $mega_menu_images_only );
				} else {
					delete_post_meta( $menu_item_db_id, 'mega_menu_cat' );
					delete_post_meta( $menu_item_db_id, 'mega_menu_no_of_post' );
					delete_post_meta( $menu_item_db_id, 'mega_menu_images_only' );
				}
			}
		}
	}
	/**
	 * Define a new Walker for menu item editing.
	 *
	 * @param string $walker The name of the Walker class.
	 * @param int    $menu_id The ID of the menu.
	 * @since 1.0
	 */
	public function mega_menu_edit_walker( $walker, $menu_id ) {
		return 'W3Construct_Walker_Nav_Mega_Menu_Edit';
	}
}

new W3Construct_Custom_Mega_Menu();
get_template_part( 'dz-inc/library/mega_menu/class-w3construct-walker-nav-mega-menu-edit' );
get_template_part( 'dz-inc/library/mega_menu/class-w3construct-mega-menu-walker' );
